/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.Digests;
import cn.smarthse.common.util.Encodes;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.framework.encrypt.MD5;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.busilog.RecordOperationLog;
import cn.smarthse.modules.busilog.RecordOperationTypeEnum;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.enums.CompanyGradeReasonEnum;
import cn.smarthse.modules.datacentre.enums.CompanyIsBestEnum;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyStorageReasonEnum;
import cn.smarthse.modules.datacentre.enums.CompanyinspectionClassificationEnum;
import cn.smarthse.modules.datacentre.enums.SysParamGroupEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.ICompanyBaseInfoChangeRecordsProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ICompanyStorageProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.companyChange.v3.provider.ICompanyChangeV3ProviderService;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyDeclareModel;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.sys.SecUserRole;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.enums.staff.StaffAddFromEnum;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.service.base.company.CompanyReportInfoService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISecUserRoleService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.health.supervise.entity.statistics.DeclareAreaModel;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.model.CreateUserModel;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import cn.smarthse.modules.health.thirdOrganization.util.StringUtil;
import cn.smarthse.modules.health.vo.base.company.gradev3.ComBusinessCountVo;
import cn.smarthse.modules.health.vo.base.company.gradev3.GradeSearchV314;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.services.wanda.api.entity.WandaDeclareNeedImport;
import cn.smarthse.services.wanda.api.entity.WandaDictValue;
import cn.smarthse.services.wanda.api.model.WandaDeclareVo;
import cn.smarthse.services.wanda.api.service.IWandaDeclareNeedImportService;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaDeclareMapper;
import cn.smarthse.services.wanda.pulldata.mapper.WandaHealthCardMapper;
import cn.smarthse.services.wanda.pulldata.service.impl.BaseServiceImpl;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.dubbo.rpc.RpcContext;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.exception.ServiceException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class WandaDeclareServiceImpl
extends BaseServiceImpl<WandaDeclareMapper, WandaDeclare>
implements IWandaDeclareService {
    @Autowired
    private WandaHealthCardMapper wandaHealthCardMapper;
    @DubboReference
    private ISysUserService userService;
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference
    ISecUserRoleService secUserRoleService;
    @DubboReference(version="1.0.0")
    ICompanyStorageProvideService companyStorageProvideService;
    @Autowired
    IWandaDeclareNeedImportService wandaDeclareNeedImportService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ISysUserThirdService sysUserThirdService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    private IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @DubboReference
    private ICompanyBaseInfoChangeRecordsProviderService companyBaseInfoChangeRecordsProviderService;
    @DubboReference
    private ICompanyChangeV3ProviderService companyChangeV3ProviderService;
    @DubboReference
    private CompanyReportInfoService companyReportInfoService;
    @DubboReference
    private ISelfInspectionRiskAssessmentReportInfoService riskAssessmentReportInfoService;
    @DubboReference
    private ICompanyFunctionalOrganizationService functionalOrganizationService;
    @Autowired
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    private ICompanyGradeV3Service companyGradeV3Service;
    @Autowired
    protected IdWorker idworker;
    public Cache<String, List<WandaDictValue>> declareCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.DAYS).build();
    private static int repeatNum = 0;
    private static Map<String, Long> economicMap = null;
    @Autowired
    private RedisClient redisClient;
    public static final String HOME_GRADE_V3_CACHE_NAME = "Supervise-HomeGradeV3Controller";

    public void getDeclareCache() {
        this.declareCache.invalidateAll();
        this.declareCache.cleanUp();
        this.declareCache.put((Object)"\u7533\u62a5\u7c7b\u578b\u7f16\u7801", this.wandaHealthCardMapper.getDictValue("\u7533\u62a5\u7c7b\u578b\u7f16\u7801"));
        this.declareCache.put((Object)"\u4f01\u4e1a\u89c4\u6a21\u7f16\u7801", this.wandaHealthCardMapper.getDictValue("\u4f01\u4e1a\u89c4\u6a21\u7f16\u7801"));
        this.declareCache.put((Object)"\u884c\u4e1a\u7c7b\u522b\u7f16\u7801", this.wandaHealthCardMapper.getDictValue("\u884c\u4e1a\u7c7b\u522b\u7f16\u7801"));
        this.declareCache.put((Object)"\u7ecf\u6d4e\u7c7b\u578b\u7f16\u7801", this.wandaHealthCardMapper.getDictValue("\u7ecf\u6d4e\u7c7b\u578b\u7f16\u7801"));
    }

    public Date getMaxBizDate() {
        return ((WandaDeclareMapper)this.dao).getMaxBizDate();
    }

    @Transactional(readOnly=false)
    public int batchInsert(List<WandaDeclare> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        List<WandaDeclare> addList = this.delAndDistinct(list);
        if (CollectionUtils.isNotEmpty(addList)) {
            int i = this.batchUpdateOrInsert(addList, WandaDeclareMapper.class, (item, mapper) -> mapper.insert(item));
            ((WandaDeclareMapper)this.dao).updateCompanyIsReport(addList);
            this.logger.info("\u63d2\u5165\u4e86\uff1a{}\u6761\u6570\u636e", (Object)i);
            return i;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkAndAddCompanyInfo(List<WandaDeclare> list) {
        Iterator<WandaDeclare> iterator = list.iterator();
        while (true) {
            List userManager;
            String username;
            WandaDeclare wandaDeclare;
            block10: {
                block11: {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    wandaDeclare = iterator.next();
                    username = "";
                    if (!Objects.isNull(wandaDeclare.getCid())) break block11;
                    List<CompanySuperviseModel> cidByCode = this.getCidByCode(wandaDeclare.getCreditCode(), wandaDeclare.getEmpName());
                    if (CollectionUtils.isNotEmpty(cidByCode)) {
                        company = cidByCode.stream().filter(CompanyBaseInfoModel::getIsDec).findFirst().orElse(null);
                        if (company != null) {
                            wandaDeclare.setCid(company.getId());
                            break block10;
                        } else {
                            wandaDeclare.setCid(company.getId());
                            company.setIsDec(Boolean.valueOf(true));
                            this.setIsDecIsCurrentYear(wandaDeclare, company);
                            this.companyProvideBySuperviseService.updateCompanyBaseInfo(company, Long.valueOf(0L));
                            username = company.getName();
                        }
                        break block10;
                    } else {
                        company = this.convertInfo(wandaDeclare);
                        if (Objects.isNull(company)) {
                            this.logger.info("\u6570\u636e\u6709\u8bef\uff1a\u533a\u57dfId\uff1a{}\uff0c\u884c\u4e1a\u4ee3\u7801", (Object)wandaDeclare.getAreaCode(), (Object)wandaDeclare.getIndustryCode());
                            continue;
                        }
                        try {
                            company = this.companyProvideBySuperviseService.addCompanyInfo(company, Long.valueOf(0L));
                            wandaDeclare.setCid(company.getId());
                            username = company.getName();
                            break block10;
                        }
                        catch (Exception e) {
                            this.logger.info("e:{}", (Object)e.getMessage());
                            this.logger.info("\u4f01\u4e1a\u540d\u79f0\uff1a{},\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\uff1a{}", (Object)company.getName(), (Object)company.getUnifiedSocialCc());
                            continue;
                        }
                    }
                }
                if (!wandaDeclare.getIsDec().booleanValue()) {
                    CompanySuperviseModel company = this.companyProvideBySuperviseService.getCompanyInfoById(wandaDeclare.getCid());
                    company.setIsDec(Boolean.valueOf(true));
                    this.setIsDecIsCurrentYear(wandaDeclare, company);
                    this.companyProvideBySuperviseService.updateCompanyBaseInfo(company, Long.valueOf(0L));
                    username = company.getName();
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(userManager = this.userService.getUserManager(wandaDeclare.getCid())))) continue;
            this.createUser(username, wandaDeclare.getCid());
        }
    }

    private void checkAndImportCompany(List<WandaDeclare> list) {
        List newList = list.stream().sorted(Comparator.comparing(WandaDeclare::getDeclareTime).reversed()).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<WandaDeclare>(Comparator.comparing(WandaDeclare::getCreditCode))), ArrayList::new));
        HashSet<WandaDeclareNeedImport> importList = new HashSet<WandaDeclareNeedImport>();
        for (WandaDeclare wandaDeclare : newList) {
            List userManager;
            WandaDeclareNeedImport needImport;
            if (!StringUtils.isNotEmpty((String)wandaDeclare.getCreditCode()) || !Objects.nonNull(needImport = this.wandaDeclareNeedImportService.getByUnifiedSocialCc(wandaDeclare.getCreditCode()))) continue;
            wandaDeclare.setCreditCode(needImport.getUnifiedSocialCc());
            wandaDeclare.setEmpName(needImport.getCompanyName());
            List<CompanySuperviseModel> cidByCode = this.getCidByCode(needImport.getUnifiedSocialCc(), null);
            if (CollectionUtils.isNotEmpty(cidByCode)) {
                company = cidByCode.stream().filter(CompanyBaseInfoModel::getIsDec).findFirst().orElse(null);
                if (Objects.isNull(company)) {
                    company = cidByCode.get(0);
                    company.setIsDec(Boolean.valueOf(true));
                    company.setBusinessState(Byte.valueOf((byte)1));
                    company.setBelongType(Integer.valueOf(0));
                    company.setIsReport(Boolean.valueOf(true));
                    this.setIsDecIsCurrentYear(wandaDeclare, company);
                    this.companyProvideBySuperviseService.updateCompanyBaseInfo(company, Long.valueOf(0L));
                    wandaDeclare.setCid(company.getId());
                    needImport.setCid(company.getId());
                    importList.add(needImport);
                } else {
                    wandaDeclare.setCid(company.getId());
                    needImport.setCid(company.getId());
                    importList.add(needImport);
                }
            } else {
                company = this.convertInfo(wandaDeclare);
                if (Objects.isNull(company)) {
                    this.logger.info("\u6570\u636e\u6709\u8bef\uff1a\u533a\u57dfId\uff1a{}\uff0c\u884c\u4e1a\u4ee3\u7801", (Object)wandaDeclare.getAreaCode(), (Object)wandaDeclare.getIndustryCode());
                    continue;
                }
                try {
                    company = this.companyProvideBySuperviseService.addCompanyInfo(company, Long.valueOf(0L));
                    wandaDeclare.setCid(company.getId());
                    needImport.setCid(company.getId());
                    importList.add(needImport);
                }
                catch (Exception e) {
                    this.logger.info("e:{}", (Object)e.getMessage());
                    this.logger.info("\u4f01\u4e1a\u540d\u79f0\uff1a{},\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\uff1a{}", (Object)company.getName(), (Object)company.getUnifiedSocialCc());
                    continue;
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(userManager = this.userService.getUserManager(wandaDeclare.getCid())))) continue;
            this.createUser(needImport.getCompanyName(), wandaDeclare.getCid());
        }
        for (WandaDeclare declare : newList) {
            list.forEach(item -> {
                if (item.getCreditCode().equalsIgnoreCase(declare.getCreditCode())) {
                    item.setCid(declare.getCid());
                }
            });
        }
        this.wandaDeclareNeedImportService.updateBatchById(importList);
        this.batchUpdateOrInsert(list, WandaDeclareMapper.class, (item, mapper) -> mapper.updateByPrimaryKey(item));
    }

    private void setIsDecIsCurrentYear(WandaDeclare wandaDeclare, CompanySuperviseModel company) {
        Date date = DateUtils.parseDate((Object)"2023-01-01 00:00:00");
        if (date.before(wandaDeclare.getDeclareTime())) {
            company.setIsDecCurrentYear(Boolean.valueOf(false));
        } else {
            company.setIsDecCurrentYear(Boolean.valueOf(true));
        }
    }

    @Transactional(readOnly=false)
    public void refreshOldWandaDeclareData(String creditCode) {
        Example example = new Example(WandaDeclare.class);
        if (StringUtil.isEmpty((String)creditCode)) {
            List needImport = this.wandaDeclareNeedImportService.getNeedImportData(creditCode);
            Set set = needImport.stream().map(WandaDeclareNeedImport::getUnifiedSocialCc).collect(Collectors.toSet());
            example.createCriteria().andIn("creditCode", set);
        } else {
            example.createCriteria().andEqualTo("creditCode", (Object)creditCode);
        }
        example.orderBy("creditCode").desc().orderBy("loadTime").desc();
        List<WandaDeclare> list = this.getListByExample(example);
        this.checkAndImportCompany(list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    public void warehousingDeclare20240223(String creditCode) {
        List<String> badDataList = Arrays.asList("91330185MA2J163E37", "91330301MA2865RB6L", "92330324MA296B2R5J", "91330681MA2JQ91X0R", "91330400MA2JGRB41W", "91330185MA28M3647M", "91331023MA2HHAR75N", "91330421MA2JFKWT5T", "91330521MA7C7NM798", "91330185MAC37JBYX2", "91330802MABT8F6U10", "91330201MA282Q3Q1T", "91330301MA2865RB6L", "91330226MA2CK6357W", "913301042554697168", "91330382MA2L5JAP7E", "91330185MACBAJT93W", "913311263439919264", "91331081MA2K777P53", "91331081692362829X", "91330421551754351E", "91330383MA2HC3N9XQ", "91330185MA2HYK0W80", "91330203MA2H82WW0D");
        HashMap<String, String> updayeCrditCodeMap = new HashMap<String, String>();
        updayeCrditCodeMap.put("91330624MA7CG7XC58", "91330624MA7CGXC58");
        updayeCrditCodeMap.put("91330327MA7JKQJ24R", "92330327MA2C07PP4C");
        updayeCrditCodeMap.put("91330225MA7K01GR3A", "913302257503552653");
        updayeCrditCodeMap.put("91330226MA2J4B8B09", "91330226761489621N");
        updayeCrditCodeMap.put("91330206764524971G", "91330306764524971G");
        updayeCrditCodeMap.put("91330381MA7DNTCR3B", "92330381MA2HBDUR3M");
        updayeCrditCodeMap.put("91331081MA2AP4E065", "9133108MA2AP4E065");
        updayeCrditCodeMap.put("91330185MA28XQTL57", "91330185699809734Q");
        updayeCrditCodeMap.put("91331021MABWUB0690", "92331021MA28HHEY48");
        updayeCrditCodeMap.put("91330200053824361N", "91330200053824361M");
        updayeCrditCodeMap.put("91330226MA2J4LHN32", "913302265953673964");
        updayeCrditCodeMap.put("91330481MA2JHPCF87", "92330481MA2EW0F70Q");
        updayeCrditCodeMap.put("92330681MA2BEQ7P75", "92330681MA29DJHJ5A");
        updayeCrditCodeMap.put("91330302MACG6UFW5A", "91330302753970597M");
        updayeCrditCodeMap.put("91330300MA2J8U6E6M", "913303001450320890");
        updayeCrditCodeMap.put("91330500MA2B57269G", "91330522MA2B57269G");
        updayeCrditCodeMap.put("91330304MA2H9H503Y", "92330304MA2C1XWHXC");
        updayeCrditCodeMap.put("91331021MA2MA1LJ72", "92331021MA2AKRXW4R");
        ArrayList<WandaDeclare> updateList = new ArrayList<WandaDeclare>();
        List<WandaDeclare> list = ((WandaDeclareMapper)this.dao).getDeclare20240223List(creditCode, badDataList);
        for (WandaDeclare wandaDeclare : list) {
            List userManager;
            block7: {
                CompanySuperviseModel company;
                List<CompanySuperviseModel> cidByCode;
                block8: {
                    cidByCode = this.getCidByCode(wandaDeclare.getCreditCode(), null);
                    if (!CollectionUtils.isEmpty(cidByCode)) break block8;
                    if (updayeCrditCodeMap.containsKey(wandaDeclare.getCreditCode())) {
                        List<CompanySuperviseModel> modelList = this.getCidByCode((String)updayeCrditCodeMap.get(wandaDeclare.getCreditCode()), null);
                        wandaDeclare.setCid(modelList.get(0).getId());
                        ((WandaDeclareMapper)this.dao).updateCreditCode(wandaDeclare.getCreditCode(), (String)updayeCrditCodeMap.get(wandaDeclare.getCreditCode()));
                        updateList.add(wandaDeclare);
                        break block7;
                    } else {
                        company = this.convertInfoDECLARE_20240203(wandaDeclare);
                        try {
                            company = this.companyProvideBySuperviseService.addCompanyInfo(company, Long.valueOf(0L));
                            wandaDeclare.setCid(company.getId());
                            wandaDeclare.setIsImport(Boolean.valueOf(true));
                            updateList.add(wandaDeclare);
                            break block7;
                        }
                        catch (Exception e) {
                            this.logger.info("e:{}", (Object)e.getMessage());
                            this.logger.info("\u4f01\u4e1a\u540d\u79f0\uff1a{},\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\uff1a{}", (Object)company.getName(), (Object)company.getUnifiedSocialCc());
                            continue;
                        }
                    }
                }
                company = cidByCode.stream().filter(CompanyBaseInfoModel::getIsDec).findFirst().orElse(null);
                wandaDeclare.setCid(cidByCode.get(0).getId());
                if (Objects.isNull(company)) {
                    company = cidByCode.get(0);
                    company.setIsDec(Boolean.valueOf(true));
                    company.setBusinessState(Byte.valueOf((byte)1));
                    company.setBelongType(Integer.valueOf(0));
                    company.setIsReport(Boolean.valueOf(true));
                    company.setIsDecCurrentYear(Boolean.valueOf(true));
                    this.companyProvideBySuperviseService.updateCompanyBaseInfo(company, Long.valueOf(0L));
                    wandaDeclare.setCid(company.getId());
                    wandaDeclare.setIsImport(Boolean.valueOf(true));
                    updateList.add(wandaDeclare);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(userManager = this.userService.getUserManager(wandaDeclare.getCid())))) continue;
            this.createUser(wandaDeclare.getEmpName(), wandaDeclare.getCid());
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.batchUpdateOrInsert(updateList, WandaDeclareMapper.class, (item, mapper) -> mapper.updateCid((WandaDeclare)item));
            this.batchUpdateOrInsert(updateList, WandaDeclareMapper.class, (item, mapper) -> mapper.updateImportStatus((WandaDeclare)item));
        }
    }

    @Transactional
    public void importCompanyDeclare20240730(String creditCode) {
        List<WandaDeclare> list = ((WandaDeclareMapper)this.dao).getDeclare20240730List(creditCode);
        List<WandaDeclare> economicList = ((WandaDeclareMapper)this.dao).queryEconomicMapper();
        if (MapUtils.isEmpty(economicMap)) {
            economicMap = economicList.stream().collect(Collectors.toMap(WandaDeclare::getEconomic, WandaDeclare::getId, (o1, o2) -> o1));
        }
        List<String> creditCodeList = list.stream().map(WandaDeclare::getCreditCode).collect(Collectors.toList());
        Map<String, List<CompanySuperviseModel>> companyMap = this.getCompanyMapByCodes(creditCodeList);
        ArrayList<WandaDeclare> updateList = new ArrayList<WandaDeclare>();
        for (WandaDeclare wandaDeclare : list) {
            List userManager;
            block8: {
                List<CompanySuperviseModel> cidByCode = companyMap.get(wandaDeclare.getCreditCode());
                if (CollectionUtils.isEmpty(cidByCode)) {
                    this.logger.info("\u4f01\u4e1a\u540d\uff1a{}\uff0c\u4fe1\u7528\u4ee3\u7801\uff1a{} \u4e0d\u5b58\u5728\u7cfb\u7edf\uff0c\u6267\u884c\u5165\u5e93\u64cd\u4f5c", (Object)wandaDeclare.getEmpName(), (Object)wandaDeclare.getCreditCode());
                    CompanySuperviseModel company = this.convertInfoDECLARE_20240730(wandaDeclare);
                    try {
                        company.setGradeReason(CompanyGradeReasonEnum.DECLARATIONIMPORT.getValue());
                        company.setInsertCompanyType(Byte.valueOf((byte)3));
                        String operatorName = (String)RpcContext.getContext().getAttachments().get("operator_name");
                        RpcContext.getContext().setAttachment("operator_name", "\u5b9a\u65f6\u7533\u62a5\u4f01\u4e1a\u5165\u5e93");
                        company = this.companyProvideBySuperviseService.addCompanyInfo(company, Long.valueOf(0L));
                        RpcContext.getContext().setAttachment("operator_name", operatorName);
                        wandaDeclare.setCid(company.getId());
                        wandaDeclare.setIsImport(Boolean.valueOf(true));
                        updateList.add(wandaDeclare);
                        break block8;
                    }
                    catch (Exception e) {
                        this.logger.error("e:{}", (Object)e.getMessage());
                        this.logger.error("\u4f01\u4e1a\u540d\u79f0\uff1a{},\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\uff1a{}", (Object)company.getName(), (Object)company.getUnifiedSocialCc());
                        continue;
                    }
                }
                Map<String, CompanySuperviseModel> nameMap = cidByCode.stream().filter(c -> ObjectUtil.isNotNull((Object)c.getName())).collect(Collectors.toMap(CompanyBaseInfoModel::getName, c -> c, (c1, c2) -> c1));
                if (MapUtils.isEmpty(nameMap) || !nameMap.containsKey(wandaDeclare.getEmpName())) {
                    this.logger.error("\u8be5\u6761\u7533\u62a5\u6570\u636e\u5f02\u5e38,\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u91cd\u590d\u5e76\u4e14\u4e0d\u80fd\u5339\u914d\u5230\u540d\u79f0\u76f8\u540c\u7684\u4f01\u4e1a\uff1a\u4f01\u4e1a\u540d\u79f0\uff1a{},\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\uff1a{}", (Object)wandaDeclare.getEmpName(), (Object)wandaDeclare.getCreditCode());
                    continue;
                }
                CompanySuperviseModel companySuperviseModel = nameMap.get(wandaDeclare.getEmpName());
                if (ObjectUtil.isNotNull((Object)companySuperviseModel.getIsDec()) && companySuperviseModel.getIsDec().booleanValue()) {
                    this.logger.error("\u8be5\u6761\u7533\u62a5\u6570\u636e\u5f02\u5e38,\u8be5\u4f01\u4e1a\u5c5e\u4e8e\u76d1\u7ba1\u7cfb\u7edf\u53ef\u89c1\u4f01\u4e1a\uff1a\u4f01\u4e1a\u540d\u79f0\uff1a{},\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\uff1a{}", (Object)wandaDeclare.getEmpName(), (Object)wandaDeclare.getCreditCode());
                    continue;
                }
                wandaDeclare.setCid(companySuperviseModel.getId());
                CompanySuperviseModel company = ((WandaDeclareMapper)this.dao).getCompanyUpdateInfo(companySuperviseModel.getId());
                company.setIsDec(Boolean.valueOf(true));
                company.setBusinessState(Byte.valueOf((byte)1));
                company.setBelongType(Integer.valueOf(0));
                company.setIsReport(Boolean.valueOf(true));
                company.setIsDecCurrentYear(Boolean.valueOf(false));
                company.setIsDecOld(Boolean.valueOf(false));
                company.setIsSupervise(Boolean.valueOf(false));
                company.setDataSource(CompanyDataSourceEnum.DECLARE_IMPORT.getValue());
                company.setImportBatchNo(wandaDeclare.getImportBatchNo());
                this.setCompanyBaseInfoNew(wandaDeclare, company);
                company.setGradeReason(CompanyGradeReasonEnum.DECLARATIONIMPORT.getValue());
                company.setGradeCreateDate(new Date());
                this.companyProvideBySuperviseService.updateCompanyBaseInfoGrade(company, Long.valueOf(0L));
                wandaDeclare.setCid(company.getId());
                wandaDeclare.setIsImport(Boolean.valueOf(true));
                updateList.add(wandaDeclare);
            }
            if (!CollectionUtils.isEmpty((Collection)(userManager = this.userService.getUserManager(wandaDeclare.getCid())))) continue;
            this.createUser(wandaDeclare.getEmpName(), wandaDeclare.getCid());
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.batchUpdateOrInsert(updateList, WandaDeclareMapper.class, (item, mapper) -> mapper.updateCid((WandaDeclare)item));
            this.batchUpdateOrInsert(updateList, WandaDeclareMapper.class, (item, mapper) -> mapper.updateImportStatus((WandaDeclare)item));
        }
    }

    public void matchWandaDeclareHistoryDate(String code) {
        List<WandaDeclare> wandaDeclares = ((WandaDeclareMapper)this.dao).selectAllNotMatchWandaDeclare(code);
        if (CollectionUtils.isEmpty(wandaDeclares)) {
            this.logger.error("\u6ca1\u6709\u9700\u8981\u5339\u914d\u7684\u5386\u53f2\u4e07\u8fbe\u7533\u62a5\u6570\u636e");
            return;
        }
        Set codeList = wandaDeclares.stream().filter(w -> ObjectUtil.isNotNull((Object)w.getCreditCode())).map(WandaDeclare::getCreditCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(codeList)) {
            this.logger.error("\u6ca1\u6709\u9700\u8981\u5339\u914d\u7684\u5386\u53f2\u4e07\u8fbe\u7533\u62a5\u6570\u636e");
            return;
        }
        List<CompanySuperviseModel> companyByCodes = ((WandaDeclareMapper)this.dao).getCompanyByCodes(new ArrayList<String>(codeList));
        if (CollectionUtils.isEmpty(companyByCodes)) {
            this.logger.error("\u6ca1\u6709\u5339\u914d\u7684\u4f01\u4e1a\u4fe1\u606f");
            return;
        }
        Map<String, List<CompanySuperviseModel>> companyMap = companyByCodes.stream().collect(Collectors.groupingBy(CompanyBaseInfoModel::getUnifiedSocialCc));
        if (MapUtils.isEmpty(companyMap)) {
            this.logger.error("\u6ca1\u6709\u5339\u914d\u7684\u4f01\u4e1a\u4fe1\u606f");
            return;
        }
        ArrayList<WandaDeclare> updateList = new ArrayList<WandaDeclare>();
        for (WandaDeclare wandaDeclare : wandaDeclares) {
            List models;
            String creditCode = wandaDeclare.getCreditCode();
            List<CompanySuperviseModel> companySuperviseModelList = companyMap.get(creditCode);
            if (!CollectionUtils.isNotEmpty(companySuperviseModelList) || !CollectionUtils.isNotEmpty(models = companySuperviseModelList.stream().filter(c -> StringUtils.isNotEmpty((String)c.getName()) && c.getName().equals(wandaDeclare.getEmpName())).collect(Collectors.toList()))) continue;
            CompanySuperviseModel companySuperviseModel = models.stream().filter(CompanyBaseInfoModel::getIsDec).findFirst().orElse(null);
            if (Objects.nonNull(companySuperviseModel)) {
                wandaDeclare.setCid(companySuperviseModel.getId());
            } else {
                wandaDeclare.setCid(((CompanySuperviseModel)models.get(0)).getId());
            }
            updateList.add(wandaDeclare);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            ((WandaDeclareMapper)this.dao).updateCompanyIsReport(updateList);
            this.logger.error("\u5339\u914d\u4e07\u8fbe\u7533\u62a5\u6570\u636e\u6570" + updateList.size());
            for (WandaDeclare wandaDeclare : updateList) {
                ((WandaDeclareMapper)this.dao).updateCidById(wandaDeclare);
            }
        }
    }

    private CompanySuperviseModel setCompanyBaseInfoNew(WandaDeclare wandaDeclare, CompanySuperviseModel company) {
        List<Long> industryIds;
        List sysParamListByChildren;
        ArrayList collect;
        Map<String, SysParamModel> map;
        SysParamModel sysParamModel;
        AreaModel areaByName;
        company.setUnifiedSocialCc(wandaDeclare.getCreditCode());
        company.setName(wandaDeclare.getEmpName());
        if (StringUtils.isEmpty((CharSequence)company.getLegalTel())) {
            company.setLegalTel(wandaDeclare.getLegalPhone());
        }
        if (StringUtils.isEmpty((CharSequence)company.getLegalName())) {
            company.setLegalName(wandaDeclare.getLegalPerson());
        }
        if (StringUtils.isEmpty((CharSequence)company.getRegisterAddress())) {
            company.setRegisterAddress(wandaDeclare.getRegAddr());
        }
        if (StringUtils.isEmpty((CharSequence)company.getWorkAddress())) {
            company.setWorkAddress(wandaDeclare.getWorkAddrDetail());
        }
        if (StringUtils.isEmpty((CharSequence)company.getMainLeaderName())) {
            company.setMainLeaderName(wandaDeclare.getHealthManager());
        }
        if (StringUtils.isEmpty((CharSequence)company.getMainLeaderTel())) {
            company.setMainLeaderTel(wandaDeclare.getHealthManagerPhone());
        }
        if (StringUtils.isEmpty((CharSequence)company.getScale())) {
            company.setScale(this.getScaleByName(wandaDeclare.getEnterpriseSize()));
        }
        if ((areaByName = this.sysAreaProvideService.getAreaByName(wandaDeclare.getArea())) != null) {
            if (ObjectUtil.isNull((Object)company.getAreaId())) {
                company.setAreaId(areaByName.getId());
            }
            if (ObjectUtil.isNull((Object)company.getRegisterAddressRegionId())) {
                company.setRegisterAddressRegionId(areaByName.getId());
            }
        }
        if (ObjectUtil.isNull((Object)company.getIndustryCategory()) && (sysParamModel = (map = (collect = (sysParamListByChildren = this.sysParamProvideService.getSysParamListByChildren(SysParamGroupEnum.national_econ_type.getValue())).stream().sorted(Comparator.comparing(SysParamModel::getLevel).reversed()).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysParamModel>(Comparator.comparing(SysParamModel::getParamValue))), ArrayList::new))).stream().collect(Collectors.toMap(SysParamModel::getParamValue, k -> k))).get(wandaDeclare.getIndustry())) != null) {
            company.setIndustryCategory(sysParamModel.getId());
        }
        if (ObjectUtil.isNull((Object)company.getIndustryCategory()) && StringUtils.isNotEmpty((String)wandaDeclare.getIndustry()) && CollectionUtils.isNotEmpty(industryIds = ((WandaDeclareMapper)this.dao).selectIndustryList(wandaDeclare.getIndustry()))) {
            company.setIndustryCategory(industryIds.get(0));
        }
        if (ObjectUtil.isNull((Object)company.getRegisterType())) {
            Map<String, Long> registerTypeMap;
            List registerTypeList;
            Long aLong = economicMap.get(wandaDeclare.getEconomic());
            if (ObjectUtil.isNull((Object)aLong) && CollectionUtils.isNotEmpty((Collection)(registerTypeList = this.sysParamProvideService.getSysParamListByChildren(SysParamGroupEnum.register_type.getValue()))) && MapUtils.isNotEmpty(registerTypeMap = registerTypeList.stream().collect(Collectors.toMap(SysParamModel::getParamValue, SysParamModel::getId, (i1, i2) -> i1)))) {
                aLong = registerTypeMap.get(wandaDeclare.getEconomic());
            }
            company.setRegisterType(aLong);
        }
        return company;
    }

    @Transactional
    public void importCompanyWithReason(String creditCode) {
        List<CompanySuperviseModel> importList = ((WandaDeclareMapper)this.dao).queryimportCompanyWithReason(creditCode);
        ArrayList<CompanySuperviseModel> insertList = new ArrayList<CompanySuperviseModel>();
        ArrayList<CompanySuperviseModel> updateList = new ArrayList<CompanySuperviseModel>();
        ArrayList<CompanyBaseInfoModel> reasonList = new ArrayList<CompanyBaseInfoModel>();
        ArrayList<CompanyReportInfo> reportInfoList = new ArrayList<CompanyReportInfo>();
        List sysParamListByChildren = this.sysParamProvideService.getSysParamListByChildren(SysParamGroupEnum.register_type.getValue());
        Map<String, Long> registerMap = sysParamListByChildren.stream().collect(Collectors.toMap(SysParamModel::getParamValue, SysParamModel::getId, (oldValue, newValue) -> newValue));
        List<SysParamModel> industryMappingList = ((WandaDeclareMapper)this.dao).queryIndustryMapping();
        Map<String, Long> industryMappingMap = industryMappingList.stream().collect(Collectors.toMap(SysParamModel::getParamCode, SysParamModel::getId, (oldValue, newValue) -> newValue));
        List<SysParamModel> areaMappingList = ((WandaDeclareMapper)this.dao).queryAreaMapping();
        Map<String, Long> areaMap = areaMappingList.stream().collect(Collectors.toMap(SysParamModel::getParamCode, SysParamModel::getId, (oldValue, newValue) -> newValue));
        if (CollectionUtils.isNotEmpty(importList)) {
            List userManager;
            List<String> unifiedSocialCcList;
            List<String> UnifiedSocialCcList = importList.stream().map(CompanyBaseInfoModel::getUnifiedSocialCc).distinct().collect(Collectors.toList());
            Map<String, List<CompanySuperviseModel>> companyMap = this.getCompanyMapByCodes(UnifiedSocialCcList);
            for (CompanySuperviseModel companySuperviseModel : importList) {
                List<CompanySuperviseModel> companyList = companyMap.get(companySuperviseModel.getUnifiedSocialCc());
                if (CollectionUtils.isEmpty(companyList)) {
                    Long cid = this.idworker.nextId();
                    companySuperviseModel.setId(cid);
                    companySuperviseModel.setAreaId(areaMap.get(companySuperviseModel.getAreaName()));
                    companySuperviseModel.setRegisterAddressRegionId(areaMap.get(companySuperviseModel.getRegisterAreaName()));
                    companySuperviseModel.setRegisterType(registerMap.get(companySuperviseModel.getRegisterTypeName()));
                    companySuperviseModel.setIndustryCategory(industryMappingMap.get(companySuperviseModel.getIndustryCategoryName()));
                    if (companySuperviseModel.getBusinessStateNameStr().equals("\u5173\u95ed")) {
                        companySuperviseModel.setBusinessState(Byte.valueOf((byte)0));
                    } else if (companySuperviseModel.getBusinessStateName().equals("\u6b63\u5e38\u8425\u4e1a")) {
                        companySuperviseModel.setBusinessState(Byte.valueOf((byte)1));
                    }
                    companySuperviseModel.setScale(this.getScaleByName(companySuperviseModel.getScaleNameStr()));
                    CompanyReportInfo reportInfo = new CompanyReportInfo();
                    companySuperviseModel.setIsDec(Boolean.valueOf(true));
                    companySuperviseModel.setDataSource(CompanyDataSourceEnum.SUPERVISE.getValue());
                    companySuperviseModel.setImportBatchNo("2024-12-26 \u4e3e\u62a5\u6295\u8bc9\u5165\u5e93");
                    reportInfo.setId(Long.valueOf(this.idworker.nextId()));
                    reportInfo.setCid(cid);
                    reportInfo.setLegalCardId(companySuperviseModel.getLegalIdCard());
                    if (StringUtils.isNotBlank((CharSequence)companySuperviseModel.getLegalIdCardType())) {
                        switch (companySuperviseModel.getLegalIdCardType()) {
                            case "\u5c45\u6c11\u8eab\u4efd\u8bc1": {
                                reportInfo.setLegalCardType(Integer.valueOf(1));
                                break;
                            }
                            case "\u62a4\u7167": {
                                reportInfo.setLegalCardType(Integer.valueOf(2));
                                break;
                            }
                            case "\u6e2f\u6fb3\u53f0\u5c45\u6c11\u901a\u884c\u8bc1": {
                                reportInfo.setLegalCardType(Integer.valueOf(3));
                                break;
                            }
                            case "\u56de\u4e61\u8bc1": {
                                reportInfo.setLegalCardType(Integer.valueOf(4));
                                break;
                            }
                            case "\u519b\u5b98\u8bc1": {
                                reportInfo.setLegalCardType(Integer.valueOf(5));
                            }
                        }
                    }
                    reportInfo.setManageMajorStaffCount(companySuperviseModel.getManageMajorStaffCount());
                    reportInfo.setManagePluralityStaffCount(companySuperviseModel.getManageMajorStaffCount());
                    reportInfoList.add(reportInfo);
                    insertList.add(companySuperviseModel);
                } else {
                    CompanySuperviseModel company = companyList.stream().filter(CompanyBaseInfoModel::getIsDec).findFirst().orElse(null);
                    if (company != null) {
                        this.logger.error("\u5df2\u5b58\u5728\u5206\u7c7b\u5bf9\u8c61\uff0c\u8df3\u8fc7\uff1a{},{}", (Object)company.getName(), (Object)company.getUnifiedSocialCc());
                        continue;
                    }
                    company = companyList.get(0);
                    companySuperviseModel.setId(company.getId());
                    companySuperviseModel.setIsDec(Boolean.valueOf(true));
                    companySuperviseModel.setDataSource(CompanyDataSourceEnum.SUPERVISE.getValue());
                    companySuperviseModel.setImportBatchNo("2024-12-26 \u4e3e\u62a5\u6295\u8bc9\u5165\u5e93");
                    updateList.add(companySuperviseModel);
                }
                CompanyBaseInfoModel companyModel = new CompanyBaseInfoModel();
                companyModel.setCid(companySuperviseModel.getId());
                companyModel.setStorageReason(CompanyStorageReasonEnum.REPORTCOMPLAINTS.getValue());
                reasonList.add(companyModel);
            }
            if (CollectionUtils.isNotEmpty(insertList)) {
                this.logger.error("\u672c\u6b21\u5165\u5e93{}\u5bb6\u4f01\u4e1a", (Object)insertList.size());
                this.companyProvideBySuperviseService.saveCompanyAndCompanySuperviseByList(insertList, Long.valueOf(0L));
                unifiedSocialCcList = insertList.stream().map(CompanyBaseInfoModel::getUnifiedSocialCc).distinct().collect(Collectors.toList());
                ((WandaDeclareMapper)this.dao).setIsImport(unifiedSocialCcList);
                for (CompanySuperviseModel model : insertList) {
                    userManager = this.userService.getUserManager(model.getId());
                    if (!CollectionUtils.isEmpty((Collection)userManager)) continue;
                    this.createUser(model.getName(), model.getId());
                }
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                this.logger.error("\u672c\u6b21\u66f4\u65b0{}\u5bb6\u4f01\u4e1a", (Object)updateList.size());
                this.companyProvideBySuperviseService.updateCompanyAndCompanySuperviseByList(updateList, Long.valueOf(0L));
                unifiedSocialCcList = updateList.stream().map(CompanyBaseInfoModel::getUnifiedSocialCc).distinct().collect(Collectors.toList());
                ((WandaDeclareMapper)this.dao).setIsImport(unifiedSocialCcList);
                for (CompanySuperviseModel model : updateList) {
                    userManager = this.userService.getUserManager(model.getId());
                    if (!CollectionUtils.isEmpty((Collection)userManager)) continue;
                    this.createUser(model.getName(), model.getId());
                }
            }
            if (CollectionUtils.isNotEmpty(reportInfoList)) {
                ((WandaDeclareMapper)this.dao).insertCompanyReportList(reportInfoList);
            }
            if (CollectionUtils.isNotEmpty(reasonList)) {
                this.companyStorageProvideService.saveOrUpdateCompanyStorageBatch(reasonList, Long.valueOf(0L), Boolean.valueOf(true));
            }
        }
    }

    private Map<String, List<CompanySuperviseModel>> getCompanyMapByCodes(List<String> creditCodeList) {
        List<CompanySuperviseModel> list = ((WandaDeclareMapper)this.dao).getCompanyByCodes(creditCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.groupingBy(CompanyBaseInfoModel::getUnifiedSocialCc));
    }

    public Map<Long, Integer> countByCids(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyMap();
        }
        List<WandaDeclare> list = ((WandaDeclareMapper)this.dao).countByCids(cids);
        return list.stream().collect(Collectors.toMap(WandaDeclare::getCid, WandaDeclare::getCount));
    }

    public List<ComplianceCompanyDeclareModel> getComplianceCompanyDeclareModel(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        List<WandaDeclare> listByExample = this.getListByCidList(cids);
        Map<Long, List<WandaDeclare>> declareMap = listByExample.stream().collect(Collectors.groupingBy(WandaDeclare::getCid));
        ArrayList<ComplianceCompanyDeclareModel> list = new ArrayList<ComplianceCompanyDeclareModel>();
        for (Long cid : declareMap.keySet()) {
            List declareTypeList;
            List<WandaDeclare> declareList = declareMap.get(cid);
            WandaDeclare wandaDeclare = declareList.stream().sorted(Comparator.comparing(WandaDeclare::getDeclareTime).reversed()).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<WandaDeclare>(Comparator.comparing(WandaDeclare::getCreditCode))), ArrayList::new)).stream().findFirst().orElse(null);
            Date declareTime = wandaDeclare.getDeclareTime();
            ComplianceCompanyDeclareModel model = new ComplianceCompanyDeclareModel();
            model.setCid(cid);
            model.setDeclareId(wandaDeclare.getId());
            model.setLastDeclareTime(declareTime);
            model.setLastDeclareYear(wandaDeclare.getDeclareYear());
            boolean isYearlyUpdate = declareList.stream().anyMatch(d -> "2024".equalsIgnoreCase(d.getDeclareYear()));
            model.setIsYearlyUpdate(Boolean.valueOf(isYearlyUpdate));
            if (this.declareCache.estimatedSize() == 0L) {
                this.getDeclareCache();
            }
            if (CollectionUtils.isNotEmpty((Collection)(declareTypeList = (List)this.declareCache.getIfPresent((Object)"\u7533\u62a5\u7c7b\u578b\u7f16\u7801")))) {
                for (WandaDictValue wandaDictValue : declareTypeList) {
                    if (!wandaDictValue.getValue().equalsIgnoreCase(wandaDeclare.getDeclareType())) continue;
                    model.setDeclareType(wandaDictValue.getValueLabel());
                }
                WandaDeclare dc = declareList.stream().filter(d -> "1".equalsIgnoreCase(d.getDeclareType())).findFirst().orElse(null);
                model.setHasChange(Boolean.valueOf(Objects.nonNull(dc)));
            }
            list.add(model);
        }
        return list;
    }

    public List<WandaDeclare> getListByCidList(List<Long> cidList) {
        Example example = new Example(WandaDeclare.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIn("cid", cidList);
        return this.getListByExample(example);
    }

    public List<WandaDeclare> getListByCreditCodeList(List<String> creditCodeList) {
        if (CollectionUtils.isEmpty(creditCodeList)) {
            return Collections.emptyList();
        }
        Example example = new Example(WandaDeclare.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIn("creditCode", creditCodeList);
        return this.getListByExample(example);
    }

    @Transactional
    public int updateCidBatch(List<WandaDeclare> list) {
        return this.batchUpdateOrInsert(list, WandaDeclareMapper.class, (item, mapper) -> mapper.updateCid((WandaDeclare)item));
    }

    public DeclareAreaModel statisticsDeclareAreaHeadData(SearchParam searchParam) {
        return ((WandaDeclareMapper)this.dao).statisticsDeclareAreaHeadData(searchParam);
    }

    public DeclareAreaModel processHeadOtherFieldsNeedReturn(DeclareAreaModel declareHead, GradeSearchV314 searchAll, GradeSearchV314 searchPass) {
        if (declareHead != null) {
            int allCnt = Optional.ofNullable(this.companyGradeV3Service.getBusinessStateComCount(searchAll).getTotalCount()).orElse(0);
            int passCnt = Optional.ofNullable(this.companyGradeV3Service.getBusinessStateComCount(searchPass).getTotalCount()).orElse(0);
            declareHead.setNeedClassNewDeclareCompanyNum(Integer.valueOf(declareHead.getMore3NUm() + declareHead.getNullNum()));
            declareHead.setDeclareCompanyClassCompleteNum(Integer.valueOf(passCnt));
            allCnt = declareHead.getNeedClassNewDeclareCompanyNum();
            declareHead.setDeclareCompanyClassCompleteRate((String)(allCnt == 0 ? "0.00%" : String.valueOf(new BigDecimal(passCnt).divide(new BigDecimal(allCnt), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP)) + "%"));
        }
        return declareHead;
    }

    public List<DeclareAreaModel> statisticsDeclareAreaListData(SearchParam searchParam) {
        return ((WandaDeclareMapper)this.dao).statisticsDeclareAreaListData(searchParam);
    }

    public PageInfo<DeclareAreaModel> statisticsDeclareAreaListPage(SearchParam searchParam) {
        List<Long> cids;
        Byte level = searchParam.getLevel();
        if (ObjectUtil.isNotNull((Object)level) && level > 3) {
            return new PageInfo();
        }
        if (ObjectUtil.isNotNull((Object)level) && level.equals(new Byte("2")) && (cids = ((WandaDeclareMapper)this.dao).judgeContainCompanyType(searchParam)).size() > 0) {
            searchParam.setContainCompanyType(Boolean.valueOf(true));
        }
        PageHelper.startPage((int)searchParam.getPageNum(), (int)searchParam.getPageSize());
        return new PageInfo(this.statisticsDeclareAreaListData(searchParam));
    }

    public PageInfo<DeclareAreaModel> processListOtherFieldsNeedReturn(PageInfo<DeclareAreaModel> declarePage, GradeSearchV314 searchAll, GradeSearchV314 searchPass) {
        List declareList = declarePage.getList();
        if (CollUtil.isEmpty((Collection)declareList)) {
            return declarePage;
        }
        Map<Long, Integer> allCounts = this.companyGradeV3Service.getBusinessStateComCountBatch(searchAll).stream().collect(Collectors.toMap(ComBusinessCountVo::getRegionId, ComBusinessCountVo::getTotalCount, (v1, v2) -> v2));
        Map<Long, Integer> passCounts = this.companyGradeV3Service.getBusinessStateComCountBatch(searchPass).stream().collect(Collectors.toMap(ComBusinessCountVo::getRegionId, ComBusinessCountVo::getTotalCount, (v1, v2) -> v2));
        declareList.forEach(declare -> {
            int allCnt = allCounts.getOrDefault(declare.getAreaId(), 0);
            int passCnt = passCounts.getOrDefault(declare.getAreaId(), 0);
            declare.setNeedClassNewDeclareCompanyNum(Integer.valueOf(declare.getMore3NUm() + declare.getNullNum()));
            declare.setDeclareCompanyClassCompleteNum(Integer.valueOf(passCnt));
            allCnt = declare.getNeedClassNewDeclareCompanyNum();
            declare.setDeclareCompanyClassCompleteRate((String)(allCnt == 0 ? "0.00%" : String.valueOf(new BigDecimal(passCnt).divide(new BigDecimal(allCnt), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP)) + "%"));
        });
        declarePage.setList(declareList);
        return declarePage;
    }

    public PageInfo<DeclareAreaModel> statisticsDeclareAreaListHistoryPage(SearchParam searchParam) {
        Byte level = searchParam.getLevel();
        if (ObjectUtil.isNotNull((Object)level) && level > 2) {
            return new PageInfo();
        }
        PageHelper.startPage((int)searchParam.getPageNum(), (int)searchParam.getPageSize());
        return new PageInfo(this.statisticsDeclareAreaListHistoryData(searchParam));
    }

    public List<DeclareAreaModel> statisticsDeclareAreaListHistoryData(SearchParam searchParam) {
        return ((WandaDeclareMapper)this.dao).statisticsDeclareAreaListHistoryPage(searchParam);
    }

    public List<AreaModel> listHistoryAreaName(SearchParam searchParam) {
        Byte level = searchParam.getLevel();
        if (ObjectUtil.isNotNull((Object)level) && level > 2) {
            return new ArrayList<AreaModel>();
        }
        List<AreaModel> areaModels = ((WandaDeclareMapper)this.dao).listHistoryAreaName(searchParam);
        for (AreaModel areaModel : areaModels) {
            if (!ObjectUtil.isNotNull((Object)areaModel.getLevel()) || !areaModel.getLevel().equals(new Byte("3"))) continue;
            areaModel.setHasSon(Boolean.valueOf(false));
        }
        return areaModels;
    }

    public DeclareAreaModel statisticsDeclareAreaHeadDataHistory(SearchParam searchParam) {
        Byte level = searchParam.getLevel();
        if (ObjectUtil.isNotNull((Object)level) && level > 3) {
            return null;
        }
        return ((WandaDeclareMapper)this.dao).statisticsDeclareAreaHeadDataHistory(searchParam);
    }

    public PageInfo<WandaDeclare> getNoMatchedConvertList(JqGridParam jparam, SearchParam searchParam, Boolean isCount) {
        AreaModel areaModel;
        Long areaId = searchParam.getAreaId();
        if (ObjectUtil.isNotNull((Object)areaId) && ObjectUtil.isNotNull((Object)(areaModel = this.sysAreaProvideService.getAreaById(areaId))) && ObjectUtil.isNotNull((Object)areaModel.getLevel())) {
            searchParam.setLevel(areaModel.getLevel());
        }
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows(), (boolean)isCount);
        List<WandaDeclare> list = ((WandaDeclareMapper)this.dao).selectNoMatchedConvertList(searchParam);
        list.forEach(item -> this.convertWandaDeclare((WandaDeclare)item, false));
        return new PageInfo(list);
    }

    public WandaDeclareVo getWandaDeclareDetailsInfo(Long declareId) {
        if (ObjectUtil.isNull((Object)declareId)) {
            return new WandaDeclareVo();
        }
        WandaDeclareVo wandaDeclareVo = ((WandaDeclareMapper)this.dao).selectWandaDeclareStagingVoById(declareId);
        if (ObjectUtil.isNotNull((Object)wandaDeclareVo) && ObjectUtil.isNotNull((Object)wandaDeclareVo.getId())) {
            String economic;
            String areaCode;
            AreaModel area;
            Object cardId = wandaDeclareVo.getLegalCardId();
            Integer legalCardType = wandaDeclareVo.getLegalCardType();
            wandaDeclareVo.setLegalCardIdFull(wandaDeclareVo.getLegalCardId());
            if (legalCardType != null && StringUtils.isNotBlank((CharSequence)cardId)) {
                cardId = legalCardType.equals(1) && ((String)cardId).length() > 6 ? ((String)cardId).substring(0, 3) + "****" + ((String)cardId).substring(((String)cardId).length() - 3) : (((String)cardId).length() >= 3 ? ((String)cardId).charAt(0) + "****" + ((String)cardId).substring(((String)cardId).length() - 1) : ((String)cardId).charAt(0) + "****");
            }
            wandaDeclareVo.setLegalCardId((String)cardId);
            if (StringUtils.isEmpty((CharSequence)wandaDeclareVo.getIndustryCategoryName())) {
                wandaDeclareVo.setIndustryCode(null);
            }
            if ((area = this.sysAreaProvideService.getAreaById(StringUtils.isEmpty((CharSequence)(areaCode = wandaDeclareVo.getWorkAddr())) ? null : this.concatAreaId(areaCode))) != null) {
                wandaDeclareVo.setAreaId(area.getAreaId());
                wandaDeclareVo.setAreaName(area.getAreaName());
                wandaDeclareVo.setCityId(area.getCityId());
                wandaDeclareVo.setCityName(area.getCityName());
                wandaDeclareVo.setStreetId(area.getStreetId());
                wandaDeclareVo.setStreetName(area.getStreetName());
                wandaDeclareVo.setProvinceId(area.getProvinceId());
                wandaDeclareVo.setProvinceName(area.getProvinceName());
                wandaDeclareVo.setAreaLevel(area.getLevel());
            }
            wandaDeclareVo.setAreaDetailId(StringUtils.isEmpty((CharSequence)areaCode) ? null : this.concatAreaId(areaCode));
            String workAddr = wandaDeclareVo.getAreaCode();
            AreaModel registerArea = this.sysAreaProvideService.getAreaById(StringUtils.isEmpty((CharSequence)workAddr) ? null : this.concatAreaId(workAddr));
            if (registerArea != null) {
                wandaDeclareVo.setRegisterAreaId(registerArea.getAreaId());
                wandaDeclareVo.setRegisterAreaName(registerArea.getAreaName());
                wandaDeclareVo.setRegisterCityId(registerArea.getCityId());
                wandaDeclareVo.setRegisterCityName(registerArea.getCityName());
                wandaDeclareVo.setRegisterStreetId(registerArea.getStreetId());
                wandaDeclareVo.setRegisterStreetName(registerArea.getStreetName());
                wandaDeclareVo.setRegisterProvinceId(registerArea.getProvinceId());
                wandaDeclareVo.setRegisterProvinceName(registerArea.getProvinceName());
                wandaDeclareVo.setRegisterAreaLevel(registerArea.getLevel());
            }
            wandaDeclareVo.setRegisterAreaDetailId(StringUtils.isEmpty((CharSequence)workAddr) ? null : this.concatAreaId(workAddr));
            String scale = wandaDeclareVo.getEnterpriseSize();
            scale = StringUtils.isEmpty((CharSequence)scale) ? "5" : scale;
            wandaDeclareVo.setScale(scale);
            if (StringUtils.isNotEmpty((String)scale) && NumberUtil.isNumber((String)scale)) {
                wandaDeclareVo.setScaleName(CompanySizeEnum.getName((Integer)NumberUtil.toInt((String)scale)));
            }
            if (StringUtils.isNotEmpty((String)(economic = wandaDeclareVo.getEconomic())) && NumberUtil.isNumber((String)economic)) {
                SysParamModel byId = this.sysParamProvideService.getById(Long.valueOf(NumberUtil.toLong((String)economic)));
                if (ObjectUtil.isNull((Object)byId)) {
                    wandaDeclareVo.setEconomic(null);
                } else {
                    wandaDeclareVo.setRegisterTypeName(ObjectUtil.isNull((Object)byId) ? null : byId.getParamValue());
                }
            }
            ArrayList<SysFileModel> fileModels = new ArrayList<SysFileModel>();
            if ("1".equals(wandaDeclareVo.getManageOrg()) && StringUtils.isNotEmpty((String)wandaDeclareVo.getManageOrgFiles())) {
                String[] split;
                for (String s : split = wandaDeclareVo.getManageOrgFiles().split(",")) {
                    SysFileModel file;
                    if (!NumberUtil.isNumber((String)s) || !ObjectUtil.isNotNull((Object)(file = this.sysFileProvideService.getFileById(Long.valueOf(NumberUtil.toLong((String)s)))))) continue;
                    fileModels.add(file);
                }
            }
            wandaDeclareVo.setManageOrgFileList(fileModels);
            return wandaDeclareVo;
        }
        wandaDeclareVo = ((WandaDeclareMapper)this.dao).selectWandaDeclareVoById(declareId);
        if (ObjectUtil.isNotNull((Object)wandaDeclareVo) && ObjectUtil.isNotNull((Object)wandaDeclareVo.getId())) {
            String economic;
            String scale;
            String areaCode = wandaDeclareVo.getWorkAddr();
            AreaModel area = this.sysAreaProvideService.getAreaById(StringUtils.isEmpty((CharSequence)areaCode) ? null : this.concatAreaId(areaCode));
            if (area != null) {
                wandaDeclareVo.setAreaId(area.getAreaId());
                wandaDeclareVo.setAreaName(area.getAreaName());
                wandaDeclareVo.setCityId(area.getCityId());
                wandaDeclareVo.setCityName(area.getCityName());
                wandaDeclareVo.setStreetId(area.getStreetId());
                wandaDeclareVo.setStreetName(area.getStreetName());
                wandaDeclareVo.setProvinceId(area.getProvinceId());
                wandaDeclareVo.setProvinceName(area.getProvinceName());
                wandaDeclareVo.setAreaLevel(area.getLevel());
            }
            wandaDeclareVo.setAreaDetailId(StringUtils.isEmpty((CharSequence)areaCode) ? null : this.concatAreaId(areaCode));
            String workAddr = wandaDeclareVo.getAreaCode();
            AreaModel registerArea = this.sysAreaProvideService.getAreaById(StringUtils.isEmpty((CharSequence)workAddr) ? null : this.concatAreaId(workAddr));
            if (registerArea != null) {
                wandaDeclareVo.setRegisterAreaId(registerArea.getAreaId());
                wandaDeclareVo.setRegisterAreaName(registerArea.getAreaName());
                wandaDeclareVo.setRegisterCityId(registerArea.getCityId());
                wandaDeclareVo.setRegisterCityName(registerArea.getCityName());
                wandaDeclareVo.setRegisterStreetId(registerArea.getStreetId());
                wandaDeclareVo.setRegisterStreetName(registerArea.getStreetName());
                wandaDeclareVo.setRegisterProvinceId(registerArea.getProvinceId());
                wandaDeclareVo.setRegisterProvinceName(registerArea.getProvinceName());
                wandaDeclareVo.setRegisterAreaLevel(registerArea.getLevel());
            }
            wandaDeclareVo.setRegisterAreaDetailId(StringUtils.isEmpty((CharSequence)workAddr) ? null : this.concatAreaId(workAddr));
            if (StringUtils.isEmpty((CharSequence)wandaDeclareVo.getIndustryCategoryName())) {
                wandaDeclareVo.setIndustryCode(null);
            }
            scale = StringUtils.isEmpty((CharSequence)(scale = this.getScaleBySize(wandaDeclareVo.getEnterpriseSize()))) ? "5" : scale;
            wandaDeclareVo.setScale(scale);
            if (StringUtils.isNotEmpty((String)scale) && NumberUtil.isNumber((String)scale)) {
                wandaDeclareVo.setScaleName(CompanySizeEnum.getName((Integer)NumberUtil.toInt((String)scale)));
            }
            if (StringUtils.isNotEmpty((String)(economic = wandaDeclareVo.getEconomic()))) {
                SysParamModel byId = this.sysParamProvideService.getSysParamByNameGroupCode(null, null, SysParamGroupEnum.register_type, economic);
                if (ObjectUtil.isNull((Object)byId)) {
                    wandaDeclareVo.setEconomic(null);
                } else {
                    wandaDeclareVo.setEconomic(byId.getId().toString());
                    wandaDeclareVo.setRegisterTypeName(ObjectUtil.isNull((Object)byId) ? null : byId.getParamValue());
                }
            }
        }
        return wandaDeclareVo;
    }

    public PageInfo<Company> getComopanyByUnitCode(JqGridParam jparam, SearchParam searchParam) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<Object> companyList = null;
        companyList = StringUtils.isEmpty((CharSequence)searchParam.getKeywords()) ? new ArrayList() : ((WandaDeclareMapper)this.dao).selectComopanyByUnitCode(searchParam);
        return new PageInfo(companyList);
    }

    public PageInfo<CompanySuperviseModel> getComopanyManualDeclare(JqGridParam jparam, SearchParam searchParam, Boolean isCount) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows(), (boolean)isCount);
        List<CompanySuperviseModel> companyList = ((WandaDeclareMapper)this.dao).selectComopanyManualDeclare(searchParam);
        return new PageInfo(companyList);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(readOnly=false)
    public void wandaDeclareInfoGenerate(CompanySuperviseModel company, Long loginUserId, String loginUserName, String ip) {
        SysParamModel byId;
        CompanyReportInfo companyReportInfo;
        RecordOperationLog log;
        String after;
        String before;
        RecordOperationLog log2;
        RecordOperationTypeEnum change;
        Byte by;
        AreaModel areaModel;
        List companyIsFormalProcess;
        Date submitTime = new Date();
        this.checkCompanyInfo(company);
        company.setCid(company.getId());
        Long declareId = company.getDeclareId();
        company.setUnifiedSocialCc(company.getUnifiedSocialCc().toUpperCase());
        Integer companyByNameAndTypeCount = ((WandaDeclareMapper)this.dao).selectCompanyByNameAndType(null, company.getName(), company.getId());
        if (companyByNameAndTypeCount > 0) {
            throw new HealthException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f01\u4e1a\u540d\u79f0");
        }
        List companyAndCompanySuperviseByUnitCodeExcludeDelete = this.companyProvideBySuperviseService.getCompanyAndCompanySuperviseByUnitCodeExcludeDelete((List)ListUtil.toList((Object[])new String[]{company.getUnifiedSocialCc()}));
        if (CollUtil.isNotEmpty((Collection)companyAndCompanySuperviseByUnitCodeExcludeDelete)) {
            throw new ServiceException("\u6b64\u4fe1\u7528\u4ee3\u7801\u5df2\u5b58\u5728\u4e8e\u6d59\u91cc\u536b\u4f01\uff0c\u4e0d\u53ef\u63d0\u4ea4\uff01");
        }
        if (ObjectUtil.isNull((Object)company.getId())) {
            ArrayList<Long> idList = new ArrayList<Long>();
            Boolean falg = false;
            try {
                company.setId(Long.valueOf(this.idworker.nextId()));
                company.setBusinessState(Byte.valueOf(CompanyBusinessState.NORMAL.getCode().byteValue()));
                company.setAreaDetailId(company.getAreaId());
                company.setIsReport(Boolean.valueOf(true));
                company.setGradeCreateDate(submitTime);
                company.setGradeReason(CompanyGradeReasonEnum.DECLARATIONIMPORT.getValue());
                idList.add(company.getId());
                if (!ObjectUtil.isNotNull((Object)company.getId())) return;
                company.setInsertCompanyType(Byte.valueOf((byte)3));
                this.companyProvideBySuperviseService.saveCompanyAndCompanySuperviseByList(Arrays.asList(company), loginUserId);
                CompanyReportInfo companyReportInfo2 = new CompanyReportInfo();
                companyReportInfo2.setCid(company.getId());
                companyReportInfo2.setManageOrg(company.getManageOrg());
                companyReportInfo2.setManageOrgFiles(company.getManageOrgFiles());
                companyReportInfo2.setManageMajorStaffCount(company.getManageMajorStaffCount());
                companyReportInfo2.setManagePluralityStaffCount(company.getManagePluralityStaffCount());
                companyReportInfo2.setLegalCardType(company.getLegalCardType());
                companyReportInfo2.setLegalCardId(company.getLegalCardId());
                this.companyReportInfoService.addCompanyReportInfo(companyReportInfo2, loginUserId, companyReportInfo2.getCid(), "1");
                List userManager = this.userService.getUserManager(company.getId());
                SysUser userByuserameAndCid = this.userService.getUserByuserameAndCid(company.getName(), company.getId());
                if (CollectionUtils.isEmpty((Collection)userManager) && ObjectUtil.isNull((Object)userByuserameAndCid)) {
                    falg = true;
                    CreateUserModel createUserModel = new CreateUserModel();
                    createUserModel.setCid(company.getId());
                    createUserModel.setUsername(company.getName());
                    createUserModel.setPassword("Zyj@2022");
                    createUserModel.setCreateBy(loginUserId);
                    this.sysUserThirdService.create(Arrays.asList(createUserModel));
                }
                this.wandaDeclareBindingCompany(company.getId(), company.getUnifiedSocialCc(), loginUserId);
                CompanyBaseInfoModel companyModel = new CompanyBaseInfoModel();
                companyModel.setCid(company.getId());
                companyModel.setStorageReason(CompanyStorageReasonEnum.DECLARATIONIMPORT.getValue());
                companyModel.setIsManualDeclare(Boolean.valueOf(true));
                companyModel.setManualDeclareBy(loginUserId);
                this.companyStorageProvideService.saveOrUpdateCompanyStorageBatch(Arrays.asList(companyModel), loginUserId, Boolean.valueOf(true));
                if (!ObjectUtil.isNotNull((Object)declareId)) return;
                ((WandaDeclareMapper)this.dao).delWandaDeclareConversion(declareId, loginUserId);
                return;
            }
            catch (Exception e) {
                this.companyProvideBySuperviseService.rollbackImportCompanyAndCompanySuperviseData(idList);
                if (!falg.booleanValue()) throw e;
                this.sysUserThirdService.rollbackImportUserData(idList);
                throw e;
            }
        }
        Byte dataSource = ((WandaDeclareMapper)this.dao).selectCompanyDataSourceById(company.getId());
        if (ObjectUtil.isNull((Object)dataSource) || !dataSource.equals(new Byte("10")) && !dataSource.equals(new Byte("5"))) {
            throw new HealthException("\u5173\u8054\u4f01\u4e1a\u4e0d\u662f\u4e1c\u9633\u6216\u57f9\u8bad\u7cfb\u7edf\u4f01\u4e1a\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4");
        }
        Boolean falg = false;
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(company.getId());
        CompanyBaseInfoModel old = this.companyProvideByHSEService.getCompanyById(company.getId());
        if (!ObjectUtil.isNotNull((Object)old) || !ObjectUtil.isNotNull((Object)old.getId())) return;
        AreaModel area = this.sysAreaProvideService.getAreaById(company.getAreaId());
        if (!company.getAreaId().equals(old.getStreetId()) && CollUtil.isNotEmpty((Collection)(companyIsFormalProcess = this.companyChangeV3ProviderService.getCompanyIsFormalProcessListByCidList(Collections.singletonList(company.getId()))))) {
            List list = companyIsFormalProcess.stream().filter(i -> Objects.equals(i.getChangeType(), CompanyChangeTypeEnum.crossMigration.getCode()) || Objects.equals(i.getChangeType(), CompanyChangeTypeEnum.intraMigration.getCode()) || Objects.equals(i.getChangeType(), CompanyChangeTypeEnum.districtMigration.getCode())).collect(Collectors.toList());
            if (CollUtil.isEmpty(list)) {
                throw new HealthException("\u8be5\u4f01\u4e1a\u6b63\u5904\u4e8e\u4fe1\u606f\u53d8\u66f4\uff08\u975e\u8fc1\u79fb\uff09\u6b63\u5f0f\u6d41\u7a0b\u4e2d");
            }
            if (companyIsFormalProcess.size() > list.size()) {
                throw new HealthException("\u8be5\u4f01\u4e1a\u6b63\u5904\u4e8e\u4fe1\u606f\u53d8\u66f4\uff08\u975e\u8fc1\u79fb\uff09\u6b63\u5f0f\u6d41\u7a0b\u4e2d");
            }
            this.companyChangeV3ProviderService.delCompanyIsFormalProcessByCid(company.getId(), company.getName(), company.getAreaId(), loginUserId, loginUserName);
        }
        if (ObjectUtil.isNotNull((Object)old.getAreaDetailId()) && ObjectUtil.isNotNull((Object)(areaModel = this.sysAreaProvideService.getAreaById(old.getAreaDetailId())).getId()) && Objects.equals(by = this.companyProvideByHSEService.regionChangeRemoveClueCard(old, area, loginUserId), (byte)1)) {
            this.sysUserThirdService.disableOrEnableUserByCidList((List)CollUtil.toList((Object[])new Long[]{old.getId()}), Integer.valueOf(1), loginUserId);
        }
        List<CompanySuperviseModel> unifiedCcModelList = ((WandaDeclareMapper)this.dao).getOnlyCompanyByUnitCode(company.getUnifiedSocialCc(), company.getId());
        HashMap hashMap = new HashMap();
        if (CollUtil.isNotEmpty(unifiedCcModelList)) {
            Map<String, Integer> map = unifiedCcModelList.stream().collect(Collectors.groupingBy(CompanyBaseInfoModel::getUnifiedSocialCc, Collectors.collectingAndThen(Collectors.maxBy(Comparator.comparingInt(CompanyBaseInfoModel::getSeq)), optionalMax -> optionalMax.map(max -> max.getSeq() + 1).orElse(0))));
        }
        if (StrUtil.isNotBlank((CharSequence)company.getUnifiedSocialCc())) {
            void var15_27;
            company.setSeq(var15_27.getOrDefault(company.getUnifiedSocialCc(), 0));
        }
        ((WandaDeclareMapper)this.dao).updateCompanyDataSourceById(company.getId(), CompanyDataSourceEnum.SUPERVISE.getValue(), loginUserId);
        ((WandaDeclareMapper)this.dao).updateCompanyDataById(company, loginUserId);
        Integer count = ((WandaDeclareMapper)this.dao).getCompanySuperviseBycidCount(company.getId());
        if (count > 0) {
            ((WandaDeclareMapper)this.dao).updCompanySuperviseBycid(ObjectUtil.isNull((Object)company.getBelongType()) ? 0 : company.getBelongType(), company.getId(), loginUserId, submitTime);
        } else {
            CompanySuperviseModel s = new CompanySuperviseModel();
            s.setId(Long.valueOf(this.idworker.nextId()));
            s.setCid(company.getId());
            s.setBelongType(company.getBelongType());
            if (Objects.isNull(s.getInspectionClassification())) {
                s.setInspectionClassification(CompanyinspectionClassificationEnum.NO.getValue());
            }
            if (Objects.isNull(s.getIsBest())) {
                s.setIsBest(CompanyIsBestEnum.FALSE.getCode());
            }
            if (Objects.isNull(s.getGovern())) {
                s.setGovern(Boolean.FALSE);
            }
            if (Objects.isNull(s.getBelongType())) {
                s.setBelongType(CompanyBelongTypeEnum.NO.getValue());
            }
            if (Objects.isNull(s.getSuperviseIsHide())) {
                s.setSuperviseIsHide(Boolean.FALSE);
            }
            if (Objects.isNull(s.getSuperviseIsDel())) {
                s.setSuperviseIsDel(Boolean.FALSE);
            }
            if (Objects.isNull(s.getBusinessState())) {
                s.setBusinessState(Byte.valueOf(CompanyBusinessState.NORMAL.getCode().byteValue()));
            }
            s.setIsValid(Boolean.TRUE);
            s.setGradeCreateDate(submitTime);
            s.setGradeReason(CompanyGradeReasonEnum.DECLARATIONIMPORT.getValue());
            ((WandaDeclareMapper)this.dao).insertCompanySupervise(s, loginUserId);
        }
        ArrayList<RecordOperationLog> logList = new ArrayList<RecordOperationLog>();
        String name = company.getName();
        String oldName = old.getName();
        if (!StringUtils.equals((CharSequence)name, (CharSequence)oldName)) {
            RecordOperationTypeEnum change2 = RecordOperationTypeEnum.COM_NAME_CHANGE;
            RecordOperationLog log3 = new RecordOperationLog();
            log3.setChangeField(change2.getColumn());
            log3.setLogType(Integer.valueOf(1));
            log3.setBusiType(change2.getKey());
            log3.setLogTitle("\u7531 " + oldName + " \u53d8\u66f4\u4e3a " + name);
            log3.setBeforeInfo(oldName);
            log3.setAfterInfo(name);
            logList.add(log3);
        }
        if (!area.getStreetName().equals(old.getStreetName())) {
            // empty if block
        }
        long current = System.currentTimeMillis();
        Long areaDetailId = old.getAreaDetailId();
        Long areaId = company.getAreaId();
        String workAddress = old.getWorkAddress();
        String workAddressNew = company.getWorkAddress();
        Long registerAreaDetailId = old.getRegisterAreaDetailId();
        Long registerAreaId = company.getRegisterAddressRegionId();
        String registerAddress = old.getRegisterAddress();
        String registerAddressNew = company.getRegisterAddress();
        String scale = old.getScale();
        String scaleNew = company.getScale();
        Long industryCategory = old.getIndustryCategory();
        Long industryCode = company.getIndustryCategory();
        Long registerType = old.getRegisterType();
        Long registerTypeNew = company.getRegisterType();
        String legalName = old.getLegalName();
        String legalNameNew = company.getLegalName();
        String unifiedSocialCc = old.getUnifiedSocialCc();
        String unifiedSocialCcNew = company.getUnifiedSocialCc();
        if (!StringUtils.equals((CharSequence)unifiedSocialCcNew, (CharSequence)unifiedSocialCc)) {
            change = RecordOperationTypeEnum.UCC_CHANGE;
            log2 = new RecordOperationLog();
            log2.setChangeField(change.getColumn());
            log2.setLogType(Integer.valueOf(1));
            log2.setBusiType(change.getKey());
            log2.setLogTitle("\u7531 " + unifiedSocialCc + " \u53d8\u66f4\u4e3a " + unifiedSocialCcNew);
            log2.setBeforeInfo(unifiedSocialCc);
            log2.setAfterInfo(unifiedSocialCcNew);
            logList.add(log2);
        }
        if (!areaId.equals(areaDetailId)) {
            change = RecordOperationTypeEnum.REGION_CHANGE;
            log2 = new RecordOperationLog();
            log2.setChangeField(change.getColumn());
            log2.setLogType(Integer.valueOf(1));
            log2.setBusiType(change.getKey());
            log2.setLogTitle("\u7531 " + areaDetailId + " \u53d8\u66f4\u4e3a " + areaId);
            log2.setBeforeInfo("" + areaDetailId);
            log2.setAfterInfo("" + areaId);
            logList.add(log2);
        }
        if (!StringUtils.equals((CharSequence)workAddress, (CharSequence)workAddressNew)) {
            change = RecordOperationTypeEnum.WORK_ADDRESS_CHANGE;
            before = workAddress;
            if (ObjectUtil.isNotNull((Object)workAddress)) {
                before = workAddress.replace("'", "").replace("\"", "");
            }
            after = workAddressNew;
            if (ObjectUtil.isNotNull((Object)workAddressNew)) {
                after = workAddressNew.replace("'", "").replace("\"", "");
            }
            log = new RecordOperationLog();
            log.setChangeField(change.getColumn());
            log.setLogType(Integer.valueOf(1));
            log.setBusiType(change.getKey());
            log.setLogTitle("\u7531 " + before + " \u53d8\u66f4\u4e3a " + after);
            log.setBeforeInfo(before);
            log.setAfterInfo(after);
            logList.add(log);
        }
        if (!registerAreaId.equals(registerAreaDetailId)) {
            change = RecordOperationTypeEnum.REGISTER_ADDRESS_ID;
            log2 = new RecordOperationLog();
            log2.setChangeField(change.getColumn());
            log2.setLogType(Integer.valueOf(1));
            log2.setBusiType(change.getKey());
            log2.setLogTitle("\u7531 " + registerAreaDetailId + " \u53d8\u66f4\u4e3a " + registerAreaId);
            log2.setBeforeInfo("" + registerAreaDetailId);
            log2.setAfterInfo("" + registerAreaId);
            logList.add(log2);
        }
        if (!StringUtils.equals((CharSequence)registerAddressNew, (CharSequence)registerAddress)) {
            change = RecordOperationTypeEnum.REGISTER_DETAIL;
            before = registerAddress;
            if (ObjectUtil.isNotNull((Object)registerAddress)) {
                before = registerAddress.replace("'", "").replace("\"", "");
            }
            after = registerAddressNew;
            if (ObjectUtil.isNotNull((Object)registerAddressNew)) {
                after = registerAddressNew.replace("'", "").replace("\"", "");
            }
            log = new RecordOperationLog();
            log.setChangeField(change.getColumn());
            log.setLogType(Integer.valueOf(1));
            log.setBusiType(change.getKey());
            log.setLogTitle("\u7531 " + before + " \u53d8\u66f4\u4e3a " + after);
            log.setBeforeInfo(before);
            log.setAfterInfo(after);
            logList.add(log);
        }
        if (!StringUtils.equals((CharSequence)scale, (CharSequence)scaleNew)) {
            change = RecordOperationTypeEnum.SCALE_CHANGE;
            log2 = new RecordOperationLog();
            log2.setChangeField(change.getColumn());
            log2.setLogType(Integer.valueOf(1));
            log2.setBusiType(change.getKey());
            log2.setLogTitle("\u7531 " + scale + " \u53d8\u66f4\u4e3a " + scaleNew);
            log2.setBeforeInfo(scale);
            log2.setAfterInfo(scaleNew);
            logList.add(log2);
        }
        if (!industryCode.equals(industryCategory)) {
            change = RecordOperationTypeEnum.INDUSTRY_CATEGORY_CHANGE;
            log2 = new RecordOperationLog();
            log2.setChangeField(change.getColumn());
            log2.setLogType(Integer.valueOf(1));
            log2.setBusiType(change.getKey());
            log2.setLogTitle("\u7531 " + industryCategory + " \u53d8\u66f4\u4e3a " + industryCode);
            log2.setBeforeInfo("" + industryCategory);
            log2.setAfterInfo("" + industryCode);
            logList.add(log2);
        }
        if (!registerTypeNew.equals(registerType)) {
            change = RecordOperationTypeEnum.REGISTER_TYPE_CHANGE;
            log2 = new RecordOperationLog();
            log2.setChangeField(change.getColumn());
            log2.setLogType(Integer.valueOf(1));
            log2.setBusiType(change.getKey());
            log2.setLogTitle("\u7531 " + registerType + " \u53d8\u66f4\u4e3a " + registerTypeNew);
            log2.setBeforeInfo("" + registerType);
            log2.setAfterInfo("" + registerTypeNew);
            logList.add(log2);
        }
        if (!StringUtils.equals((CharSequence)legalName, (CharSequence)legalNameNew)) {
            change = RecordOperationTypeEnum.LEGAL_NAME;
            before = legalName;
            if (ObjectUtil.isNotNull((Object)legalName)) {
                before = legalName.replace("'", "").replace("\"", "");
            }
            after = legalNameNew;
            if (ObjectUtil.isNotNull((Object)legalNameNew)) {
                after = legalNameNew.replace("'", "").replace("\"", "");
            }
            log = new RecordOperationLog();
            log.setChangeField(change.getColumn());
            log.setLogType(Integer.valueOf(1));
            log.setBusiType(change.getKey());
            log.setLogTitle("\u7531 " + before + " \u53d8\u66f4\u4e3a " + after);
            log.setBeforeInfo(before);
            log.setAfterInfo(after);
            logList.add(log);
        }
        Integer dataSourceOld = old.getDataSource();
        if (!CompanyDataSourceEnum.SUPERVISE.getValue().equals(dataSourceOld)) {
            RecordOperationTypeEnum change3 = RecordOperationTypeEnum.DATA_SOURCE_CHANGE;
            RecordOperationLog log4 = new RecordOperationLog();
            log4.setChangeField(change3.getColumn());
            log4.setLogType(Integer.valueOf(1));
            log4.setBusiType(change3.getKey());
            log4.setLogTitle("\u7531 " + dataSourceOld + " \u53d8\u66f4\u4e3a " + CompanyDataSourceEnum.SUPERVISE.getValue());
            log4.setBeforeInfo("" + dataSourceOld);
            log4.setAfterInfo("" + CompanyDataSourceEnum.SUPERVISE.getValue());
            logList.add(log4);
        }
        if (ObjectUtil.isNull((Object)(companyReportInfo = this.companyReportInfoService.getCompanyReportInfoByCid(company.getId())))) {
            companyReportInfo = new CompanyReportInfo();
        }
        String loginUserType = null;
        if (ObjectUtil.isNotNull((Object)company.getRegisterType()) && ObjectUtil.isNotNull((Object)(byId = this.sysParamProvideService.getById(company.getRegisterType()))) && ("\u4e2a\u4f53\u5de5\u5546\u6237".equals(byId.getParamValue()) || "\u79c1\u8425\u4f01\u4e1a".equals(byId.getParamValue()))) {
            String legalCardIdNew;
            String legalCardId;
            Integer legalCardTypeNew;
            loginUserType = "1";
            Integer legalCardType = companyReportInfo.getLegalCardType();
            if (legalCardType != (legalCardTypeNew = company.getLegalCardType())) {
                RecordOperationTypeEnum change4 = RecordOperationTypeEnum.LEGAL_CARD_TYPE_CHANGE;
                RecordOperationLog log5 = new RecordOperationLog();
                log5.setChangeField(change4.getColumn());
                log5.setLogType(Integer.valueOf(1));
                log5.setTableName("company_report_info");
                log5.setBusiType(change4.getKey());
                log5.setLogTitle("\u7531 " + legalCardType + " \u53d8\u66f4\u4e3a " + legalCardTypeNew);
                log5.setBeforeInfo("" + legalCardType);
                log5.setAfterInfo("" + legalCardTypeNew);
                logList.add(log5);
            }
            if (!StringUtils.equals((CharSequence)(legalCardId = companyReportInfo.getLegalCardId()), (CharSequence)(legalCardIdNew = company.getLegalCardId()))) {
                RecordOperationTypeEnum change5 = RecordOperationTypeEnum.LEGAL_CARD_ID_CHANGE;
                RecordOperationLog log6 = new RecordOperationLog();
                log6.setChangeField(change5.getColumn());
                log6.setLogType(Integer.valueOf(1));
                log6.setTableName("company_report_info");
                log6.setBusiType(change5.getKey());
                log6.setLogTitle("\u7531 " + legalCardId + " \u53d8\u66f4\u4e3a " + legalCardIdNew);
                log6.setBeforeInfo(legalCardId);
                log6.setAfterInfo(legalCardIdNew);
                logList.add(log6);
            }
        }
        for (RecordOperationLog recordOperationLog : logList) {
            recordOperationLog.setId(Long.valueOf(this.idworker.nextId()));
            if (ObjectUtil.isNull((Object)recordOperationLog.getTableName())) {
                recordOperationLog.setTableName("company");
            }
            recordOperationLog.setCompanyId(company.getId());
            recordOperationLog.setIp(ip);
            recordOperationLog.setCreateBy(loginUserId);
            recordOperationLog.setTimestamp(Long.valueOf(current));
            recordOperationLog.setCreateDate(new Date());
            recordOperationLog.setCreateByName(loginUserName);
        }
        if (CollectionUtils.isNotEmpty(logList)) {
            ((WandaDeclareMapper)this.dao).addRecordOperationLog(logList);
        }
        if (!company.getIndustryCategory().equals(old.getIndustryCategory())) {
            this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(company.getId(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE11, ComplianceCodeEnum.CODE08});
        }
        this.functionalOrganizationService.setEstablishFile(company.getId(), company.getManageOrgFiles(), company.getManageOrg(), loginUserId);
        companyReportInfo.setManageOrg(company.getManageOrg());
        companyReportInfo.setManageOrgFiles(company.getManageOrgFiles());
        companyReportInfo.setManageMajorStaffCount(company.getManageMajorStaffCount());
        companyReportInfo.setManagePluralityStaffCount(company.getManagePluralityStaffCount());
        companyReportInfo.setLegalCardType(company.getLegalCardType());
        companyReportInfo.setLegalCardId(company.getLegalCardId());
        RpcContext context = RpcContext.getContext();
        if (ObjectUtil.isNotNull((Object)context)) {
            context.setAttachment("ip_addr", ip);
            context.setAttachment("operator_id", "" + loginUserId);
            context.setAttachment("operator_name", loginUserName);
        }
        this.companyReportInfoService.addCompanyReportInfo(companyReportInfo, loginUserId, company.getId(), loginUserType);
        company.setFatherDept(old.getFatherDept());
        company.setCompanyContactTel(old.getCompanyContactTel());
        SelfInspectionRiskAssessmentReportInfo info = this.convertSelfInspectionRiskAssessmentReportInfo(company, companyReportInfo);
        this.riskAssessmentReportInfoService.synCompanyReportInfo(info);
        try {
            List userManager = this.userService.getUserManager(company.getId());
            SysUser userByuserameAndCid = this.userService.getUserByuserameAndCid(company.getName(), company.getId());
            if (CollectionUtils.isEmpty((Collection)userManager) && ObjectUtil.isNull((Object)userByuserameAndCid)) {
                falg = true;
                CreateUserModel createUserModel = new CreateUserModel();
                createUserModel.setCid(company.getId());
                createUserModel.setUsername(company.getName());
                createUserModel.setPassword("Zyj@2022");
                createUserModel.setCreateBy(loginUserId);
                this.sysUserThirdService.create(Arrays.asList(createUserModel));
            }
        }
        catch (Exception e) {
            if (!falg.booleanValue()) throw new HealthException("\u65b0\u589e\u8d26\u53f7\u5931\u8d25");
            this.sysUserThirdService.rollbackImportUserData(idList);
            throw new HealthException("\u65b0\u589e\u8d26\u53f7\u5931\u8d25");
        }
        this.wandaDeclareBindingCompany(company.getId(), company.getUnifiedSocialCc(), loginUserId);
        CompanyBaseInfoModel companyModel = new CompanyBaseInfoModel();
        companyModel.setCid(company.getId());
        companyModel.setStorageReason(CompanyStorageReasonEnum.DECLARATIONIMPORT.getValue());
        companyModel.setIsManualDeclare(Boolean.valueOf(true));
        companyModel.setManualDeclareBy(loginUserId);
        this.companyStorageProvideService.saveOrUpdateCompanyStorageBatch(Arrays.asList(companyModel), loginUserId, Boolean.valueOf(true));
        if (!ObjectUtil.isNotNull((Object)declareId)) return;
        ((WandaDeclareMapper)this.dao).delWandaDeclareConversion(declareId, loginUserId);
    }

    private SelfInspectionRiskAssessmentReportInfo convertSelfInspectionRiskAssessmentReportInfo(CompanySuperviseModel company, CompanyReportInfo companyReportInfo) {
        SelfInspectionRiskAssessmentReportInfo info = new SelfInspectionRiskAssessmentReportInfo();
        BeanUtils.copyProperties((Object)companyReportInfo, (Object)info);
        info.setCid(company.getId());
        info.setCompanyName(company.getName());
        info.setUniformSocialCreditCode(company.getUnifiedSocialCc());
        info.setRegisterAddDetail(company.getRegisterAddress());
        info.setLocationAddDetail(company.getWorkAddress());
        if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)company.getScale())) {
            info.setCompanyScale(Long.valueOf(Long.parseLong(company.getScale())));
        }
        info.setIndustryClassification(company.getIndustryCategory());
        info.setSuperiorUnit(company.getFatherDept());
        info.setLegalRepresentative(company.getLegalName());
        info.setContactNumber(company.getCompanyContactTel());
        return info;
    }

    @Transactional(readOnly=false)
    public void wandaDeclareInfoDraft(CompanySuperviseModel company, Long loginUserId) {
        company.setIsValid(Boolean.valueOf(true));
        ((WandaDeclareMapper)this.dao).insertOrUpdateWandaDeclareConversion(company, loginUserId);
    }

    public List<WandaDeclare> countWandaDeclareValid(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((WandaDeclareMapper)this.dao).countWandaDeclareValid(cidList);
    }

    public List<CompanySuperviseModel> getCompanyNameRecord(String code, String name) {
        return ((WandaDeclareMapper)this.dao).getCompanyNameRecord(code, name);
    }

    @Transactional(readOnly=false)
    public void wandaDeclareBindingCompany(Long id, String unifiedSocialCc, Long loginUserId) {
        if (ObjectUtil.isNull((Object)id) || StringUtils.isEmpty((CharSequence)unifiedSocialCc)) {
            return;
        }
        ((WandaDeclareMapper)this.dao).wandaDeclareBindingCompany(id, unifiedSocialCc, loginUserId);
    }

    public void checkCompanyInfo(CompanySuperviseModel company) {
        if (ObjectUtil.isNull((Object)company.getName()) || StringUtils.isEmpty((CharSequence)company.getName().trim())) {
            throw new HealthException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String regex = "^(([0-9A-Za-z]{15})|([0-9A-Za-z]{18})|([0-9A-Za-z]{20}))$";
        if (ObjectUtil.isNull((Object)company.getUnifiedSocialCc()) || StringUtils.isEmpty((CharSequence)company.getUnifiedSocialCc().trim()) || !company.getUnifiedSocialCc().matches(regex)) {
            throw new HealthException("\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u4e0d\u6b63\u786e\u6216\u8005\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)company.getAreaId()) || ObjectUtil.isNull((Object)company.getWorkAddress()) || StringUtils.isEmpty((CharSequence)company.getWorkAddress().trim())) {
            throw new HealthException("\u884c\u653f\u533a\u5212\u3001\u5de5\u4f5c\u573a\u6240\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)company.getRegisterAddressRegionId()) || ObjectUtil.isNull((Object)company.getRegisterAddress()) || StringUtils.isEmpty((CharSequence)company.getRegisterAddress().trim())) {
            throw new HealthException("\u6ce8\u518c\u5730\u5740\u533a\u5212\u3001\u6ce8\u518c\u5730\u5740\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AreaModel area = this.sysAreaProvideService.getAreaById(company.getAreaId());
        AreaModel areaRegister = this.sysAreaProvideService.getAreaById(company.getRegisterAddressRegionId());
        if (ObjectUtil.isNull((Object)area) || !new Byte("4").equals(area.getLevel())) {
            throw new HealthException("\u884c\u653f\u533a\u5212\u9700\u7cbe\u786e\u5230\u8857\u9053");
        }
        if (ObjectUtil.isNull((Object)areaRegister) || !new Byte("4").equals(areaRegister.getLevel())) {
            throw new HealthException("\u6ce8\u518c\u5730\u5740\u9700\u7cbe\u786e\u5230\u8857\u9053");
        }
        if (StringUtils.isEmpty((CharSequence)company.getScale())) {
            throw new HealthException("\u4f01\u4e1a\u89c4\u6a21\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)company.getRegisterType())) {
            throw new HealthException("\u7ecf\u6d4e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)company.getManageOrg())) {
            throw new HealthException("\u672a\u660e\u786e\u662f\u5426\u6709\u804c\u4e1a\u536b\u751f\u76d1\u7763\u673a\u6784");
        }
        if (ObjectUtil.isNull((Object)company.getIndustryCategory())) {
            throw new HealthException("\u884c\u4e1a\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IndustryModel model = this.industryProvideService.getIndustryById(company.getIndustryCategory());
        if (ObjectUtil.isNull((Object)model) || ObjectUtil.isNull((Object)model.getIsLeaf()) || model.getIsLeaf() != 1) {
            throw new HealthException("\u884c\u4e1a\u5206\u7c7b\u672a\u7cbe\u786e\u5230\u6700\u540e\u4e00\u7ea7");
        }
        if (ObjectUtil.isNotNull((Object)company.getLegalCardType())) {
            if (company.getLegalCardType() == 1) {
                if (!IDCardUtil.isIDCard((String)company.getLegalCardId())) {
                    throw new HealthException("\u8eab\u4efd\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
            } else if (StringUtils.isEmpty((CharSequence)company.getLegalCardId())) {
                throw new HealthException("\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    public PageInfo<WandaDeclare> pageInfo(int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Example example = new Example(WandaDeclare.class);
        return new PageInfo(this.getListByExample(example));
    }

    private synchronized SysUser createUser(String username, Long cid) {
        SysUser userByuserameAndCid = this.userService.getUserByuserameAndCid(username, cid);
        if (userByuserameAndCid != null) {
            return userByuserameAndCid;
        }
        StaffInfo staffForm = new StaffInfo();
        staffForm.setCid(cid);
        staffForm.setIsThirdParty(Global.FALSE);
        staffForm.setIsValid(Global.TRUE);
        staffForm.setCreateDate(new Date());
        staffForm.setUpdateDate(new Date());
        staffForm.setCreateBy(Long.valueOf(0L));
        staffForm.setUpdateBy(Long.valueOf(0L));
        staffForm.setAddFrom(Integer.valueOf(StaffAddFromEnum.supervise_manager_or_single_add1.getValue().byteValue()));
        StaffBasicInfo bas = new StaffBasicInfo();
        bas.setCid(cid);
        bas.setRealName(username);
        bas.setCid(cid);
        bas.setIsValid(Global.TRUE);
        bas.setCreateDate(new Date());
        bas.setUpdateDate(new Date());
        bas.setCreateBy(Long.valueOf(0L));
        bas.setUpdateBy(Long.valueOf(0L));
        staffForm.setStaffBasicInfo(bas);
        staffForm = this.staffInfoService.addStaffInfoSubmit(staffForm);
        SysUser user = new SysUser();
        user.setStaffId(staffForm.getId());
        user.setCid(cid);
        user.setUsername(username);
        user.setFullname(username);
        user.setIsManger(Boolean.valueOf(false));
        user.setIsForbidden(Global.FALSE);
        user.setUsername(username);
        user.setIsManger(Boolean.valueOf(true));
        user.setCreateBy(Long.valueOf(0L));
        user.setCreateDate(new Date());
        user.setUpdateDate(new Date());
        user.setUpdateBy(Long.valueOf(0L));
        this.entryptPassword(user, MD5.MD5Encode((String)"Zyj@2022"));
        user = (SysUser)this.userService.add((Object)user);
        SecUserRole userRole = new SecUserRole();
        userRole.setIsValid(Global.TRUE);
        userRole.setSecRoleId(Long.valueOf(1L));
        userRole.setSysUserId(user.getId());
        userRole.setCreateBy(Long.valueOf(0L));
        userRole.setCreateDate(new Date());
        userRole.setUpdateDate(new Date());
        userRole.setUpdateBy(Long.valueOf(0L));
        this.secUserRoleService.add((Object)userRole, null, cid);
        return user;
    }

    public SysUser entryptPassword(SysUser user, String plainPassword) {
        String plain = Encodes.unescapeHtml((String)plainPassword);
        byte[] salt = Digests.generateSalt((int)8);
        user.setSalt(Encodes.hexEncode((byte[])salt));
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        user.setPassword(Encodes.hexEncode((byte[])hashPassword));
        return user;
    }

    public List<WandaDeclare> delAndDistinct(List<WandaDeclare> list) {
        List<WandaDeclare> oldWandaDeclares;
        Set<String> idSet = list.stream().map(item -> item.getSourceId()).collect(Collectors.toSet());
        Set<String> isNotNullIdSet = idSet.stream().filter(i -> StringUtils.isNotEmpty((String)i)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(isNotNullIdSet) && CollectionUtils.isNotEmpty(oldWandaDeclares = ((WandaDeclareMapper)this.dao).selectIdBySourceIds(isNotNullIdSet))) {
            Map<String, Long> sourceIdMap = oldWandaDeclares.stream().collect(Collectors.toMap(WandaDeclare::getSourceId, WandaDeclare::getId, (i1, i2) -> i1));
            for (WandaDeclare wandaDeclare : list) {
                String sourceId = wandaDeclare.getSourceId();
                if (!StringUtils.isNotEmpty((String)sourceId) || !ObjectUtil.isNotNull((Object)sourceIdMap.get(sourceId))) continue;
                wandaDeclare.setId(sourceIdMap.get(sourceId));
            }
        }
        int i3 = ((WandaDeclareMapper)this.dao).deleteBatch(idSet);
        this.logger.info("\u7533\u62a5\u5220\u9664\uff1a{}\u6761\u6570\u636e", (Object)i3);
        Map<String, WandaDeclare> collect = list.stream().collect(Collectors.groupingBy(WandaDeclare::getSourceId, Collectors.collectingAndThen(Collectors.reducing((c1, c2) -> c1.getLoadTime().compareTo(c2.getLoadTime()) > 1 ? c1 : c2), Optional::get)));
        return new ArrayList<WandaDeclare>(collect.values());
    }

    private void checkSourceIdExist(List<WandaDeclare> updateList, List<WandaDeclare> addList, WandaDeclare card) {
        List collect = addList.stream().filter(item -> item.getSourceId().equalsIgnoreCase(card.getSourceId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            WandaDeclare old = (WandaDeclare)collect.get(0);
            addList.remove(old);
            card.setId(Long.valueOf(this.idworker.nextId()));
            card.setCreateDate(new Date());
            addList.add(card);
        } else {
            WandaDeclare dbData = this.getWandaDeclareDetailsWithoutConvert(card.getSourceId());
            if (Objects.nonNull(dbData)) {
                card.setUpdateDate(new Date());
                card.setId(dbData.getId());
                updateList.add(card);
            } else {
                card.setId(Long.valueOf(this.idworker.nextId()));
                card.setCreateDate(new Date());
                addList.add(card);
            }
        }
    }

    private CompanySuperviseModel convertInfo(WandaDeclare wandaDeclare) {
        if (!StringUtils.isNumber((String)wandaDeclare.getAreaCode()) || !StringUtils.isNumber((String)wandaDeclare.getIndustryCode())) {
            return null;
        }
        CompanySuperviseModel company = new CompanySuperviseModel();
        company.setDataSource(CompanyDataSourceEnum.WANDA_DECLARE.getValue());
        company.setUnifiedSocialCc(wandaDeclare.getCreditCode());
        company.setName(wandaDeclare.getEmpName());
        company.setLegalTel(wandaDeclare.getLegalPhone());
        company.setLegalName(wandaDeclare.getLegalPerson());
        company.setAreaId(this.concatAreaId(wandaDeclare.getAreaCode()));
        company.setRegisterAddress(wandaDeclare.getRegAddr());
        company.setWorkAddress(wandaDeclare.getWorkAddr());
        company.setIndustryCategory(Long.valueOf(Long.parseLong(wandaDeclare.getIndustryCode())));
        company.setStaffCount(Integer.valueOf("".equalsIgnoreCase(wandaDeclare.getStaffNum()) ? 0 : Integer.parseInt(wandaDeclare.getStaffNum())));
        company.setPickupCount(Integer.valueOf("".equalsIgnoreCase(wandaDeclare.getVictimsNum()) ? 0 : Integer.parseInt(wandaDeclare.getVictimsNum())));
        company.setScale(this.getScaleBySize(wandaDeclare.getEnterpriseSize()));
        company.setOccManagerName(wandaDeclare.getHealthManager());
        company.setOccManagerTel(wandaDeclare.getHealthManagerPhone());
        company.setCreateDate(new Date());
        company.setBusinessState(Byte.valueOf((byte)1));
        company.setBelongType(Integer.valueOf(0));
        company.setCompanyType(Integer.valueOf(1));
        company.setIsReport(Boolean.valueOf(true));
        company.setIsDec(Boolean.valueOf(true));
        this.setIsDecIsCurrentYear(wandaDeclare, company);
        company.setReportDate(wandaDeclare.getDeclareTime());
        company.setReportType(wandaDeclare.getDeclareType());
        return company;
    }

    private CompanySuperviseModel convertInfoDECLARE_20240730(WandaDeclare wandaDeclare) {
        CompanySuperviseModel company = this.setCompanyBaseInfo(wandaDeclare);
        company.setDataSource(CompanyDataSourceEnum.DECLARE_IMPORT.getValue());
        company.setIsDecCurrentYear(Boolean.valueOf(false));
        company.setIsDecOld(Boolean.valueOf(false));
        company.setIsSupervise(Boolean.valueOf(false));
        company.setImportBatchNo(wandaDeclare.getImportBatchNo());
        return company;
    }

    private CompanySuperviseModel setCompanyBaseInfo(WandaDeclare wandaDeclare) {
        Map<String, Long> registerTypeMap;
        List registerTypeList;
        Long aLong;
        List<Long> industryIds;
        List sysParamListByChildren;
        ArrayList collect;
        Map<String, SysParamModel> map;
        SysParamModel sysParamModel;
        CompanySuperviseModel company = new CompanySuperviseModel();
        company.setUnifiedSocialCc(wandaDeclare.getCreditCode());
        company.setName(wandaDeclare.getEmpName());
        company.setLegalTel(wandaDeclare.getLegalPhone());
        company.setLegalName(wandaDeclare.getLegalPerson());
        company.setRegisterAddress(wandaDeclare.getRegAddr());
        company.setWorkAddress(wandaDeclare.getWorkAddrDetail());
        company.setMainLeaderName(wandaDeclare.getHealthManager());
        company.setMainLeaderTel(wandaDeclare.getHealthManagerPhone());
        company.setCreateDate(new Date());
        company.setBusinessState(Byte.valueOf((byte)1));
        company.setBelongType(Integer.valueOf(0));
        company.setIsReport(Boolean.valueOf(true));
        company.setCompanyType(Integer.valueOf(1));
        company.setIsDec(Boolean.valueOf(true));
        company.setReportDate(wandaDeclare.getDeclareTime());
        company.setReportType(wandaDeclare.getDeclareType());
        company.setScale(this.getScaleByName(wandaDeclare.getEnterpriseSize()));
        AreaModel areaByName = this.sysAreaProvideService.getAreaByName(wandaDeclare.getArea());
        if (areaByName != null) {
            company.setAreaId(areaByName.getId());
            company.setRegisterAddressRegionId(areaByName.getId());
        }
        if ((sysParamModel = (map = (collect = (sysParamListByChildren = this.sysParamProvideService.getSysParamListByChildren(SysParamGroupEnum.national_econ_type.getValue())).stream().sorted(Comparator.comparing(SysParamModel::getLevel).reversed()).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysParamModel>(Comparator.comparing(SysParamModel::getParamValue))), ArrayList::new))).stream().collect(Collectors.toMap(SysParamModel::getParamValue, k -> k))).get(wandaDeclare.getIndustry())) != null) {
            company.setIndustryCategory(sysParamModel.getId());
        }
        if (ObjectUtil.isNull((Object)company.getIndustryCategory()) && StringUtils.isNotEmpty((String)wandaDeclare.getIndustry()) && CollectionUtils.isNotEmpty(industryIds = ((WandaDeclareMapper)this.dao).selectIndustryList(wandaDeclare.getIndustry()))) {
            company.setIndustryCategory(industryIds.get(0));
        }
        if (ObjectUtil.isNull((Object)(aLong = economicMap.get(wandaDeclare.getEconomic()))) && CollectionUtils.isNotEmpty((Collection)(registerTypeList = this.sysParamProvideService.getSysParamListByChildren(SysParamGroupEnum.register_type.getValue()))) && MapUtils.isNotEmpty(registerTypeMap = registerTypeList.stream().collect(Collectors.toMap(SysParamModel::getParamValue, SysParamModel::getId, (i1, i2) -> i1)))) {
            aLong = registerTypeMap.get(wandaDeclare.getEconomic());
        }
        company.setRegisterType(aLong);
        return company;
    }

    private CompanySuperviseModel convertInfoDECLARE_20240203(WandaDeclare wandaDeclare) {
        CompanySuperviseModel company = this.setCompanyBaseInfo(wandaDeclare);
        List<String> belongTypeList = Arrays.asList("\u9f99\u5c71\u9547", "\u592a\u6e56\u8857\u9053", "\u65b0\u65b0\u8857\u9053", "\u8377\u82b1\u8857\u9053", "\u53cc\u6e2f\u8857\u9053", "\u8862\u5316\u8857\u9053", "\u82b1\u56ed\u8857\u9053", "\u9ec4\u5bb6\u4e61", "\u9ec4\u5bb6\u4e61", "\u6a1f\u6f6d\u8857\u9053", "\u6d6e\u77f3\u8857\u9053", "\u5eff\u91cc\u9547", "\u9ad8\u5bb6\u9547", "\u57ce\u4e1c\u8857\u9053", "\u4e34\u57ce\u8857\u9053", "\u5c91\u6e2f\u8857\u9053", "\u53cc\u6865\u8857\u9053", "\u5343\u5c9b\u8857\u9053", "\u767d\u6cc9\u9547", "\u6c88\u5bb6\u95e8\u8857\u9053", "\u4e1c\u6e2f\u8857\u9053", "\u516d\u6a2a\u9547", "\u666e\u9640\u5c71\u9547", "\u7d2b\u91d1\u8857\u9053", "\u5ca9\u6cc9\u8857\u9053", "\u4e07\u8c61\u8857\u9053", "\u767d\u4e91\u8857\u9053", "\u5357\u660e\u5c71\u8857\u9053", "\u7ea2\u661f\u8857\u9053", "\u5251\u6c60\u8857\u9053");
        company.setDataSource(CompanyDataSourceEnum.DECLARE_20240203.getValue());
        company.setIsReport(Boolean.valueOf(true));
        company.setIsDec(Boolean.valueOf(true));
        company.setIsDecCurrentYear(Boolean.valueOf(true));
        company.setReportDate(wandaDeclare.getDeclareTime());
        company.setReportType(wandaDeclare.getDeclareType());
        AreaModel areaByName = this.sysAreaProvideService.getAreaByName(wandaDeclare.getArea());
        if (areaByName != null) {
            company.setAreaId(areaByName.getId());
            String name = areaByName.getName();
            if (belongTypeList.contains(name) || name.equalsIgnoreCase("\u67ef\u57ce\u533a")) {
                company.setBelongType(Integer.valueOf(2));
            }
        }
        return company;
    }

    private String getScaleBySize(String size) {
        if (StringUtil.isEmpty((String)size)) {
            return null;
        }
        String name = "";
        switch (size) {
            case "002": {
                name = CompanySizeEnum.Large.getCode().toString();
                break;
            }
            case "003": {
                name = CompanySizeEnum.Medium.getCode().toString();
                break;
            }
            case "004": {
                name = CompanySizeEnum.Small.getCode().toString();
                break;
            }
            case "005": {
                name = CompanySizeEnum.Undivided.getCode().toString();
                break;
            }
            case "006": {
                name = CompanySizeEnum.Micro.getCode().toString();
                break;
            }
        }
        return name;
    }

    private String getScaleByName(String name) {
        Integer codeByName;
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        if (name.contains("\u5927")) {
            name = "\u5927\u578b\u4f01\u4e1a";
        }
        if (name.contains("\u4e2d")) {
            name = "\u4e2d\u578b\u4f01\u4e1a";
        }
        if (name.contains("\u5c0f")) {
            name = "\u5c0f\u578b\u4f01\u4e1a";
        }
        if (name.contains("\u5fae")) {
            name = "\u5fae\u578b\u4f01\u4e1a";
        }
        if (name.contains("\u4e0d\u8be6")) {
            name = "\u672a\u5212\u5206";
        }
        if ((codeByName = CompanySizeEnum.getCodeByName((String)name)) == null) {
            return "";
        }
        return codeByName.toString();
    }

    public PageInfo<WandaDeclare> getWandaDeclareList(JqGridParam jparam, SearchParam searchParam) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<WandaDeclare> list = ((WandaDeclareMapper)this.dao).getWandaDeclareList(searchParam);
        list.forEach(item -> this.convertWandaDeclare((WandaDeclare)item, true));
        return new PageInfo(list);
    }

    public Map<Long, Date> getEarliestList(List<Long> cidList, Map<String, Object> map) {
        return ((WandaDeclareMapper)this.dao).getEarliestList(cidList);
    }

    public int countWandaDeclare(Long cid) {
        Example example = new Example(WandaDeclare.class);
        Example.Criteria criteria = example.createCriteria();
        if (cid != null) {
            criteria.andEqualTo("cid", (Object)cid);
        }
        int count = ((WandaDeclareMapper)this.dao).selectCountByExample(example);
        return count;
    }

    public Set<Long> getLastUpdateCid(Date updateDate) {
        if (updateDate == null) {
            return Collections.emptySet();
        }
        Example example = new Example(WandaDeclare.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true).andGreaterThanOrEqualTo("loadTime", (Object)updateDate);
        example.selectProperties(new String[]{"cid"});
        List wandaDeclares = ((WandaDeclareMapper)this.dao).selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)wandaDeclares)) {
            Set<Long> collect = wandaDeclares.stream().map(WandaDeclare::getCid).collect(Collectors.toSet());
            return collect;
        }
        return Collections.emptySet();
    }

    public WandaDeclare getWandaDeclareDetails(Long declareId) {
        WandaDeclare wandaDeclare = (WandaDeclare)((WandaDeclareMapper)this.dao).selectByPrimaryKey(declareId);
        this.convertWandaDeclare(wandaDeclare, true);
        DesensitizationUtils.setDesensitizationFieldFromObject((Object)wandaDeclare);
        return wandaDeclare;
    }

    public WandaDeclare getWandaDeclareDetailsWithoutConvert(String sourceId) {
        Example example = new Example(WandaDeclare.class);
        example.createCriteria().andEqualTo("sourceId", (Object)sourceId).andEqualTo("isValid", (Object)true);
        WandaDeclare declare = (WandaDeclare)((WandaDeclareMapper)this.dao).selectOneByExample(example);
        if (declare == null) {
            return null;
        }
        return declare;
    }

    public WandaDeclare getLastOneWandaDeclareByCid(Long cid) {
        Example example = new Example(WandaDeclare.class);
        example.createCriteria().andEqualTo("cid", (Object)cid);
        example.setOrderByClause("declare_time desc");
        List list = ((WandaDeclareMapper)this.dao).selectByExample(example);
        if (list != null && list.size() > 0 && !list.isEmpty() && StringUtils.isNotEmpty((String)((WandaDeclare)list.get(0)).getDeclareYear())) {
            return (WandaDeclare)list.get(0);
        }
        return null;
    }

    public List<CompanySuperviseModel> getCidByCode(String code, String name) {
        return ((WandaDeclareMapper)this.dao).getCidByCode(code, name);
    }

    private List<WandaDeclare> getListWithoutCid() {
        Example example = new Example(WandaDeclare.class);
        example.createCriteria().andIsNull("cid");
        return ((WandaDeclareMapper)this.dao).selectByExample(example);
    }

    public WandaDeclare convertWandaDeclare(WandaDeclare wandaDeclare, Boolean falg) {
        AreaModel areaModel;
        if (this.declareCache.estimatedSize() == 0L) {
            this.getDeclareCache();
        }
        List scaleTypeList = (List)this.declareCache.getIfPresent((Object)"\u4f01\u4e1a\u89c4\u6a21\u7f16\u7801");
        List industryTypeList = (List)this.declareCache.getIfPresent((Object)"\u884c\u4e1a\u7c7b\u522b\u7f16\u7801");
        List declareTypeList = (List)this.declareCache.getIfPresent((Object)"\u7533\u62a5\u7c7b\u578b\u7f16\u7801");
        List economicTypeList = (List)this.declareCache.getIfPresent((Object)"\u7ecf\u6d4e\u7c7b\u578b\u7f16\u7801");
        if (StringUtils.isNotBlank((CharSequence)wandaDeclare.getDeclareType())) {
            declareTypeList.forEach(item -> {
                if (item.getValue() != null && item.getValue().contains(wandaDeclare.getDeclareType())) {
                    wandaDeclare.setDeclareType(item.getValueLabel());
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)wandaDeclare.getEnterpriseSize())) {
            scaleTypeList.forEach(item -> {
                if (item.getValue() != null && item.getValue().contains(wandaDeclare.getEnterpriseSize())) {
                    wandaDeclare.setEnterpriseSize(item.getValueLabel());
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)wandaDeclare.getIndustryCode())) {
            industryTypeList.forEach(item -> {
                if (item.getValue() != null && item.getValue().contains(wandaDeclare.getIndustryCode())) {
                    wandaDeclare.setIndustryCode(item.getValueLabel());
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)wandaDeclare.getEconomic())) {
            economicTypeList.forEach(item -> {
                if (item.getValue() != null && item.getValue().contains(wandaDeclare.getEconomic())) {
                    wandaDeclare.setEconomic(item.getValueLabel());
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)wandaDeclare.getAreaCode()) && StringUtils.isNumber((String)wandaDeclare.getAreaCode()) && (areaModel = this.sysAreaProvideService.getAreaById(this.concatAreaId(wandaDeclare.getAreaCode()))) != null) {
            wandaDeclare.setAreaStr(areaModel.getFullname());
        }
        if (StringUtils.isNotBlank((CharSequence)wandaDeclare.getWorkAddr()) && StringUtils.isNumber((String)wandaDeclare.getWorkAddr()) && (areaModel = this.sysAreaProvideService.getAreaById(this.concatAreaId(wandaDeclare.getWorkAddr()))) != null) {
            wandaDeclare.setWorkAddrStr(areaModel.getFullname());
        }
        if (Objects.isNull(wandaDeclare.getCid()) && falg.booleanValue() && StringUtils.isEmpty((CharSequence)wandaDeclare.getNoMatchReason())) {
            wandaDeclare.setNoMatchReason("\u540c\u6b65\u66f4\u65b0\u4e2d");
        }
        return wandaDeclare;
    }

    public Map<Long, WandaDeclare> getDeclareMapByCid(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return new HashMap<Long, WandaDeclare>();
        }
        return ((WandaDeclareMapper)this.dao).getDeclareMapByCid(cidList);
    }

    private Long concatAreaId(String areaCode) {
        int length = ((String)areaCode).length();
        for (int i = 0; i < 12 - length; ++i) {
            areaCode = (String)areaCode + "0";
        }
        return Long.parseLong((String)areaCode);
    }
}

