/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.service.impl;

import cn.smarthse.services.wanda.api.entity.WandaCheckBackPushLog;
import cn.smarthse.services.wanda.api.entity.WandaCheckReturn;
import cn.smarthse.services.wanda.api.enums.WandCheckBackTypeEnm;
import cn.smarthse.services.wanda.api.enums.WandDealStateEnm;
import cn.smarthse.services.wanda.api.service.IWandaCheckBackPushLogService;
import cn.smarthse.services.wanda.api.service.IWandaCheckReturnService;
import cn.smarthse.services.wanda.api.service.IWandaZywsCheckFactorsService;
import cn.smarthse.services.wanda.api.service.IWandaZywsCheckService;
import cn.smarthse.services.wanda.api.service.IWandaZywsCheckTargetService;
import cn.smarthse.services.wanda.pulldata.mapper.WandaCheckBackPushLogMapper;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.ListUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
@Transactional(readOnly=true)
public class WandaCheckBackPushLogServiceImpl
extends ServiceImpl<WandaCheckBackPushLogMapper, WandaCheckBackPushLog>
implements IWandaCheckBackPushLogService {
    @Autowired
    protected IdWorker idworker;
    @DubboReference
    private IWandaCheckReturnService wandaCheckReturnService;
    @DubboReference
    IWandaZywsCheckService checkService;
    @DubboReference
    IWandaZywsCheckFactorsService checkFactorsService;
    @DubboReference
    IWandaZywsCheckTargetService checkTargetService;

    @Transactional
    public void distinctAddPushLog(List<WandaCheckBackPushLog> list, Integer type) {
        if (CollectionUtils.isEmpty(list) || type == null) {
            return;
        }
        List checkIdList = list.parallelStream().map(WandaCheckBackPushLog::getCheckId).distinct().collect(Collectors.toList());
        if (type.equals(WandCheckBackTypeEnm.verifySecondary.getCode())) {
            this.checkService.removeByColumn(checkIdList, "sourceId", Boolean.valueOf(false));
        }
        ArrayList<WandaCheckBackPushLog> needAddList = new ArrayList<WandaCheckBackPushLog>();
        Map pushLogMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(WandaCheckBackPushLog::getType, (Object)type)).eq(WandaCheckBackPushLog::getIsValid, (Object)true)).in(WandaCheckBackPushLog::getCheckId, checkIdList)).list().parallelStream().collect(Collectors.toMap(WandaCheckBackPushLog::getCheckId, Function.identity(), (old, now) -> now.getCreateDate().after(old.getCreateDate()) ? now : old));
        Map collect = list.parallelStream().collect(Collectors.toMap(WandaCheckBackPushLog::getCheckId, Function.identity(), (c1, c2) -> c1.getCreateDate().after(c2.getCreateDate()) ? c1 : c2));
        for (WandaCheckBackPushLog item : collect.values()) {
            WandaCheckBackPushLog pushLog;
            if (item == null || (pushLog = (WandaCheckBackPushLog)pushLogMap.get(item.getCheckId())) != null && pushLog.getCreateDate() != null && item.getCreateDate().getTime() <= pushLog.getCreateDate().getTime()) continue;
            item.setDealState(WandDealStateEnm.four.getCode().toString());
            item.setType(type);
            item.setReason(WandCheckBackTypeEnm.getName((Integer)type) + ":" + item.getReason());
            item.setStatus(Integer.valueOf(0));
            item.setUpdateDate(new Date());
            needAddList.add(item);
        }
        this.saveBatch(needAddList);
    }

    @Transactional
    public void addPushLogByConvert(List<String> collect, String reasonSupply) {
        Date date = new Date();
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }
        ArrayList<WandaCheckBackPushLog> pushLogList = new ArrayList<WandaCheckBackPushLog>();
        for (String checkId : collect) {
            WandaCheckBackPushLog pushLog = new WandaCheckBackPushLog();
            pushLog.setCheckId(checkId);
            pushLog.setDealState(WandDealStateEnm.two.getCode().toString());
            pushLog.setReason(reasonSupply + ":" + WandDealStateEnm.two.getName());
            pushLog.setType(WandCheckBackTypeEnm.empty.getCode());
            pushLog.setStatus(Integer.valueOf(0));
            pushLog.setCreateDate(date);
            pushLog.setUpdateDate(date);
            pushLogList.add(pushLog);
        }
        this.saveBatch(pushLogList);
    }

    @Transactional
    public void addPushLogByAlreadyPass(List<Long> wandaZywsCheckIdList) {
        Date date = new Date();
        List<String> checkIdList = ((WandaCheckBackPushLogMapper)this.baseMapper).getAlreadyPassAndNotAdd(wandaZywsCheckIdList);
        if (CollectionUtils.isEmpty(checkIdList)) {
            return;
        }
        ArrayList<WandaCheckBackPushLog> pushLogList = new ArrayList<WandaCheckBackPushLog>();
        for (String checkId : checkIdList) {
            WandaCheckBackPushLog pushLog = new WandaCheckBackPushLog();
            pushLog.setCheckId(checkId);
            pushLog.setDealState(WandDealStateEnm.three.getCode().toString());
            pushLog.setReason(WandDealStateEnm.three.getName());
            pushLog.setType(WandCheckBackTypeEnm.empty.getCode());
            pushLog.setStatus(Integer.valueOf(0));
            pushLog.setCreateDate(date);
            pushLog.setUpdateDate(date);
            pushLogList.add(pushLog);
        }
        List split = ListUtils.split(pushLogList, (int)1000);
        for (List wandaCheckBackPushLogList : split) {
            this.saveBatch(wandaCheckBackPushLogList);
        }
    }

    @Transactional
    public void pushNotBackCheckData() {
        this.log.error("\u5b9a\u65f6\u4efb\u52a1->\u63a8\u9001\u9000\u56de\u4e07\u8fbe\u4ed3\u68c0\u6d4b\u6570\u636e\u5f00\u59cb");
        Date date = new Date();
        List pushLogList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(WandaCheckBackPushLog::getIsValid, (Object)true)).ne(WandaCheckBackPushLog::getStatus, (Object)1)).list();
        if (CollectionUtils.isEmpty((Collection)pushLogList)) {
            this.log.error("\u5b9a\u65f6\u4efb\u52a1->\u63a8\u9001\u9000\u56de\u4e07\u8fbe\u4ed3\u68c0\u6d4b\u6570\u636e\u7ed3\u675f--\u65e0\u6570\u636e");
            return;
        }
        ArrayList<WandaCheckReturn> needWandaCheckReturnList = new ArrayList<WandaCheckReturn>();
        for (WandaCheckBackPushLog item2 : pushLogList) {
            if (item2 == null) continue;
            WandaCheckReturn checkReturn = new WandaCheckReturn();
            checkReturn.setId(Long.valueOf(this.idworker.nextId()));
            checkReturn.setCheckId(item2.getCheckId());
            checkReturn.setReturnTime(date);
            checkReturn.setReason(item2.getReason());
            checkReturn.setDealState(item2.getDealState());
            needWandaCheckReturnList.add(checkReturn);
            item2.setSourceId(checkReturn.getId());
            item2.setPushDate(date);
            item2.setUpdateDate(date);
            item2.setStatus(Integer.valueOf(1));
        }
        Set errorSet = this.wandaCheckReturnService.backToWanda(needWandaCheckReturnList);
        if (CollectionUtils.isNotEmpty((Collection)errorSet)) {
            pushLogList = pushLogList.parallelStream().peek(item -> {
                if (errorSet.contains(item.getSourceId()) || errorSet.contains(0L)) {
                    item.setStatus(Integer.valueOf(2));
                }
            }).collect(Collectors.toList());
        }
        this.updateBatchById(pushLogList);
        List<String> checkIdList = pushLogList.stream().filter(Objects::nonNull).map(WandaCheckBackPushLog::getCheckId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(checkIdList) && checkIdList.size() < 1500) {
            this.generateLastCheckBackPushLog(checkIdList);
        } else {
            this.generateLastCheckBackPushLog(null);
        }
        List errorCheckIdList = pushLogList.stream().filter(item -> item != null && item.getType().equals(WandCheckBackTypeEnm.verifySecondary.getCode())).map(WandaCheckBackPushLog::getCheckId).collect(Collectors.toList());
        this.checkFactorsService.removeFactorAndTargetByColumn(errorCheckIdList, "checkId", Boolean.valueOf(false));
        this.log.error("\u5b9a\u65f6\u4efb\u52a1->\u63a8\u9001\u9000\u56de\u4e07\u8fbe\u4ed3\u68c0\u6d4b\u6570\u636e\u7ed3\u675f");
    }

    @Transactional
    public void generateLastCheckBackPushLog(List<String> list) {
        ((WandaCheckBackPushLogMapper)this.baseMapper).clearLastCheckBackPushLog(list);
        List<WandaCheckBackPushLog> copyList = ((WandaCheckBackPushLogMapper)this.baseMapper).getLastCheckBackPushLog(list);
        if (CollectionUtils.isEmpty(copyList)) {
            return;
        }
        List split = ListUtils.split(copyList, (int)1000);
        for (List wandaCheckBackPushLogList : split) {
            if (!CollectionUtils.isNotEmpty((Collection)wandaCheckBackPushLogList)) continue;
            ((WandaCheckBackPushLogMapper)this.baseMapper).addLastCheckBackPushLog(wandaCheckBackPushLogList);
        }
    }
}

