/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.controller;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.services.wanda.api.entity.WandaCheckBackPushLog;
import cn.smarthse.services.wanda.api.entity.WandaCheckReturn;
import cn.smarthse.services.wanda.api.enums.WandCheckBackTypeEnm;
import cn.smarthse.services.wanda.api.enums.WandDealStateEnm;
import cn.smarthse.services.wanda.api.service.IWandaCheckBackPushLogService;
import cn.smarthse.services.wanda.api.service.IWandaCheckReturnService;
import cn.smarthse.services.wanda.api.service.IWandaZywsCheckFactorsService;
import cn.smarthse.services.wanda.api.service.IWandaZywsCheckService;
import cn.smarthse.services.wanda.task.pullTask.WandaZywsCheckFactorsTask;
import cn.smarthse.services.wanda.task.pullTask.WandaZywsCheckTask;
import jakarta.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class WandaZywsCheckController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaZywsCheckController.class);
    @Resource
    private WandaZywsCheckTask wandaZywsCheckTask;
    @Resource
    private WandaZywsCheckFactorsTask wandaZywsCheckFactorsTask;
    @DubboReference(check=false)
    private IWandaCheckReturnService wandaCheckReturnService;
    @DubboReference(check=false)
    private IWandaZywsCheckFactorsService zywsCheckFactorsService;
    @DubboReference(check=false)
    private IWandaZywsCheckService checkService;
    @DubboReference
    IWandaCheckBackPushLogService backPushLogService;
    @Value(value="${wanda.url}")
    private String url;
    private static String dataType = "json";

    @ResponseBody
    @RequestMapping(value={"test0"})
    public List<String> test0() throws UnsupportedEncodingException {
        String[] appKeyArr;
        ArrayList<String> list = new ArrayList<String>();
        Date start = DateUtils.parseDate((Object)"2025-02-07 09:00:01");
        Date end = DateUtils.parseDate((Object)"2025-02-07 12:00:01");
        for (String appkey : appKeyArr = new String[]{"BIZ_037_ZYWS_CHECK", "BIZ_037_ZYWS_CHECK_RETURN", "BIZ_037_ZYWS_CHECK_WEATHER", "BIZ_037_ZYWS_CHECK_UHFR", "BIZ_037_ZYWS_CHECK_NOISE", "BIZ_037_ZYWS_CHECK_MICRO_RADI", "BIZ_037_ZYWS_CHECK_LASER_RADI", "BIZ_037_ZYWS_CHECK_ION_SOURCE", "BIZ_037_ZYWS_CHECK_ION_RAY", "BIZ_037_ZYWS_CHECK_ILLUM", "BIZ_037_ZYWS_CHECK_HIGH_TEM", "BIZ_037_ZYWS_CHECK_HIGH_FREQ", "BIZ_037_ZYWS_CHECK_HAND_VIBR", "BIZ_037_ZYWS_CHECK_FRESH_AIR", "BIZ_037_ZYWS_CHECK_FREQUENCY", "BIZ_037_ZYWS_CHECK_DUST", "BIZ_037_ZYWS_CHECK_CHEMISTRY", "BIZ_037_ZYWS_CHECK_BIOLOGY", "BIZ_037_ZYWS_CHECK_AIR_SPEED", "BIZ_037_ZYWS_CHECK_ULTR_RAY"}) {
            String appSecret = "123456ZJ";
            if (appkey.equals("BIZ_037_ZYWS_CHECK_RETURN")) {
                appSecret = "123456";
            }
            String dateStr = DateUtils.formatDateTime((Date)new Date());
            String sign = DigestUtils.md5Hex((String)(appkey + dateStr + appSecret));
            dateStr = URLEncoder.encode(dateStr, "UTF-8");
            Object queryPara = "";
            String startStr = "";
            String endStr = "";
            if (appkey.equals("BIZ_037_ZYWS_CHECK_RETURN")) {
                startStr = DateUtils.format((Date)start, (String)"yyyyMMdd");
                endStr = DateUtils.format((Date)end, (String)"yyyyMMdd");
            } else {
                startStr = DateUtils.formatDateTime((Date)start);
                endStr = DateUtils.formatDateTime((Date)end);
            }
            queryPara = "{\"LOAD_TIME\":\"" + startStr + "," + endStr + "\"}";
            queryPara = URLEncoder.encode((String)queryPara, "UTF-8");
            dateStr = URLEncoder.encode(dateStr, "UTF-8");
            String info = appkey + "\u63a5\u53e3\uff1a" + this.url + "?appKey=" + appkey + "&sign=" + sign + "&strSysDatetime=" + dateStr + "&pageNum=1&pageSize=500&dataType=" + dataType + "&queryPara=" + (String)queryPara;
            list.add(info);
        }
        System.out.println(list);
        return list;
    }

    @ResponseBody
    @RequestMapping(value={"getWandaCheckConvertMap"})
    public Map<String, Object> getWandaCheckConvertMap() throws UnsupportedEncodingException {
        return this.checkService.getWandaCheckConvertMap();
    }

    @ResponseBody
    @RequestMapping(value={"pullCheck"})
    public String pullCheck() throws UnsupportedEncodingException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    WandaZywsCheckController.this.wandaZywsCheckTask.hcFactorsListData();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return "\u6210\u529f";
    }

    @ResponseBody
    @RequestMapping(value={"pullCheckFactors"})
    public String pullCheckFactors() throws UnsupportedEncodingException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    WandaZywsCheckController.this.wandaZywsCheckFactorsTask.hcFactorsListData();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return "\u6210\u529f";
    }

    @ResponseBody
    @RequestMapping(value={"test1"})
    public void test1() {
        WandaCheckReturn wandaCheckReturn = new WandaCheckReturn();
        wandaCheckReturn.setCheckId("2");
        wandaCheckReturn.setId(Long.valueOf(123L));
        wandaCheckReturn.setReturnTime(new Date());
        wandaCheckReturn.setDealState(WandDealStateEnm.five.getCode().toString());
        wandaCheckReturn.setReason(WandCheckBackTypeEnm.normal.getName() + ":\u6d4b\u8bd5\u76d1\u7ba1\u9000\u56de");
        wandaCheckReturn.setType(WandCheckBackTypeEnm.normal.getCode());
        this.wandaCheckReturnService.backToWanda(wandaCheckReturn);
    }

    @ResponseBody
    @RequestMapping(value={"test2"})
    public void test2() {
        Date date = new Date();
        WandaCheckBackPushLog log = new WandaCheckBackPushLog();
        log.setCheckId("2");
        log.setReason("\u6d4b\u8bd5\u4e3b\u8868\u9000\u56de");
        log.setCreateDate(date);
        WandaCheckBackPushLog log2 = new WandaCheckBackPushLog();
        log2.setCheckId("2");
        log2.setReason("\u6d4b\u8bd5\u5b50\u8868\u9000\u56de");
        log2.setCreateDate(date);
        this.backPushLogService.distinctAddPushLog(Collections.singletonList(log), WandCheckBackTypeEnm.verifyMain.getCode());
        this.backPushLogService.distinctAddPushLog(Collections.singletonList(log2), WandCheckBackTypeEnm.verifySecondary.getCode());
    }

    @ResponseBody
    @RequestMapping(value={"test3"})
    public void test3() {
        this.backPushLogService.pushNotBackCheckData();
    }
}

