/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.controller;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.services.wanda.api.model.HealthCardSearchModel;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import cn.smarthse.services.wanda.pulldata.controller.WandaBaseController;
import cn.smarthse.services.wanda.pushdata.hse.dao.WandaCompanyMapper;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/wanda/declare"})
public class WandaDeclareController
extends WandaBaseController<WandaDeclare> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaDeclareController.class);
    @DubboReference
    private IWandaDeclareService wandaDeclareService;
    @Autowired
    protected IdWorker idworker;
    @Autowired
    WandaCompanyMapper companyMapper;

    @ResponseBody
    @GetMapping(value={"/declareListData"})
    public synchronized ResponseData<List<WandaDeclare>> declareListData(HealthCardSearchModel searchModel) throws UnsupportedEncodingException, ParseException {
        ResponseData response = new ResponseData();
        ArrayList reslutList = new ArrayList();
        log.info("=======================\u4e07\u8fbe\u4ed3\u7533\u62a5\u6570\u636e\u540c\u6b65\u5f00\u59cb============================");
        Date start = DateUtil.parseDate((String)"2023-03-31 00:00:00", (String)"yyyy-MM-dd hh:mm:ss");
        this.doTask(reslutList, "1", start, new Date());
        response.setResult(reslutList);
        return response;
    }

    @Override
    public String getAppkey() {
        return "BIZ_037_ZYWS_DECLARE_ZJ";
    }

    @Override
    public void save(List<WandaDeclare> reslutList) {
        this.wandaDeclareService.batchInsert(reslutList);
    }

    @Override
    public void parseData(List<WandaDeclare> reslutList, JSONArray data) {
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                String sourceId = jsonObject.getString("ID");
                jsonObject.put("sourceId", (Object)sourceId);
                jsonObject.remove((Object)"ID");
                WandaDeclare object = (WandaDeclare)jsonObject.toJavaObject(WandaDeclare.class);
                object.setId(Long.valueOf(this.idworker.nextId()));
                List models = this.wandaDeclareService.getCidByCode(object.getCreditCode(), object.getEmpName());
                if (CollectionUtils.isNotEmpty((Collection)models)) {
                    CompanySuperviseModel companySuperviseModel = models.stream().filter(item -> item.getIsDec()).findFirst().orElse(null);
                    if (Objects.nonNull(companySuperviseModel)) {
                        object.setIsDec(Boolean.valueOf(true));
                        object.setCid(companySuperviseModel.getId());
                    } else {
                        object.setIsDec(Boolean.valueOf(false));
                        object.setCid(((CompanySuperviseModel)models.get(0)).getId());
                    }
                }
                object.setUpdateDate(new Date());
                object.setCreateDate(new Date());
                object.setIsValid(Boolean.valueOf(true));
                reslutList.add(object);
            }
        }
    }

    @GetMapping(value={"/importCompany"})
    @ResponseBody
    public String importCompany(String creditCode) {
        this.wandaDeclareService.refreshOldWandaDeclareData(creditCode);
        return "\u5bfc\u5165\u6210\u529f";
    }
}

