/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.controller;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.services.wanda.api.entity.WandaBaseData;
import cn.smarthse.services.wanda.api.model.WandaPullModel;
import cn.smarthse.util.common.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public abstract class WandaBaseController<T extends WandaBaseData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaBaseController.class);
    private String url;
    private String appSecret;
    private String dataType;
    private String pageSize;
    private Class<T> resultType;

    public abstract String getAppkey();

    public abstract void save(List<T> var1);

    public WandaBaseController() {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            this.resultType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
    }

    public void doTask(List<T> reslutList, String pageNum, Date start, Date end) throws UnsupportedEncodingException {
        if (this.resultType == null) {
            throw new RuntimeException("\u8bf7\u6dfb\u52a0\u5177\u4f53\u6cdb\u578b\uff01");
        }
        String json = this.fetchData(pageNum, start, end);
        WandaPullModel wandaPullModel = this.convertJson(json);
        Integer pageTotal = wandaPullModel.getPageTotal();
        int begin = Integer.parseInt(pageNum);
        Integer i = begin;
        while (i <= pageTotal) {
            WandaPullModel model = this.convertJson(this.fetchData("" + i, start, end));
            this.parseData(reslutList, model.getJsonArray());
            if (pageTotal != model.getPageTotal()) {
                pageTotal = model.getPageTotal();
            }
            this.save(reslutList);
            reslutList.clear();
            Integer n = i;
            i = i + 1;
        }
    }

    private String fetchData(String pageNum, Date start, Date end) throws UnsupportedEncodingException {
        HashMap<String, String> param = new HashMap<String, String>();
        String dateStr = DateUtils.formatDateTime((Date)new Date());
        String sign = DigestUtils.md5Hex((String)(this.getAppkey() + dateStr + this.appSecret));
        dateStr = URLEncoder.encode(dateStr, "UTF-8");
        param.put("appKey", this.getAppkey());
        param.put("strSysDatetime", dateStr);
        param.put("pageNum", pageNum);
        param.put("pageSize", this.pageSize);
        param.put("dataType", this.dataType);
        Object queryPara = "";
        String startStr = "";
        String endStr = "";
        if (start != null) {
            startStr = DateUtils.formatDateTime((Date)start);
            if (end == null) {
                end = DateUtils.addMonth((Date)start, (int)1);
            }
            endStr = DateUtils.formatDateTime((Date)end);
        }
        if (StringUtils.isNotBlank((CharSequence)startStr) && StringUtils.isNotBlank((CharSequence)endStr)) {
            queryPara = "{\"LOAD_TIME\":\"" + startStr + "," + endStr + "\"}";
            queryPara = URLEncoder.encode((String)queryPara, "UTF-8");
        } else {
            queryPara = "{}";
        }
        param.put("queryPara", (String)queryPara);
        param.put("sign", sign);
        log.info("\u8bf7\u6c42\u53c2\u6570,param:{}", (Object)JSON.toJSONString(param));
        String responseText = HttpUtil.doGet((String)this.url, param);
        log.info("responseText\uff1a{}", (Object)responseText);
        log.info("\u63a5\u53e3\uff1a" + this.url + "?appKey=" + this.getAppkey() + "&sign=" + sign + "&strSysDatetime=" + dateStr + "&pageNum=1&pageSize=500&dataType=" + this.dataType + "&queryPara=" + (String)queryPara);
        return responseText;
    }

    private WandaPullModel convertJson(String responseText) {
        JSONObject root;
        WandaPullModel model = new WandaPullModel();
        JSONObject jsonObject = JSONObject.parseObject((String)responseText);
        if (jsonObject != null && jsonObject.containsKey((Object)"root") && (root = jsonObject.getJSONObject("root")).containsKey((Object)"request")) {
            JSONObject dataList;
            JSONObject body;
            JSONObject request = root.getJSONObject("request");
            if (request.containsKey((Object)"body") && (body = request.getJSONObject("body")).containsKey((Object)"dataList") && (dataList = body.getJSONObject("dataList")).containsKey((Object)"data")) {
                JSONArray data = dataList.getJSONArray("data");
                model.setJsonArray(data);
            }
            if (request.containsKey((Object)"header")) {
                JSONObject header = request.getJSONObject("header");
                Integer pageSum = header.getInteger("pageSum");
                model.setPageTotal(pageSum);
            }
        }
        return model;
    }

    public String getDataFromUrl(List<T> reslutList, String pageNum, Date start, Date end) throws UnsupportedEncodingException {
        JSONObject root;
        if (this.resultType == null) {
            throw new RuntimeException("\u8bf7\u6dfb\u52a0\u5177\u4f53\u6cdb\u578b\uff01");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        String dateStr = DateUtils.formatDateTime((Date)new Date());
        String sign = DigestUtils.md5Hex((String)(this.getAppkey() + dateStr + this.appSecret));
        dateStr = URLEncoder.encode(dateStr, "UTF-8");
        param.put("appKey", this.getAppkey());
        param.put("strSysDatetime", dateStr);
        param.put("pageNum", pageNum);
        param.put("pageSize", this.pageSize);
        param.put("dataType", this.dataType);
        Object queryPara = "";
        String startStr = "";
        String endStr = "";
        if (start != null) {
            startStr = DateUtils.format((Date)start, (String)"yyyyMMdd");
            if (end == null) {
                end = DateUtils.addMonth((Date)start, (int)1);
            }
            endStr = DateUtils.format((Date)end, (String)"yyyyMMdd");
        }
        if (StringUtils.isNotBlank((CharSequence)startStr) && StringUtils.isNotBlank((CharSequence)endStr)) {
            queryPara = "{\"LOAD_TIME\":\"" + startStr + "," + endStr + "\"}";
            queryPara = URLEncoder.encode((String)queryPara, "UTF-8");
        } else {
            queryPara = "{}";
        }
        param.put("queryPara", (String)queryPara);
        param.put("sign", sign);
        log.info("\u8bf7\u6c42\u53c2\u6570,param:{}", (Object)JSON.toJSONString(param));
        String responseText = HttpUtil.doGet((String)this.url, param);
        log.info("responseText\uff1a{}", (Object)responseText);
        JSONObject jsonObject = JSONObject.parseObject((String)responseText);
        if (jsonObject != null && jsonObject.containsKey((Object)"root") && (root = jsonObject.getJSONObject("root")).containsKey((Object)"request")) {
            JSONObject header;
            Integer pageSum;
            JSONObject dataList;
            JSONObject body;
            JSONObject request = root.getJSONObject("request");
            if (request.containsKey((Object)"body") && (body = request.getJSONObject("body")).containsKey((Object)"dataList") && (dataList = body.getJSONObject("dataList")).containsKey((Object)"data")) {
                JSONArray data = dataList.getJSONArray("data");
                this.parseData(reslutList, data);
            }
            if (request.containsKey((Object)"header") && (pageSum = (header = request.getJSONObject("header")).getInteger("pageSum")) != null && pageSum >= Integer.parseInt(pageNum)) {
                reslutList.clear();
                this.getDataFromUrl(reslutList, "" + (Integer.parseInt(pageNum) + 1), start, end);
            }
        }
        return "\u63a5\u53e3\uff1a" + this.url + "?appKey=" + this.getAppkey() + "&sign=" + sign + "&strSysDatetime=" + dateStr + "&pageNum=1&pageSize=500&dataType=" + this.dataType + "&queryPara= " + (String)queryPara;
    }

    private String jsonText() {
        return "{\n  \"root\": {\n    \"request\": {\n      \"header\": {\n        \"msgId\": \"f19d9e4b-cd9c-471b-bccb-2a3ba76f3f6a\",\n        \"resourceId\": \"\u4fe1\u606f\u8d44\u6e90\u4ee3\u7801\",\n        \"resourceName\": \"\u4fe1\u606f\u8d44\u6e90\u540d\u79f0\",\n        \"subResourceId\": \"\u4fe1\u606f\u8d44\u6e90\u5b50\u9879\u4ee3\u7801\",\n        \"action\": \"query\",\n        \"sendTime\": \"2017-03-08 09:25:06\",\n        \"pageSum\": \"1\"\n      },\n      \"body\": {\n        \"dataList\": {\n          \"data\": [\n            {\n              \"subject\": \"biz_\u90e8\u95e8\u7f16\u7801_\u4e1a\u52a1\u63cf\u8ff0\",\n              \"subject_flag\": \"\u4e3b\u9898\u6807\u793a\",\n              \"id\": \"1112331\",\n              \"name\": \"testss1\",\n              \"orgCode\": \"orgdd\",\n              \"bizTime\": \"2017-11-15 12:12:18\",\n              \"loadTime\": \"2022-11-15 12:12:18\"\n            },\n            {\n              \"subject\": \"biz_\u90e8\u95e8\u7f16\u7801_\u4e1a\u52a1\u63cf\u8ff01\",\n              \"subject_flag\": \"\u4e3b\u9898\u6807\u793a2\",\n              \"id\": \"11123312\",\n              \"name\": \"testss12\",\n              \"orgCode\": \"orgdd2\",\n              \"Biz_time\": \"2017-12-15 12:12:18\",\n              \"load_time\": \"2022-12-15 12:12:18\"\n            }\n          ]\n        }\n      }\n    }\n  }\n}";
    }

    public abstract void parseData(List<T> var1, JSONArray var2);

    @Value(value="${wanda.url}")
    public void setUrl(String url) {
        this.url = url;
    }

    @Value(value="${wanda.appSecret}")
    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @Value(value="${wanda.dataType}")
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Value(value="${wanda.pageSize}")
    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }
}

