/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.controller;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.services.wanda.api.entity.WandaOdiBase;
import cn.smarthse.services.wanda.api.model.HealthCardSearchModel;
import cn.smarthse.services.wanda.api.service.IWandaOdiBaseService;
import cn.smarthse.services.wanda.pulldata.controller.WandaBaseController;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import jakarta.annotation.PostConstruct;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/wanda/OdiBase"})
public class OdiBaseController
extends WandaBaseController<WandaOdiBase> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OdiBaseController.class);
    private static String url = "http://59.202.19.151:8082/wdrc/dataQueryService";
    private static String appKey = "BIZ_037_ZYWS_ODI_BASE_ZJ";
    @Value(value="${odiBase.appSecret}")
    private String appSecretTo;
    private static String appSecret;
    private static String dataType;
    private static String pageSize;
    @DubboReference
    private IWandaOdiBaseService odiBaseService;

    @PostConstruct
    private void init() {
        appSecret = this.appSecretTo;
    }

    @Override
    public String getAppkey() {
        return "BIZ_037_ZYWS_ODI_BASE_ZJ";
    }

    @Override
    public void save(List<WandaOdiBase> reslutList) {
        this.odiBaseService.batchInsert(reslutList);
    }

    @Override
    public void parseData(List<WandaOdiBase> reslutList, JSONArray data) {
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                String sourceId = jsonObject.getString("ID");
                jsonObject.put("sourceId", (Object)sourceId);
                jsonObject.remove((Object)"ID");
                WandaOdiBase object = (WandaOdiBase)data.getObject(i, WandaOdiBase.class);
                object.setUpdateDate(new Date());
                object.setCreateDate(new Date());
                reslutList.add(object);
            }
        }
    }

    @ResponseBody
    @GetMapping(value={"/addOdiBaseListData"})
    public synchronized ResponseData<List<WandaOdiBase>> addOdiBaseListData(HealthCardSearchModel searchModel) throws UnsupportedEncodingException {
        ResponseData response = new ResponseData();
        ArrayList reslutList = new ArrayList();
        String url = this.getDataFromUrl(reslutList, "1", null, null);
        response.setResult(reslutList);
        response.setContent(url);
        return response;
    }

    static {
        dataType = "json";
        pageSize = "500";
    }
}

