/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.wanda.pulldata.controller;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.services.wanda.api.entity.WandaHealthCard;
import cn.smarthse.services.wanda.api.model.HealthCardSearchModel;
import cn.smarthse.services.wanda.api.service.IWandaHealthCardService;
import cn.smarthse.services.wanda.pulldata.controller.WandaBaseController;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/wanda/healthcard"})
public class HealthCardController
extends WandaBaseController<WandaHealthCard> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthCardController.class);
    @DubboReference
    private IWandaHealthCardService healthCardService;
    @Autowired
    protected IdWorker idworker;

    @Override
    public String getAppkey() {
        return "BIZ_037_ZYWS_HEALTH_CARD_ZJ";
    }

    @Override
    public void save(List<WandaHealthCard> reslutList) {
        this.healthCardService.batchInsert(reslutList);
    }

    @Override
    public void parseData(List<WandaHealthCard> reslutList, JSONArray data) {
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                String sourceId = jsonObject.getString("ID");
                jsonObject.put("sourceId", (Object)sourceId);
                jsonObject.remove((Object)"ID");
                WandaHealthCard object = (WandaHealthCard)jsonObject.toJavaObject(WandaHealthCard.class);
                object.setId(Long.valueOf(this.idworker.nextId()));
                object.setUpdateDate(new Date());
                object.setCreateDate(new Date());
                object.setIsValid(Boolean.valueOf(true));
                object.setIsConverted(Byte.valueOf((byte)0));
                object.setOrgCode(object.getOrgCode() == null ? object.getOrgName() : object.getOrgCode());
                reslutList.add(object);
            }
        }
    }

    @ResponseBody
    @GetMapping(value={"/test"})
    public String test() {
        WandaHealthCard byId = (WandaHealthCard)this.healthCardService.getById(Long.valueOf(3847758760937474L));
        return "success";
    }

    @ResponseBody
    @GetMapping(value={"/syncdata"})
    public synchronized ResponseData<List<WandaHealthCard>> syncdata(HealthCardSearchModel searchModel) throws UnsupportedEncodingException {
        ResponseData response = new ResponseData();
        ArrayList reslutList = new ArrayList();
        log.info("=======================\u4e07\u8fbe\u4ed3\u4f53\u68c0\u4e3b\u8868\u6570\u636e\u540c\u6b65\u5f00\u59cb============================");
        Date startDate = null;
        Date maxLoadTime = this.healthCardService.getMaxLoadTime();
        if (Objects.nonNull(maxLoadTime)) {
            startDate = maxLoadTime;
        }
        this.doTask(reslutList, "1", startDate, new Date());
        response.setResult(reslutList);
        log.info("=======================\u4e07\u8fbe\u4ed3\u4f53\u68c0\u4e3b\u8868\u6570\u636e\u540c\u6b65\u7ed3\u675f============================");
        return response;
    }
}

