/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.threeTime.service.impl;

import cn.smarthse.modules.health.supervise.service.company.IThirdCompanyService;
import cn.smarthse.services.threeTime.mapper.ThreeTimeFetchLogMapper;
import cn.smarthse.services.wanda.api.entity.threeTime.ThreeTimeFetchLog;
import cn.smarthse.services.wanda.api.service.threeTime.IThreeTimeDataService;
import cn.smarthse.services.wanda.api.service.threeTime.IThreeTimeFetchLogService;
import cn.smarthse.services.wanda.pushdata.hse.dao.WandaCompanyMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ThreeTimeFetchLogServiceImpl
extends ServiceImpl<ThreeTimeFetchLogMapper, ThreeTimeFetchLog>
implements IThreeTimeFetchLogService {
    @DubboReference
    private IThirdCompanyService companyService;
    @Autowired
    private IThreeTimeDataService threeTimeDataService;
    @Autowired
    private WandaCompanyMapper companyMapper;

    @Transactional(readOnly=false)
    public ThreeTimeFetchLog getLog(String businessName) {
        long totalNum = 0L;
        int pageSize = 2000;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ThreeTimeFetchLog::getBusinessName, (Object)businessName);
        ThreeTimeFetchLog fetchLog = (ThreeTimeFetchLog)this.getOne((Wrapper)wrapper);
        if (businessName.equalsIgnoreCase("investment_projects")) {
            totalNum = Math.toIntExact(this.threeTimeDataService.count());
        } else if (businessName.equalsIgnoreCase("industry")) {
            pageSize = 19000;
            totalNum = this.companyMapper.indexCount().intValue();
        } else if (businessName.equalsIgnoreCase("marketEntities")) {
            pageSize = 9000;
            totalNum = this.companyService.countCompanyTotalNum();
        } else if (businessName.equalsIgnoreCase("data")) {
            pageSize = 15000;
            totalNum = this.companyService.countCompanyTotalNum();
        } else {
            totalNum = this.companyService.countCompanyTotalNum();
        }
        if (Objects.nonNull(fetchLog)) {
            if (fetchLog.getCurrentIndex() > fetchLog.getTotalPage()) {
                fetchLog.setCurrentIndex(Integer.valueOf(1));
            }
            int totalPage = (int)Math.ceil((double)totalNum * 1.0 / (double)pageSize);
            fetchLog.setTotalPage(Integer.valueOf(totalPage));
            fetchLog.setDalyNum(Integer.valueOf(pageSize));
            this.updateById(fetchLog);
            return fetchLog;
        }
        ThreeTimeFetchLog log = new ThreeTimeFetchLog();
        log.setBusinessName(businessName);
        log.setCurrentIndex(Integer.valueOf(1));
        int totalPage = (int)Math.ceil((double)totalNum * 1.0 / (double)pageSize);
        log.setTotalPage(Integer.valueOf(totalPage));
        log.setDalyNum(Integer.valueOf(pageSize));
        this.save(log);
        return log;
    }

    public void removeFinishLog(List<ThreeTimeFetchLog> list) {
    }

    public int batchInsert(List<ThreeTimeFetchLog> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        this.saveBatch(list);
        return 0;
    }
}

