/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.threeTime.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.model.threeTimes.ThreeTimesSearchParam;
import cn.smarthse.modules.health.supervise.service.company.IThirdCompanyService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.threeTime.mapper.ThreeTimeDataMapper;
import cn.smarthse.services.wanda.api.entity.threeTime.ThreeTimeData;
import cn.smarthse.services.wanda.api.service.threeTime.IThreeTimeDataService;
import cn.smarthse.services.wanda.api.service.threeTime.IThreeTimeFetchLogService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
@Transactional(readOnly=true)
public class ThreeTimeDataServiceImpl
extends ServiceImpl<ThreeTimeDataMapper, ThreeTimeData>
implements IThreeTimeDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreeTimeDataServiceImpl.class);
    @DubboReference
    private IThirdCompanyService companyService;
    @Autowired
    IThreeTimeFetchLogService threeTimeFetchLogService;
    @DubboReference(version="1.0.0")
    ISysAreaProvideService sysAreaService;

    @Transactional(readOnly=false)
    public int batchInsert(List<ThreeTimeData> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        ArrayList insertList = new ArrayList();
        ArrayList updateList = new ArrayList();
        List projectCodeList = list.stream().map(ThreeTimeData::getProjectCode).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(ThreeTimeData::getProjectCode, projectCodeList);
        List dbList = this.list((Wrapper)wrapper);
        list.forEach(item -> {
            ThreeTimeData dbData = dbList.stream().filter(d -> d.getProjectCode().equalsIgnoreCase(item.getProjectCode())).findFirst().orElse(null);
            if (Objects.nonNull(dbData)) {
                item.setId(dbData.getId());
                item.setUpdateDate(new Date());
                item.setIsSync(dbData.getIsSync());
                updateList.add(item);
            } else {
                item.setId(Long.valueOf(IdWorker.getId()));
                item.setUpdateDate(new Date());
                item.setCreateDate(new Date());
                insertList.add(item);
            }
        });
        this.saveBatch(insertList);
        this.updateBatchById(updateList);
        return list.size();
    }

    @Transactional(readOnly=false)
    public int removeData(List<Long> cids) {
        if (CollectionUtil.isEmpty(cids)) {
            return 0;
        }
        return ((ThreeTimeDataMapper)this.baseMapper).deleteByCids(cids);
    }

    public List<ThreeTimeData> listPage(String unifiedSocialCc, Integer start, Integer size) {
        return ((ThreeTimeDataMapper)this.baseMapper).listPage(unifiedSocialCc, start, size);
    }

    public ThreeTimeData getByprojectCode(String projectCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ThreeTimeData::getProjectCode, (Object)projectCode);
        return (ThreeTimeData)this.getOne((Wrapper)wrapper);
    }

    public List<ThreeTimeData> getNotSyncData(Long cid) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ThreeTimeData::getIsSync, (Object)false);
        if (cid != null) {
            wrapper.eq(ThreeTimeData::getCid, (Object)cid);
        }
        return this.list((Wrapper)wrapper);
    }

    public Long countNotSyncData(Long cid) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ThreeTimeData::getIsSync, (Object)false);
        if (cid != null) {
            wrapper.eq(ThreeTimeData::getCid, (Object)cid);
        }
        return this.count((Wrapper)wrapper);
    }

    @Transactional(readOnly=false)
    public void updateBatch(List<ThreeTimeData> threeTimeDataArrayList) {
        if (CollectionUtils.isNotEmpty(threeTimeDataArrayList)) {
            this.updateBatchById(threeTimeDataArrayList);
        }
    }

    public ThreeTimeData getByCidAndProjectName(Long cid, String projectName) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(ThreeTimeData::getCid, (Object)cid)).eq(ThreeTimeData::getProjectName, (Object)projectName);
        wrapper.last(" limit 1");
        return (ThreeTimeData)this.getOne((Wrapper)wrapper);
    }

    public List<ThreeTimeData> listByCIdSet(Set<Long> cidSet) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.in(ThreeTimeData::getCid, cidSet)).between(ThreeTimeData::getApplyDate, (Object)DateUtil.getDate((String)"2021-01-01", (String)"yyyy-MM-dd"), (Object)new Date());
        return this.list((Wrapper)wrapper);
    }

    public List<Long> getCidList(Integer pageSize, Long cid) {
        return ((ThreeTimeDataMapper)this.baseMapper).getCidList(pageSize, cid);
    }

    @Transactional
    public void delBatch(List<ThreeTimeData> threeTimeDataArrayList) {
        if (CollectionUtils.isEmpty(threeTimeDataArrayList)) {
            return;
        }
        List delIds = threeTimeDataArrayList.stream().map(ThreeTimeData::getId).collect(Collectors.toList());
        this.removeByIds(delIds);
    }

    public List<ThreeTimeData> getList(ThreeTimesSearchParam searchParam) {
        return ((ThreeTimeDataMapper)this.baseMapper).getList(searchParam);
    }

    public List<ThreeTimeData> getList(int start, int size, Long cid) {
        return ((ThreeTimeDataMapper)this.baseMapper).list(start, size, cid);
    }

    public List<ThreeTimeData> getList(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThreeTimeData.class);
        ((LambdaQueryWrapper)wrapper.eq(ThreeTimeData::getIsSync, (Object)false)).in(ThreeTimeData::getCid, cidList);
        return this.list((Wrapper)wrapper);
    }

    public List<ThreeTimeData> getProjectListByStorageDate(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((ThreeTimeDataMapper)this.baseMapper).getProjectListByStorageDate(cidList);
    }

    public List<ThreeTimeData> getProjectListByNowProjSituation(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((ThreeTimeDataMapper)this.baseMapper).getProjectListByNowProjSituation(cidList);
    }

    public PageInfo<ThreeTimeData> PageList(JqGridParam param, ThreeTimesSearchParam searchParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        PageInfo page = new PageInfo(this.getList(searchParam));
        return page;
    }

    public ThreeTimeData getInfoById(Long id) {
        ThreeTimeData data = (ThreeTimeData)this.getById(id);
        DesensitizationUtils.setDesensitizationFieldFromObject((Object)data);
        AreaModel areaModel = this.sysAreaService.getAreaById(this.concatAreaId(data.getDivisionCode()));
        String dicisionName = this.getAreaFullName(areaModel);
        data.setDivisionDetail(dicisionName);
        return data;
    }

    private String getAreaFullName(AreaModel area) {
        StringBuffer areaName = new StringBuffer();
        areaName.append(area.getProvinceName());
        if (StringUtils.isNotBlank((CharSequence)area.getCityName())) {
            areaName.append(area.getCityName());
        }
        if (StringUtils.isNotBlank((CharSequence)area.getAreaName())) {
            areaName.append(area.getAreaName());
        }
        if (StringUtils.isNotBlank((CharSequence)area.getStreetName())) {
            areaName.append(area.getStreetName());
        }
        return areaName.toString();
    }

    private Long concatAreaId(String areaCode) {
        int length = areaCode.length();
        StringBuilder areaCodeBuilder = new StringBuilder(areaCode);
        for (int i = 0; i < 12 - length; ++i) {
            areaCodeBuilder.append("0");
        }
        areaCode = areaCodeBuilder.toString();
        return Long.parseLong(areaCode);
    }
}

