/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.threeTime.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import cn.smarthse.common.framework.log.DebugUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.services.wanda.api.entity.threeTime.SecretData;
import cn.smarthse.services.wanda.api.entity.threeTime.ThreeTimeData;
import cn.smarthse.services.wanda.api.entity.threeTime.ThreeTimeFetchLog;
import cn.smarthse.services.wanda.api.service.threeTime.IThreeTimeDataService;
import cn.smarthse.services.wanda.api.service.threeTime.IThreeTimeFetchLogService;
import cn.smarthse.services.wanda.pushdata.hse.dao.WandaCompanyMapper;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sztech.gateway.shared.core.TypeRef;
import com.sztech.gateway.shared.jackson.JacksonUtil;
import com.sztech.gateway.shared.service.core.OpenServiceClient;
import com.sztech.gateway.shared.service.info.GatewayRequest;
import com.sztech.gateway.shared.service.info.GatewayResult;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class ThreeTimeBaseServiceImpl<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreeTimeBaseServiceImpl.class);
    @Autowired
    IThreeTimeFetchLogService threeTimeFetchLogService;
    @Autowired
    private WandaCompanyMapper companyMapper;
    @Autowired
    IThreeTimeDataService threeTimeDataService;
    @Autowired
    private OpenServiceClient openServiceClient;
    private static SecretData secretCache = null;
    private final ObjectMapper objectMapper = JacksonUtil.MAPPER;
    public String appKey = "A330000220463202210016307";
    public String appSecret = "390a37e2e80449b891e19d9067328927";
    @Value(value="${x.security.check.type}")
    private String xSecurityCheckType;
    @Value(value="${x.security.user.id}")
    private String xSecurityUserId;
    @Value(value="${x.security.user.ip}")
    private String xSecurityUserIp;
    private static final String X_SECURITY_SERVICE_ID = "2002327865";
    private final AtomicInteger refreshTokenCount = new AtomicInteger(0);
    private final AtomicInteger callIrsDataCount = new AtomicInteger(0);

    public abstract String businessName();

    public abstract String resourceCode();

    public abstract String url(Long var1, String var2, String var3, String var4, String var5);

    public int removeData(List<Long> cids) {
        return 0;
    }

    public int removeDataByProjectCodes(List<String> projectCodes) {
        return 0;
    }

    public int removeDataByUnifiedSocialCc(List<String> unifiedSocialCcList) {
        return 0;
    }

    public abstract int batchInsert(List<T> var1, Map<String, Long> var2);

    public abstract void parseData(String var1, List<T> var2, Long var3);

    public List<T> fetchData(String unifiedSocialCc) {
        Boolean tempHand;
        String businessName = this.businessName();
        ThreeTimeFetchLog fetchLog = this.threeTimeFetchLogService.getLog(businessName);
        Map<Object, Object> paramMap = new HashMap();
        if (StrUtil.isNotBlank((CharSequence)unifiedSocialCc) && unifiedSocialCc.contains("\u540c\u6b65IRS\u6307\u5b9a\u4f01\u4e1a\u4fe1\u606f")) {
            tempHand = Boolean.TRUE;
            List<Company> companyList = this.companyMapper.getSpecificCompanyList(unifiedSocialCc);
            if (CollUtil.isNotEmpty(companyList)) {
                paramMap = companyList.stream().collect(Collectors.toMap(Company::getUnifiedSocialCc, Company::getId, (v1, v2) -> v2));
            }
        } else {
            tempHand = Boolean.FALSE;
            paramMap = this.getParam(fetchLog, unifiedSocialCc);
        }
        Map<Object, Object> finalParamMap = paramMap;
        if (MapUtils.isEmpty(finalParamMap)) {
            return Collections.emptyList();
        }
        ArrayList dataList = new ArrayList();
        CollUtil.split(finalParamMap.keySet(), (int)2000).forEach(keyList -> {
            dataList.clear();
            HashMap<String, Long> delMap = new HashMap<String, Long>();
            keyList.forEach(key -> {
                Long value = (Long)finalParamMap.get(key);
                this.invokeWithSdk((String)key, value, dataList);
                delMap.put((String)key, value);
            });
            if (Boolean.TRUE.equals(tempHand)) {
                delMap.put("\u4e34\u65f6\u5904\u7406", 1L);
            }
            int successNum = this.batchInsert(dataList, delMap);
            log.info("[{}]\u65e5\u5fd7\u6253\u5370::\u6210\u529f\u63d2\u5165[{}]\u6761\u6570\u636e", (Object)this.businessName(), (Object)successNum);
        });
        if (StrUtil.isBlank((CharSequence)unifiedSocialCc)) {
            fetchLog.setCurrentIndex(Integer.valueOf(fetchLog.getCurrentIndex() + 1));
            this.threeTimeFetchLogService.updateById((Object)fetchLog);
        }
        return dataList;
    }

    public List<T> fetchDataByName(String companyName) {
        List<Company> companyList = this.companyMapper.listCompany(companyName);
        Map<String, Long> nameMap = companyList.stream().collect(Collectors.toMap(Company::getName, Company::getId, (c1, c2) -> c1));
        ArrayList dataList = new ArrayList();
        nameMap.forEach((name, cid) -> this.invokeWithSdk((String)name, (Long)cid, dataList));
        this.batchInsert(dataList, nameMap);
        return dataList;
    }

    private Map<String, Long> getParam(ThreeTimeFetchLog fetchLog, String unifiedSocialCc) {
        int start;
        String businessName = this.businessName();
        Map<String, Long> retMap = new HashMap<String, Long>();
        int size = fetchLog.getDalyNum();
        int n = start = StrUtil.isBlank((CharSequence)unifiedSocialCc) ? (fetchLog.getCurrentIndex() - 1) * size : 0;
        if (Objects.equals(businessName, "investment_projects")) {
            List projectList = this.threeTimeDataService.listPage(unifiedSocialCc, Integer.valueOf(start), Integer.valueOf(size));
            if (CollUtil.isNotEmpty((Collection)projectList)) {
                retMap = projectList.stream().collect(Collectors.toMap(ThreeTimeData::getProjectCode, ThreeTimeData::getCid, (t1, t2) -> t1));
            }
        } else if (Objects.equals(businessName, "industry")) {
            List<Company> industryList = this.companyMapper.indexListPage(unifiedSocialCc, start, size);
            if (CollUtil.isNotEmpty(industryList)) {
                retMap = industryList.stream().collect(Collectors.toMap(Company::getUnifiedSocialCc, Company::getId, (c1, c2) -> c1));
            }
        } else if (Objects.equals(businessName, "marketEntities") && CharSequenceUtil.isNotBlank((CharSequence)unifiedSocialCc)) {
            retMap.put(unifiedSocialCc, null);
        } else if (Objects.equals(businessName, "data") && CharSequenceUtil.isNotBlank((CharSequence)unifiedSocialCc)) {
            retMap.put(unifiedSocialCc, null);
        } else {
            List<Company> companyList = this.companyMapper.listPage(unifiedSocialCc, start, size);
            if (CollUtil.isNotEmpty(companyList)) {
                retMap = companyList.stream().collect(Collectors.toMap(Company::getUnifiedSocialCc, Company::getId, (c1, c2) -> c1));
            }
        }
        return retMap;
    }

    public void invokeWithSdk(String key, Long cid, List<T> dataList) {
        boolean hasData;
        String retString;
        SecretData secretData;
        String businessName = this.businessName();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            throw new ServiceException((Throwable)e);
        }
        if (secretCache != null && System.currentTimeMillis() < secretCache.getRequestSecretEndTime()) {
            secretData = secretCache;
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[{}]::\u83b7\u53d6\u5230\u7f13\u5b58\u4e2d\u5bc6\u94a5\uff0c\u8fc7\u671f\u65f6\u95f4[{}]\u3002", (Object[])new Object[]{businessName, secretCache.getRequestSecretEndTime()});
        } else {
            secretData = this.refreshTokenByKeyWithSdk();
        }
        if (secretData == null) {
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[{}]::\u83b7\u53d6\u5bc6\u94a5\u51fa\u9519\u3002", (Object[])new Object[]{businessName});
            return;
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("X-SECURITY-CHECK-TYPE", this.xSecurityCheckType);
        headerMap.put("X-SECURITY-USER-ID", this.xSecurityUserId);
        headerMap.put("X-SECURITY-USER-IP", this.xSecurityUserIp);
        headerMap.put("X-SECURITY-SERVICE-ID", X_SECURITY_SERVICE_ID);
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        if (CharSequenceUtil.isNotBlank((CharSequence)businessName)) {
            String irsKey;
            switch (businessName) {
                case "marketEntities": {
                    irsKey = "identificationId";
                    break;
                }
                case "data": {
                    irsKey = "requestparam";
                    headerMap.put("type", "U");
                    bodyMap.put("type", "U");
                    break;
                }
                case "companyBaseInfo": {
                    irsKey = "NSRSBH";
                    break;
                }
                case "industry": {
                    irsKey = "qymc";
                    break;
                }
                case "investment_projects": {
                    irsKey = "requestparam";
                    break;
                }
                case "superviseCompanyBaseInfo": {
                    irsKey = "uniScid";
                    break;
                }
                case "acceptance_opinions": 
                case "design_approval": {
                    irsKey = "unScid";
                    break;
                }
                default: {
                    irsKey = "";
                }
            }
            headerMap.put(irsKey, key);
            bodyMap.put(irsKey, key);
        }
        GatewayRequest request = GatewayRequest.builder().resourceCode(this.resourceCode()).requestSecret(secretData.getRequestSecret()).contentType("json").method("POST").headers(headerMap).body(bodyMap).build();
        int count = this.callIrsDataCount.incrementAndGet();
        DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[{}]::\u5f00\u59cb\u7b2c{}\u6b21\u8c03\u7528\u6570\u636e\u3002", (Object[])new Object[]{businessName, count});
        GatewayResult ret = this.openServiceClient.callGatewayService(request, (TypeRef)new TypeRef<GatewayResult<Object>>(){});
        DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[{}]::\u8bf7\u6c42\u7b2c\u4e00\u54cd\u5e94\u7ed3\u679c\u6253\u5370::{}", (Object[])new Object[]{businessName, ret});
        try {
            retString = this.objectMapper.writeValueAsString((Object)ret);
        }
        catch (Exception e) {
            String exceptionMsg = String.format("\u7a0b\u5e8f\u5f02\u5e38::IRS[%s]::\u7ed3\u679c\u89e3\u6790\u5931\u8d25::%s", businessName, e);
            throw new ServiceException(exceptionMsg);
        }
        JSONObject retJson = JSONArray.parseObject((String)retString);
        if (retJson == null) {
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[{}]::\u7ed3\u679c\u4e3a\u7a7a::{}", (Object[])new Object[]{businessName, retString});
            return;
        }
        String code = retJson.getString("code");
        if (!"00".equalsIgnoreCase(code)) {
            if ("11".equalsIgnoreCase(code)) {
                DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[{}]::Token\u5df2\u8fc7\u671f/\u8fc7\u671f\u65f6\u95f4[{}]::\u672c\u5730\u65f6\u95f4[{}]::\u5373\u5c06\u91cd\u65b0\u5237\u65b0\u5bc6\u94a5", (Object[])new Object[]{businessName, DateUtil.getDateStringByMil((long)secretData.getRequestSecretEndTime()), DateUtil.getDateStringByMil((long)System.currentTimeMillis())});
                this.refreshTokenByKeyWithSdk();
            }
            if ("14".equalsIgnoreCase(code)) {
                DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[{}]::\u7b7e\u540d\u9519\u8bef\uff0csign\u503c\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{businessName});
            }
            if (cid == null) {
                DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[{}]::\u6570\u636e\u8bf7\u6c42\u51fa\u9519/\u72b6\u6001\u7801[{}]::projectCode[{}]::\u7ed3\u679c\u503c[{}]", (Object[])new Object[]{businessName, code, key, retJson});
            } else {
                DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[{}]::\u6570\u636e\u8bf7\u6c42\u51fa\u9519/\u72b6\u6001\u7801[{}]::\u4f01\u4e1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801[{}]::cid[{}]::\u7ed3\u679c\u503c[{}]", (Object[])new Object[]{businessName, code, key, cid, retJson});
            }
            return;
        }
        String datasString = retJson.getString("datas");
        boolean bl = hasData = CharSequenceUtil.isNotBlank((CharSequence)datasString) && !"[]".equalsIgnoreCase(datasString);
        if (hasData) {
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[{}]::\u8bf7\u6c42\u6210\u529f/\u54cd\u5e94\u7ed3\u679c[{}]", (Object[])new Object[]{businessName, retJson});
        } else {
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[{}]::\u8bf7\u6c42\u6210\u529f/\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a[{}]", (Object[])new Object[]{businessName, retJson});
        }
        this.parseData(datasString, dataList, cid);
    }

    public SecretData refreshTokenByKeyWithSdk() {
        String secretString;
        String businessName = this.businessName();
        int count = this.refreshTokenCount.incrementAndGet();
        DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[{}]::\u5f00\u59cb\u7b2c{}\u6b21\u5237\u65b0\u5bc6\u94a5\u3002", (Object[])new Object[]{businessName, count});
        GatewayResult secret = this.openServiceClient.refreshSecretByKey(this.appSecret);
        try {
            secretString = this.objectMapper.writeValueAsString((Object)secret);
        }
        catch (Exception e) {
            String exceptionMsg = String.format("\u7a0b\u5e8f\u5f02\u5e38::IRS[%s]::\u5bc6\u94a5\u89e3\u6790\u5931\u8d25::%s", businessName, e);
            throw new ServiceException(exceptionMsg);
        }
        JSONObject secretJson = JSONObject.parseObject((String)secretString);
        if (secretJson == null) {
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[{}]::SDK\u65b9\u5f0f\u6839\u636eappSecret\u5237\u65b0\u5bc6\u94a5::\u5bc6\u94a5\u7ed3\u679c\u4e3a\u7a7a::{}", (Object[])new Object[]{businessName, secretString});
            return null;
        }
        if (!"00".equalsIgnoreCase(secretJson.getString("code"))) {
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[{}]::SDK\u65b9\u5f0f\u6839\u636eappSecret\u5237\u65b0\u5bc6\u94a5::\u8bf7\u6c42\u51fa\u9519(code!=00)::{}", (Object[])new Object[]{businessName, secretString});
            return null;
        }
        SecretData secretData = null;
        String datasString = secretJson.getString("datas");
        if (CharSequenceUtil.isNotBlank((CharSequence)datasString)) {
            secretData = (SecretData)JSONUtil.toBean((String)datasString, SecretData.class);
        }
        if (secretData != null) {
            secretData.setCacheTime(LocalDateTime.now());
            secretData.setRequestSecretEndTime(Long.valueOf(System.currentTimeMillis() + 600000L));
            secretCache = secretData;
        }
        return secretData;
    }
}

