/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.threeTime.service.impl;

import cn.smarthse.services.threeTime.service.impl.ThreeTimeBaseServiceImpl;
import cn.smarthse.services.wanda.api.entity.IrsCompanyBaseInfo;
import cn.smarthse.services.wanda.api.service.IIrsCompanyBaseInfoService;
import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IsrCompanyBaseInfoFetchDataServiceImpl
extends ThreeTimeBaseServiceImpl<IrsCompanyBaseInfo> {
    @DubboReference
    private IIrsCompanyBaseInfoService irsCompanyBaseInfoService;

    @Override
    public String businessName() {
        return "companyBaseInfo";
    }

    @Override
    public String resourceCode() {
        return "QGBaseInfo";
    }

    @Override
    public String url(Long time, String sign, String appKey, String param, String type) {
        return "https://interface.zjzwfw.gov.cn/gateway/api/001003050/dataSharing/qGBaseInfo.htm?requestTime=" + time + "&sign=" + sign + "&appKey=" + appKey + "&NSRSBH=" + param;
    }

    @Override
    public int removeData(List<Long> cids) {
        return this.irsCompanyBaseInfoService.removeData(cids);
    }

    @Override
    @Transactional
    public int batchInsert(List<IrsCompanyBaseInfo> dataList, Map<String, Long> paramMap) {
        dataList.forEach(irsCompanyBaseInfo -> {
            irsCompanyBaseInfo.setIsValid(Boolean.valueOf(true));
            irsCompanyBaseInfo.setCreateDate(new Date());
            irsCompanyBaseInfo.setUpdateDate(new Date());
            irsCompanyBaseInfo.setUpdateBy(Long.valueOf(0L));
            irsCompanyBaseInfo.setCreateBy(Long.valueOf(0L));
        });
        List<Long> cidList = dataList.stream().map(IrsCompanyBaseInfo::getCid).distinct().collect(Collectors.toList());
        this.removeData(cidList);
        return this.irsCompanyBaseInfoService.batchInsert(dataList);
    }

    @Override
    public void parseData(String jsonString, List<IrsCompanyBaseInfo> dataList, Long cid) {
        List list = JSONArray.parseArray((String)jsonString, IrsCompanyBaseInfo.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(item -> item.setCid(cid));
            dataList.addAll(list);
        }
    }
}

