/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.threeTime.service.impl;

import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.services.threeTime.mapper.IrsCompanyBaseInfoMapper;
import cn.smarthse.services.wanda.api.entity.IrsCompanyBaseInfo;
import cn.smarthse.services.wanda.api.entity.IrsCompanyChangeInfo;
import cn.smarthse.services.wanda.api.service.IIrsCompanyBaseInfoService;
import cn.smarthse.services.wanda.api.service.IrsCompanyChangeInfoService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
@Transactional(readOnly=true)
public class IrsCompanyBaseInfoServiceImpl
extends ServiceImpl<IrsCompanyBaseInfoMapper, IrsCompanyBaseInfo>
implements IIrsCompanyBaseInfoService {
    @Autowired
    private IrsCompanyChangeInfoService irsCompanyChangeInfoService;
    @Autowired
    DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    TransactionDefinition transactionDefinition;

    @Transactional(readOnly=false)
    public int removeData(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return 0;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(IrsCompanyBaseInfo::getCid, cids);
        this.remove((Wrapper)wrapper);
        return cids.size();
    }

    @Transactional(readOnly=false)
    public int batchInsert(List<IrsCompanyBaseInfo> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return 0;
        }
        this.saveBatch(dataList);
        return dataList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    public void syncCheckCompanyInfo(Long cid) {
        int pageSize = 1000;
        int pageNum = 0;
        ArrayList<IrsCompanyChangeInfo> changeLogList = new ArrayList<IrsCompanyChangeInfo>();
        List<IrsCompanyBaseInfo> unCheckList = this.unCheckList(cid, pageSize, pageNum);
        while (CollectionUtils.isNotEmpty(unCheckList)) {
            boolean changeFlag = true;
            TransactionStatus status = this.dataSourceTransactionManager.getTransaction(this.transactionDefinition);
            try {
                List<Long> cids = unCheckList.stream().map(IrsCompanyBaseInfo::getCid).collect(Collectors.toList());
                List<Company> companies = ((IrsCompanyBaseInfoMapper)this.baseMapper).listInfo(cids);
                ArrayList<Company> companyList = new ArrayList<Company>();
                for (Company company : companies) {
                    this.verifyData(unCheckList, changeLogList, companyList, company);
                }
                this.updateCheckStatus(unCheckList, (byte)1);
                ((IrsCompanyBaseInfoMapper)this.baseMapper).updateCompanyInfo(companyList);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.updateCheckStatus(unCheckList, (byte)2);
                changeFlag = false;
            }
            finally {
                if (changeFlag) {
                    this.irsCompanyChangeInfoService.saveBatch(changeLogList);
                }
                unCheckList = this.unCheckList(cid, pageSize, pageNum);
                this.dataSourceTransactionManager.commit(status);
            }
        }
    }

    private void verifyData(List<IrsCompanyBaseInfo> unCheckList, List<IrsCompanyChangeInfo> changeLogList, List<Company> companyList, Company company) {
        IrsCompanyBaseInfo info = this.getById(company.getId(), unCheckList);
        IrsCompanyChangeInfo changeInfo = new IrsCompanyChangeInfo();
        boolean flag = false;
        if (!company.getLegalName().equalsIgnoreCase(info.getFddbrxm())) {
            changeInfo.setBeforeFr(company.getLegalName());
            changeInfo.setAfterFr(info.getFddbrxm());
            company.setLegalName(info.getFddbrxm());
            flag = true;
        }
        if (!company.getRegisterAddress().equalsIgnoreCase(info.getZcdz())) {
            changeInfo.setBeforeAddress(company.getRegisterAddress());
            changeInfo.setAfterAddress(info.getZcdz());
            company.setRegisterAddress(info.getZcdz());
            flag = true;
        }
        if (flag) {
            changeInfo.setCid(company.getId());
            changeInfo.setCompanyName(company.getName());
            changeLogList.add(changeInfo);
            companyList.add(company);
        }
    }

    private IrsCompanyBaseInfo getById(Long id, List<IrsCompanyBaseInfo> list) {
        IrsCompanyBaseInfo info = new IrsCompanyBaseInfo();
        for (IrsCompanyBaseInfo irsCompanyBaseInfo : list) {
            if (!irsCompanyBaseInfo.getCid().equals(id)) continue;
            info = irsCompanyBaseInfo;
            break;
        }
        return info;
    }

    public List<IrsCompanyBaseInfo> unCheckList(Long cid, int pageSize, int pageNum) {
        return ((IrsCompanyBaseInfoMapper)this.baseMapper).unCheckList(cid, pageSize, pageNum);
    }

    @Transactional(readOnly=false)
    public void updateCheckStatus(List<IrsCompanyBaseInfo> list, Byte status) {
        list.forEach(item -> {
            item.setIsChecked(status);
            item.setUpdateDate(new Date());
        });
        this.saveOrUpdateBatch(list);
    }
}

