/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.threeTime.controller;

import cn.smarthse.services.threeTime.service.impl.IsrCompanyBaseInfoFetchDataServiceImpl;
import cn.smarthse.services.threeTime.service.impl.SuperviseCompanyBaseInfoFetchServiceImpl;
import cn.smarthse.services.threeTime.service.impl.ThreeTimeAcceptanceOpinionsFetchDataServiceImpl;
import cn.smarthse.services.threeTime.service.impl.ThreeTimeDataFetchDataServiceImpl;
import cn.smarthse.services.threeTime.service.impl.ThreeTimeInvestmentProjectsFetchDataServiceImpl;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"threeTime"})
public class ThreeTimesDataController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreeTimesDataController.class);
    @Autowired
    ThreeTimeDataFetchDataServiceImpl threeTimeDataFetchDataService;
    @Autowired
    ThreeTimeAcceptanceOpinionsFetchDataServiceImpl threeTimeAcceptanceOpinionsFetchDataService;
    @Autowired
    ThreeTimeInvestmentProjectsFetchDataServiceImpl threeTimeInvestmentProjectsFetchDataService;
    @Autowired
    SuperviseCompanyBaseInfoFetchServiceImpl superviseCompanyBaseInfoFetchService;
    @Autowired
    private IsrCompanyBaseInfoFetchDataServiceImpl isrCompanyBaseInfoFetchDataService;

    @GetMapping(value={"/data/fetchData/{unifiedCreditCode}"})
    public String fetchData(@PathVariable String unifiedCreditCode) {
        this.threeTimeDataFetchDataService.fetchData(unifiedCreditCode);
        return "success";
    }

    @GetMapping(value={"/acceptance/fetchData/{unifiedCreditCode}"})
    public String acceptanceOpinions(@PathVariable String unifiedCreditCode) {
        this.threeTimeAcceptanceOpinionsFetchDataService.fetchData(unifiedCreditCode);
        return "success";
    }

    @GetMapping(value={"/investment/fetchData/{projectCode}"})
    public String investmentProjects(@PathVariable String projectCode) {
        this.threeTimeInvestmentProjectsFetchDataService.fetchData(projectCode);
        return "success";
    }

    @GetMapping(value={"/supervise/fetchData/{unifiedCreditCode}"})
    public String fetchSuperviseData(@PathVariable String unifiedCreditCode) {
        this.superviseCompanyBaseInfoFetchService.fetchData(unifiedCreditCode);
        return "success";
    }

    @GetMapping(value={"/company/fetchData/{unifiedCreditCode}"})
    public String fetchCompanyBaseInfo(@PathVariable String unifiedCreditCode) {
        this.isrCompanyBaseInfoFetchDataService.fetchData(unifiedCreditCode);
        return "success";
    }
}

