/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.irs.task;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.services.irs.service.impl.IrsMarketEntitiesFetchDataServiceImpl;
import cn.smarthse.services.irs.service.impl.IsrIndustryFetchDataServiceImpl;
import cn.smarthse.services.wanda.api.service.irs.IIrsMarketEntitiesService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IndustryScheduleTask {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IsrIndustryFetchDataServiceImpl isrIndustryFetchDataService;
    @Resource
    private IrsMarketEntitiesFetchDataServiceImpl marketEntitiesFetchDataService;
    @Resource
    private IIrsMarketEntitiesService irsMarketEntitiesService;

    @XxlJob(value="IndustryScheduleTask-task1")
    public void task1() {
        String unifiedSocialCc = this.getXXJobUnifiedSocialCc();
        long start = System.currentTimeMillis();
        this.logger.info("---------------------IRS\u884c\u4e1a\u4fe1\u606f\u6570\u636e\u83b7\u53d6\u5f00\u59cb-------------------------------------");
        this.isrIndustryFetchDataService.fetchData(unifiedSocialCc);
        long end = System.currentTimeMillis();
        this.logger.info("---------------------IRS\u884c\u4e1a\u4fe1\u606f\u6570\u636e\u83b7\u53d6\u7ed3\u675f\uff0c\u7528\u65f6\uff1a{}s-------------------------------------", (Object)((end - start) / 1000L));
    }

    @XxlJob(value="irsTask-marketEntities")
    public void task2() {
        String unifiedSocialCc = this.getXXJobUnifiedSocialCc();
        long start = System.currentTimeMillis();
        this.logger.info("---------------------IRS\u5e02\u573a\u4e3b\u4f53\u6570\u636e\u83b7\u53d6\u5f00\u59cb-------------------------------------");
        this.marketEntitiesFetchDataService.fetchData(unifiedSocialCc);
        long end = System.currentTimeMillis();
        this.logger.info("---------------------IRS\u5e02\u573a\u4e3b\u4f53\u6570\u636e\u83b7\u53d6\u7ed3\u675f\uff0c\u7528\u65f6\uff1a{}s-------------------------------------", (Object)((end - start) / 1000L));
        this.irsMarketEntitiesService.updateCompanyBusinessState(unifiedSocialCc);
    }

    @XxlJob(value="irsTask-updateCompanyBusinessStateTest")
    public void updateCompanyBusinessStateTest() {
        String unifiedSocialCc = this.getXXJobUnifiedSocialCc();
        this.irsMarketEntitiesService.updateCompanyBusinessState(unifiedSocialCc);
    }

    private String getXXJobUnifiedSocialCc() {
        JSONObject jsonObj;
        String unifiedSocialCc = null;
        String jobParam = XxlJobHelper.getJobParam();
        if (StringUtils.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null) {
            unifiedSocialCc = jsonObj.getString("unifiedSocialCc");
        }
        return unifiedSocialCc;
    }
}

