/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.irs.service.impl;

import cn.smarthse.services.threeTime.service.impl.ThreeTimeBaseServiceImpl;
import cn.smarthse.services.wanda.api.entity.irs.IrsIndustry;
import cn.smarthse.services.wanda.api.entity.irs.IrsIndustryModel;
import cn.smarthse.services.wanda.api.service.irs.IIrsIndustryService;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class IsrIndustryFetchDataServiceImpl
extends ThreeTimeBaseServiceImpl<IrsIndustry> {
    @Resource
    private IIrsIndustryService industryService;

    @Override
    public String businessName() {
        return "industry";
    }

    @Override
    public String resourceCode() {
        return "";
    }

    @Override
    public String url(Long time, String sign, String appKey, String param, String type) {
        return "https://interface.zjzwfw.gov.cn/gateway/api/001003029/dataSharing/7mTgm60Yd9gg4ff5.htm?requestTime=" + time + "&sign=" + sign + "&appKey=" + appKey + "&qymc=" + param;
    }

    @Override
    public int removeData(List<Long> cids) {
        return this.industryService.removeData(cids);
    }

    @Override
    public int batchInsert(List<IrsIndustry> dataList, Map<String, Long> paramMap) {
        dataList.forEach(irsCompanyBaseInfo -> {
            irsCompanyBaseInfo.setIsValid(Boolean.valueOf(true));
            irsCompanyBaseInfo.setCreateDate(new Date());
            irsCompanyBaseInfo.setUpdateDate(new Date());
            irsCompanyBaseInfo.setUpdateBy(Long.valueOf(0L));
            irsCompanyBaseInfo.setCreateBy(Long.valueOf(0L));
        });
        boolean b = this.industryService.saveBatch(dataList);
        return dataList.size();
    }

    @Override
    public void parseData(String jsonString, List<IrsIndustry> dataList, Long cid) {
        List list = JSONArray.parseArray((String)jsonString, IrsIndustryModel.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List collect = list.stream().map(i -> {
                IrsIndustry irsIndustry = new IrsIndustry();
                BeanUtils.copyProperties((Object)i, (Object)irsIndustry);
                irsIndustry.setCid(cid);
                irsIndustry.setId(Long.valueOf(IdWorker.getId()));
                irsIndustry.setSourceId(i.getId());
                return irsIndustry;
            }).collect(Collectors.toList());
            dataList.addAll(collect);
        }
    }
}

