/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.irs.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.health.supervise.entity.companyChange.CompanyChangeInfoDetail;
import cn.smarthse.services.irs.mapper.IrsMarketEntitiesMapper;
import cn.smarthse.services.irs.service.impl.IrsMarketEntitiesFetchDataServiceImpl;
import cn.smarthse.services.wanda.api.entity.irs.IrsMarketEntities;
import cn.smarthse.services.wanda.api.service.irs.IIrsMarketEntitiesService;
import cn.smarthse.services.wanda.pushdata.hse.dao.WandaCompanyMapper;
import com.alibaba.dubbo.rpc.RpcContext;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="irsMarketEntitiesService")
@DubboService
public class IrsMarketEntitiesServiceImpl
extends ServiceImpl<IrsMarketEntitiesMapper, IrsMarketEntities>
implements IIrsMarketEntitiesService {
    @Autowired
    @Lazy
    private IrsMarketEntitiesFetchDataServiceImpl irsMarketEntitiesFetchDataService;
    @Autowired
    private ISysUserService sysUserService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideService;
    @Autowired
    private WandaCompanyMapper companyMapper;

    public List<IrsMarketEntities> queryIrsMarketEntitiesByUnifiedSocialCc4irs(String unifiedSocialCc) {
        if (StrUtil.isBlank((CharSequence)unifiedSocialCc)) {
            return Collections.emptyList();
        }
        return this.irsMarketEntitiesFetchDataService.fetchData(unifiedSocialCc);
    }

    public List<IrsMarketEntities> queryIrsMarketEntitiesByUnifiedSocialCc(String unifiedSocialCc) {
        List<IrsMarketEntities> dbList = ((IrsMarketEntitiesMapper)this.baseMapper).queryListByUnifiedSocialCc(unifiedSocialCc);
        if (CollectionUtils.isNotEmpty(dbList)) {
            return dbList;
        }
        return this.queryIrsMarketEntitiesByUnifiedSocialCc4irs(unifiedSocialCc);
    }

    public void insertListTemp(List<IrsMarketEntities> dataList) {
        ((IrsMarketEntitiesMapper)this.baseMapper).insertListTemp(dataList);
    }

    public void insertList(List<IrsMarketEntities> dataList) {
        ((IrsMarketEntitiesMapper)this.baseMapper).insertList(dataList);
    }

    public void removeByUnifiedSocialCcList(List<String> unifiedSocialCcList) {
        ((IrsMarketEntitiesMapper)this.baseMapper).removeByUnifiedSocialCcList(unifiedSocialCcList);
    }

    @Transactional
    public void updateCompanyBusinessState(String unifiedSocialCc) {
        byte closeState = 0;
        List<Object> list = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)unifiedSocialCc) && unifiedSocialCc.contains("\u540c\u6b65IRS\u6307\u5b9a\u4f01\u4e1a\u4fe1\u606f")) {
            List<Company> companyList = this.companyMapper.getSpecificCompanyList(unifiedSocialCc);
            if (CollUtil.isNotEmpty(companyList)) {
                List<String> uccList = companyList.stream().map(Company::getUnifiedSocialCc).toList();
                list = ((IrsMarketEntitiesMapper)this.baseMapper).queryUpdateCompanyBusinessStateList(null, uccList);
            }
        } else {
            list = ((IrsMarketEntitiesMapper)this.baseMapper).queryUpdateCompanyBusinessStateList(unifiedSocialCc, null);
        }
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<CompanySuperviseModel> modelList = list.stream().map(i -> {
            CompanySuperviseModel companySuperviseModel = new CompanySuperviseModel();
            companySuperviseModel.setBusinessState(Byte.valueOf(closeState));
            companySuperviseModel.setIrsBusinessState(Byte.valueOf(closeState));
            companySuperviseModel.setBusinessUpdateTime(new Date());
            companySuperviseModel.setCid(i.getCid());
            return companySuperviseModel;
        }).collect(Collectors.toList());
        this.autoConfirmOfDeleteChangeForIrsOutCompany(modelList);
        this.removeCardIfHasClueAndDisableAccount(modelList);
        RpcContext.getContext().setAttachment("irs_lead_to_change_business_state", "true");
        this.companyProvideService.updateCompanySuperviseByCidList(modelList, Long.valueOf(0L));
        RpcContext.getContext().setAttachment("irs_lead_to_change_business_state", "false");
    }

    public List<IrsMarketEntities> getIrsCompanyInfoByUccList(List<String> uccList) {
        if (CollUtil.isEmpty(uccList)) {
            return Collections.emptyList();
        }
        return ((IrsMarketEntitiesMapper)this.baseMapper).getIrsCompanyInfoByUccList(uccList);
    }

    public void initCompanyLngLat(Long cid) {
        if (cid == null) {
            return;
        }
        ((IrsMarketEntitiesMapper)this.baseMapper).initCompanyLngLat(cid);
    }

    public Date getLastCompanyLngLatChangeInfo(Long cid) {
        if (cid == null) {
            return null;
        }
        return ((IrsMarketEntitiesMapper)this.baseMapper).getLastCompanyLngLatChangeInfo(cid);
    }

    public void updateLngLat(Long cid, String lng, String lat) {
        if (cid == null || StrUtil.isBlank((CharSequence)lng) || StrUtil.isBlank((CharSequence)lat)) {
            return;
        }
        ((IrsMarketEntitiesMapper)this.baseMapper).updateLngLat(cid, lng, lat);
    }

    public void updateCompanyLngLat(Long cid, String lng, String lat) {
        if (cid == null || StrUtil.isBlank((CharSequence)lng) || StrUtil.isBlank((CharSequence)lat)) {
            return;
        }
        ((IrsMarketEntitiesMapper)this.baseMapper).updateCompanyLngLat(cid, lng, lat);
    }

    public List<String> getIrsCloseCompanyUccList(List<String> uccList) {
        if (CollUtil.isEmpty(uccList)) {
            return Collections.emptyList();
        }
        return ((IrsMarketEntitiesMapper)this.baseMapper).getIrsCloseCompanyUccList(uccList);
    }

    public List<IrsMarketEntities> listOldRegstate(ArrayList<String> unifiedSocialCcList) {
        return ((IrsMarketEntitiesMapper)this.baseMapper).listOldRegstate(unifiedSocialCcList);
    }

    private void autoConfirmOfDeleteChangeForIrsOutCompany(List<CompanySuperviseModel> companyList) {
        List<CompanyChangeInfoDetail> detailList;
        List<Long> cidList;
        if (CollUtil.isNotEmpty(companyList) && CollUtil.isNotEmpty(cidList = companyList.stream().map(CompanyBaseInfoModel::getCid).collect(Collectors.toList())) && CollUtil.isNotEmpty(detailList = ((IrsMarketEntitiesMapper)this.baseMapper).getDetailListByCidList(cidList))) {
            List<Long> detailIdList = detailList.stream().map(CompanyChangeInfoDetail::getId).collect(Collectors.toList());
            ((IrsMarketEntitiesMapper)this.baseMapper).autoConfirmDetailStatusByIdList(detailIdList);
            List<Long> changeIdList = detailList.stream().map(CompanyChangeInfoDetail::getChangeInfoId).collect(Collectors.toList());
            List<Long> needToCompleteChangIdList = ((IrsMarketEntitiesMapper)this.baseMapper).getNeedToCompleteChangIdList(changeIdList);
            if (CollUtil.isNotEmpty(needToCompleteChangIdList)) {
                ((IrsMarketEntitiesMapper)this.baseMapper).autoConfirmChangeStatusByIdList(needToCompleteChangIdList);
            }
        }
    }

    private void removeCardIfHasClueAndDisableAccount(List<CompanySuperviseModel> companyList) {
        List<Long> cidList;
        if (CollUtil.isNotEmpty(companyList) && CollUtil.isNotEmpty(cidList = companyList.stream().map(CompanyBaseInfoModel::getCid).collect(Collectors.toList()))) {
            ((IrsMarketEntitiesMapper)this.baseMapper).removeChangeEnterprise(cidList, StopTypeEnums.CLOSE.getCode());
            this.sysUserService.disableOrEnableUserByCidList(cidList, Integer.valueOf(1), Long.valueOf(1L));
        }
    }
}

