/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.irs.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.services.threeTime.service.impl.ThreeTimeBaseServiceImpl;
import cn.smarthse.services.wanda.api.entity.irs.IrsMarketEntities;
import cn.smarthse.services.wanda.api.entity.irs.IrsRegstateLog;
import cn.smarthse.services.wanda.api.service.irs.IIrsMarketEntitiesService;
import cn.smarthse.services.wanda.api.service.irs.IIrsRegstateLogService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IrsMarketEntitiesFetchDataServiceImpl
extends ThreeTimeBaseServiceImpl<IrsMarketEntities> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IrsMarketEntitiesFetchDataServiceImpl.class);
    private final IIrsMarketEntitiesService irsMarketEntitiesService;
    private final IIrsRegstateLogService iIrsRegstateLogService;
    private static final String baseUrl = "https://interface.zjzwfw.gov.cn/gateway/api/001003033/dataSharing/generalEnterpriseBasicInfo.htm";

    @Override
    public String businessName() {
        return "marketEntities";
    }

    @Override
    public String resourceCode() {
        return "GeneralEnterpriseBasicInfo";
    }

    @Override
    public String url(Long time, String sign, String appKey, String param, String type) {
        return "https://interface.zjzwfw.gov.cn/gateway/api/001003033/dataSharing/generalEnterpriseBasicInfo.htm?requestTime=" + time + "&sign=" + sign + "&appKey=" + appKey + "&identificationId=" + param;
    }

    @Override
    @Transactional
    public int batchInsert(List<IrsMarketEntities> dataList, Map<String, Long> paramMap) {
        if (CollectionUtils.isEmpty(dataList)) {
            return 0;
        }
        Long temp = paramMap.get("\u4e34\u65f6\u5904\u7406");
        if (temp != null && Objects.equals(temp, 1L)) {
            this.irsMarketEntitiesService.insertListTemp(dataList);
            return dataList.size();
        }
        List oldList = this.irsMarketEntitiesService.listOldRegstate(new ArrayList<String>(paramMap.keySet()));
        this.removeDataByUnifiedSocialCc(new ArrayList<String>(paramMap.keySet()));
        this.irsMarketEntitiesService.insertList(dataList);
        this.generateRegstateLogs(oldList, dataList);
        return dataList.size();
    }

    @Override
    public void parseData(String jsonString, List<IrsMarketEntities> dataList, Long cid) {
        this.updateCompanyLngLat(jsonString, cid);
        List list = JSONArray.parseArray((String)jsonString, IrsMarketEntities.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(i -> {
                i.setId(Long.valueOf(IdWorker.getId()));
                i.setSyncTime(new Date());
            });
            dataList.addAll(list);
        }
    }

    @Override
    @Transactional
    public int removeDataByUnifiedSocialCc(List<String> unifiedSocialCcList) {
        this.irsMarketEntitiesService.removeByUnifiedSocialCcList(unifiedSocialCcList);
        return 0;
    }

    private void updateCompanyLngLat(String jsonString, Long cid) {
        try {
            boolean isNeedUpdateLngLat;
            this.irsMarketEntitiesService.initCompanyLngLat(cid);
            Date maxCreateDate = this.irsMarketEntitiesService.getLastCompanyLngLatChangeInfo(cid);
            boolean bl = isNeedUpdateLngLat = maxCreateDate == null || DateUtils.addYear((Date)maxCreateDate, (int)1).before(new Date());
            if (isNeedUpdateLngLat) {
                JSONArray array = JSONArray.parseArray((String)jsonString);
                JSONObject obj = (JSONObject)array.get(0);
                log.debug("\u7ecf\u7eac\u5ea6\u4fe1\u606f\u67e5\u8be2\uff1aresult: {}", (Object)obj);
                String lng = obj.getString("longitude");
                String lat = obj.getString("latitude");
                if (StrUtil.isNotBlank((CharSequence)lng) && StrUtil.isNotBlank((CharSequence)lat)) {
                    this.irsMarketEntitiesService.updateLngLat(cid, lng, lat);
                    this.irsMarketEntitiesService.updateCompanyLngLat(cid, lng, lat);
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ecf\u7eac\u5ea6\u4fe1\u606f\u67e5\u8be2\uff0c\u51fa\u9519\uff0ccid\uff1a{} - result:{}", (Object)cid, (Object)jsonString);
        }
    }

    private void generateRegstateLogs(List<IrsMarketEntities> oldList, List<IrsMarketEntities> dataList) {
        Map oldMap = oldList.stream().collect(Collectors.toMap(IrsMarketEntities::getUniscid, Function.identity(), (existing, replacement) -> existing));
        ArrayList<IrsRegstateLog> logList = new ArrayList<IrsRegstateLog>();
        Date now = new Date();
        for (IrsMarketEntities dataItem : dataList) {
            IrsRegstateLog log;
            IrsMarketEntities oldItem = (IrsMarketEntities)oldMap.get(dataItem.getUniscid());
            if (oldItem != null && !oldItem.getRegstate().equals(dataItem.getRegstate())) {
                log = new IrsRegstateLog();
                log.setId(Long.valueOf(IdWorker.getId()));
                log.setUniscid(dataItem.getUniscid());
                log.setBeforeRegstate(oldItem.getRegstate());
                log.setAfterRegstate(dataItem.getRegstate());
                log.setCreateTime(now);
                logList.add(log);
            }
            if (oldItem != null) continue;
            log = new IrsRegstateLog();
            log.setId(Long.valueOf(IdWorker.getId()));
            log.setUniscid(dataItem.getUniscid());
            log.setBeforeRegstate("--");
            log.setAfterRegstate(dataItem.getRegstate());
            log.setCreateTime(now);
            logList.add(log);
        }
        if (!logList.isEmpty()) {
            try {
                this.iIrsRegstateLogService.batchInsert(logList);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u4fdd\u5b58 IRS \u72b6\u6001\u53d8\u66f4\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Generated
    public IrsMarketEntitiesFetchDataServiceImpl(IIrsMarketEntitiesService irsMarketEntitiesService, IIrsRegstateLogService iIrsRegstateLogService) {
        this.irsMarketEntitiesService = irsMarketEntitiesService;
        this.iIrsRegstateLogService = iIrsRegstateLogService;
    }
}

