/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.irs.fiveLevelOrg.service.impl;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.services.irs.fiveLevelOrg.HmacAuthUtil;
import cn.smarthse.services.irs.fiveLevelOrg.mapper.IrsVillageHistoryMapper;
import cn.smarthse.services.irs.fiveLevelOrg.service.impl.Result;
import cn.smarthse.services.wanda.api.entity.irs.fileLevelOrg.IrsVillageHistory;
import cn.smarthse.services.wanda.api.service.irs.fiveLevelOrg.IrsVillageHistoryService;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="irsVillageHistoryService")
@DubboService
public class IrsVillageHistoryServiceImpl
extends ServiceImpl<IrsVillageHistoryMapper, IrsVillageHistory>
implements IrsVillageHistoryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IrsVillageHistoryServiceImpl.class);
    private static final String url = "https://bcdsg.zj.gov.cn:8443/restapi/prod/IC33000020220408000005/api/v1/getVillageHis";

    @Transactional(readOnly=false)
    public int fetchInsertData(String code, String orgName) {
        long start = System.currentTimeMillis();
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)code)) {
            params.put("code", code);
        }
        if (StringUtils.isNotEmpty((String)orgName)) {
            params.put("orgName", code);
        }
        String res = null;
        try {
            res = HmacAuthUtil.doGetWithHeaders(url, params);
        }
        catch (IOException e) {
            log.error("\u8c03\u7528irs\uff1a{}\u63a5\u53e3\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)url, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        Result result = (Result)JSON.parseObject((String)res, Result.class);
        if (!result.getResult().booleanValue()) {
            log.error("\u8c03\u7528irs\uff1a{}\u63a5\u53e3\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)url, (Object)result.getMsg());
            return 0;
        }
        List irsFiveLevelOrgs = Collections.emptyList();
        try {
            List<Object> data = result.getDatas();
            String jsonString = JSON.toJSONString(data);
            irsFiveLevelOrgs = JSON.parseArray((String)jsonString, IrsVillageHistory.class);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790json\u5931\u8d25\uff0cjson:{},\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)res, (Object)e.getMessage());
        }
        if (CollectionUtils.isNotEmpty((Collection)irsFiveLevelOrgs)) {
            this.saveBatch(irsFiveLevelOrgs);
        }
        log.info("\u63a5\u53e3\u8c03\u7528\u6210\u529f,\u63d2\u5165\u6570\u636e{}\u6761,\u8017\u65f6\uff1a{}m", (Object)irsFiveLevelOrgs.size(), (Object)((System.currentTimeMillis() - start) / 1000L));
        return irsFiveLevelOrgs.size();
    }
}

