/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.irs.fiveLevelOrg;

import cn.hutool.core.lang.Pair;
import jakarta.xml.bind.DatatypeConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmacAuthUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HmacAuthUtil.class);
    private static final String ACCESS_KEY = "BCDSGA_0182c9815fd95734f109ef644f8d435a";
    private static final String SECRET_KEY = "BCDSGS_ea66855fb5f9d4356fc617fd3d75e053";

    public static String doGetWithHeaders(String url, Map<String, String> params) throws IOException {
        String inputLine;
        Object finalUrl = url;
        if (MapUtils.isNotEmpty(params)) {
            StringBuffer sb = new StringBuffer();
            for (String key : params.keySet()) {
                sb.append("&").append(key).append("=").append(URLEncoder.encode(params.get(key)));
            }
            finalUrl = url + sb.toString().replaceFirst("&", "?");
        }
        log.info("\u8bf7\u6c42\u7684url:{}", finalUrl);
        URL obj = new URL((String)finalUrl);
        Map<String, String> headers = HmacAuthUtil.generateHeader(url, "GET", ACCESS_KEY, SECRET_KEY);
        HttpURLConnection connection = (HttpURLConnection)obj.openConnection();
        for (String key : headers.keySet()) {
            connection.setRequestProperty(key, headers.get(key));
        }
        connection.setRequestMethod("GET");
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        log.info("curl:{}", (Object)HmacAuthUtil.generateCurlCommand("GET", (String)finalUrl, headers, params));
        return response.toString();
    }

    public static Map<String, String> generateHeader(String urlStr, String requestMethod, String accessKey, String secretKey) {
        HashMap<String, String> header = new HashMap<String, String>();
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            String date = dateFormat.format(new Date());
            URL url = new URL(urlStr);
            URI uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), null);
            String canonicalQueryString = HmacAuthUtil.getCanonicalQueryString(uri.getQuery());
            String message = requestMethod.toUpperCase() + "\n" + uri.getPath() + "\n" + canonicalQueryString + "\n" + accessKey + "\n" + date + "\n";
            Mac hasher = Mac.getInstance("HmacSHA256");
            hasher.init(new SecretKeySpec(secretKey.getBytes(), "HmacSHA256"));
            byte[] hash = hasher.doFinal(message.getBytes());
            DatatypeConverter.printHexBinary((byte[])hash);
            String sign = DatatypeConverter.printBase64Binary((byte[])hash);
            header.put("X-BG-HMAC-SIGNATURE", sign);
            header.put("X-BG-HMAC-ALGORITHM", "hmac-sha256");
            header.put("X-BG-HMAC-ACCESS-KEY", accessKey);
            header.put("X-BG-DATE-TIME", date);
        }
        catch (Exception e) {
            log.error("generate error", (Throwable)e);
            throw new RuntimeException("generate header error");
        }
        return header;
    }

    private static String getCanonicalQueryString(String query) {
        String[] params;
        if (query == null || query.trim().length() == 0) {
            return "";
        }
        ArrayList<Pair> queryParamList = new ArrayList<Pair>();
        for (String param2 : params = query.split("&")) {
            int eqIndex = param2.indexOf("=");
            String key = param2;
            String value = "";
            if (eqIndex != -1) {
                key = param2.substring(0, eqIndex);
                value = param2.substring(eqIndex + 1);
            }
            Pair pair = new Pair((Object)key, (Object)value);
            queryParamList.add(pair);
        }
        List sortedParamList = queryParamList.stream().sorted(Comparator.comparing(param -> (String)param.getKey() + "=" + Optional.ofNullable((String)param.getValue()).orElse(""))).collect(Collectors.toList());
        ArrayList encodeParamList = new ArrayList();
        sortedParamList.stream().forEach(param -> {
            try {
                String key = URLEncoder.encode((String)param.getKey(), "utf-8");
                String value = URLEncoder.encode(Optional.ofNullable((String)param.getValue()).orElse(""), "utf-8").replaceAll("\\%2B", "%20").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~").replaceAll("\\%25", "%");
                encodeParamList.add(new Pair((Object)key, (Object)value));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("encoding error");
            }
        });
        StringBuilder queryParamString = new StringBuilder(64);
        for (Pair encodeParam : encodeParamList) {
            queryParamString.append((String)encodeParam.getKey()).append("=").append(Optional.ofNullable((String)encodeParam.getValue()).orElse(""));
            queryParamString.append("&");
        }
        return queryParamString.substring(0, queryParamString.length() - 1);
    }

    public static String generateCurlCommand(String method, String url, Map<String, String> headers, Map<String, String> queryParams) {
        StringBuilder curlCommand = new StringBuilder();
        curlCommand.append(method).append(" ").append("curl");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                curlCommand.append(" -H ").append("\"").append(header.getKey()).append(": ").append(header.getValue()).append("\"");
            }
        }
        curlCommand.append(" ").append(url);
        return curlCommand.toString();
    }
}

