/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.irs.controller;

import cn.smarthse.services.irs.service.impl.IrsMarketEntitiesFetchDataServiceImpl;
import cn.smarthse.services.irs.service.impl.IsrIndustryFetchDataServiceImpl;
import jakarta.annotation.Resource;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/irsIndustry"})
public class IrsIndustryController {
    @Resource
    private IsrIndustryFetchDataServiceImpl isrIndustryFetchDataService;
    @Resource
    private IrsMarketEntitiesFetchDataServiceImpl marketEntitiesFetchDataService;

    @GetMapping(value={"/fetchData/{companyName}"})
    public String fetchData(@PathVariable String companyName) {
        this.isrIndustryFetchDataService.fetchData(companyName);
        return "success";
    }

    @GetMapping(value={"/market/get"})
    public String market(String unifiedSocialCc) {
        this.marketEntitiesFetchDataService.fetchData(unifiedSocialCc);
        return "success";
    }

    @GetMapping(value={"/market/getNames"})
    public String marketFetchDataByName(String name) {
        List irsMarketEntities = this.marketEntitiesFetchDataService.fetchDataByName(name);
        return "\u62c9\u53d6\u6570\u636e" + irsMarketEntities.size() + "\u6761";
    }
}

