/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.chuangde.task;

import cn.smarthse.services.wanda.api.service.IRiskClueCollectCdService;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatisticsDataTask {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRiskClueCollectCdService collectCdService;
    LocalDate lastDay = null;

    @XxlJob(value="StatisticsTask-checkBxPullData")
    public void checkBxPullData() {
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u68c0\u67e5\u6807\u73ba\u662f\u5426\u63a8\u9001\u804c\u4e1a\u75c5\u6570\u636e");
        long start = System.currentTimeMillis();
        List bxLastMonthZybSummaryModels = this.collectCdService.checkBxPullData();
        if (CollectionUtils.isNotEmpty((Collection)bxLastMonthZybSummaryModels) && this.lastDay != LocalDate.now()) {
            XxlJobHelper.handleFail((String)"\u6807\u73ba\u6709\u63a8\u9001\u6570\u636e\u8bf7\u6ce8\u610f\u6838\u67e5");
            this.lastDay = LocalDate.now();
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u68c0\u67e5\u6807\u73ba\u662f\u5426\u63a8\u9001\u804c\u4e1a\u75c5\u6570\u636e\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    @XxlJob(value="StatisticsTask-mergeBxZybSummRiskClueData")
    public void mergeBxZybSummRiskClueData() {
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5408\u5e76\u6807\u6d17\u6570\u636e\u5230\u63a8\u9001\u8868\u5f00\u59cb");
        long start = System.currentTimeMillis();
        this.collectCdService.collectDataBxZybSmm();
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5408\u5e76\u6807\u6d17\u6570\u636e\u5230\u63a8\u9001\u8868\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
    }
}

