/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.chuangde.task;

import cn.smarthse.services.wanda.api.entity.ChuangdeParam;
import cn.smarthse.services.wanda.api.enums.RiskInfoConstants;
import cn.smarthse.services.wanda.api.service.IRiskCluePushCdService;
import cn.smarthse.util.common.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;

@Component
@EnableAsync
public class PushDataTask {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRiskCluePushCdService pushCdService;

    @XxlJob(value="PushDataTask-pushBxZybSummeryRiskClueData")
    public void pushBxZybSummeryRiskClueData() {
        JSONObject jsonObj;
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u63a8\u9001\u6807\u73ba\u4e0a\u4f20\u7684\u804c\u4e1a\u75c5\u75c5\u4eba\u98ce\u9669-\u98ce\u9669\u7ebf\u7d22\u8868\u5f00\u59cb");
        long start = System.currentTimeMillis();
        String systemId = RiskInfoConstants.systemIdBX;
        String ruleId = RiskInfoConstants.ruleIdBX;
        String jobParam = XxlJobHelper.getJobParam();
        if (StringUtils.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null) {
            systemId = jsonObj.getString("systemId");
            ruleId = jsonObj.getString("ruleId");
        }
        try {
            ChuangdeParam param = new ChuangdeParam();
            param.setSystemId(systemId);
            param.setRuleId(ruleId);
            this.pushCdService.pushRiskClue(param);
        }
        catch (Exception e) {
            this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u63a8\u9001\u6807\u73ba\u4e0a\u4f20\u7684\u804c\u4e1a\u75c5\u75c5\u4eba\u98ce\u9669-\u98ce\u9669\u7ebf\u7d22\u8868\u6267\u884c\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1->\u63a8\u9001\u6807\u73ba\u4e0a\u4f20\u7684\u804c\u4e1a\u75c5\u75c5\u4eba\u98ce\u9669-\u98ce\u9669\u7ebf\u7d22\u8868\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
    }
}

