/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.chuangde.pushdata.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.services.chuangde.pushdata.mapper.CompanyUnresolvedRiskWorkMapper;
import cn.smarthse.services.chuangde.pushdata.mapper.WorkProposePushMapper;
import cn.smarthse.services.wanda.api.entity.CompanyUnresolvedRiskWork;
import cn.smarthse.services.wanda.api.entity.WorkProposePush;
import cn.smarthse.services.wanda.api.model.CompanyUnresolvedRiskWorkModel;
import cn.smarthse.services.wanda.api.service.IRiskClueCollectCdService;
import cn.smarthse.services.wanda.api.service.IRiskCluePushCdService;
import cn.smarthse.services.wanda.api.service.IWorkProposePushService;
import cn.smarthse.services.wanda.api.vo.RiskCompanyBaseVo;
import cn.smarthse.snowflake.IdWorker;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService(timeout=600000)
public class WorkProposePushServiceImpl
extends ServiceImpl<WorkProposePushMapper, WorkProposePush>
implements IWorkProposePushService {
    @Autowired
    private WorkProposePushMapper workProposePushMapper;
    @Autowired
    private CompanyUnresolvedRiskWorkMapper companyUnresolvedRiskWorkMapper;
    @Autowired
    private IRiskClueCollectCdService collectCdService;
    @Autowired
    private IRiskCluePushCdService pushCdService;
    @Autowired
    protected IdWorker idworker;

    @Transactional(rollbackFor={RuntimeException.class})
    public void addWorkProposePush(Long workId, List<Long> cids, Long loginUserId) {
        WorkProposePush workProposePush;
        if (ObjectUtil.isNull((Object)workId) || CollectionUtils.isEmpty(cids)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        if (this.isUpdateRiskWord(workId).booleanValue()) {
            throw new HealthException("\u63a8\u9001\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u53ef\u4fee\u6539");
        }
        HashSet<Long> upd = new HashSet<Long>();
        HashSet<Long> add = new HashSet<Long>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WorkProposePush::getWorkId, (Object)workId);
        queryWrapper.in(WorkProposePush::getCid, cids);
        List workProposePushes = this.workProposePushMapper.selectList((Wrapper)queryWrapper);
        List collect = workProposePushes.stream().map(WorkProposePush::getCid).collect(Collectors.toList());
        Map<Long, WorkProposePush> workProposePushMap = workProposePushes.stream().collect(Collectors.toMap(WorkProposePush::getCid, w -> w, (w1, w2) -> w1));
        for (Long cid : cids) {
            boolean contains = collect.contains(cid);
            if (contains) {
                workProposePush = workProposePushMap.get(cid);
                if (!ObjectUtil.isNotEmpty((Object)workProposePush) || workProposePush.getIsValid().booleanValue()) continue;
                upd.add(cid);
                continue;
            }
            add.add(cid);
        }
        if (upd.size() > 0) {
            List updWPList = workProposePushes.stream().filter(w -> upd.contains(w.getCid())).distinct().collect(Collectors.toList());
            for (WorkProposePush workProposePush2 : updWPList) {
                workProposePush2.setIsValid(Boolean.valueOf(true));
                workProposePush2.setUpdateBy(loginUserId);
                workProposePush2.setUpdateDate(new Date());
            }
            boolean bl = this.updateBatchById(updWPList);
        }
        if (add.size() > 0) {
            ArrayList<WorkProposePush> addWorkProposePushList = new ArrayList<WorkProposePush>();
            for (Long aLong : add) {
                workProposePush = new WorkProposePush();
                workProposePush.setId(Long.valueOf(this.idworker.nextId()));
                workProposePush.setWorkId(workId);
                workProposePush.setCid(aLong);
                workProposePush.setCreateBy(loginUserId);
                workProposePush.setUpdateBy(loginUserId);
                workProposePush.setCreateDate(new Date());
                workProposePush.setUpdateDate(new Date());
                workProposePush.setIsValid(Boolean.valueOf(true));
                addWorkProposePushList.add(workProposePush);
            }
            this.saveBatch(addWorkProposePushList);
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void removeWorkProposePush(Long workId, List<Long> cids, Long loginUserId) {
        if (ObjectUtil.isNull((Object)workId) || CollectionUtils.isEmpty(cids)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        if (this.isUpdateRiskWord(workId).booleanValue()) {
            throw new HealthException("\u63a8\u9001\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u53ef\u4fee\u6539");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(WorkProposePush::getWorkId, (Object)workId);
        wrapper.eq(WorkProposePush::getIsValid, (Object)true);
        wrapper.in(WorkProposePush::getCid, cids);
        List workProposePushes = this.workProposePushMapper.selectList((Wrapper)wrapper);
        for (WorkProposePush workProposePush : workProposePushes) {
            workProposePush.setIsValid(Boolean.valueOf(false));
            workProposePush.setUpdateDate(new Date());
            workProposePush.setUpdateBy(loginUserId);
        }
        this.updateBatchById(workProposePushes);
    }

    public PageInfo<RiskCompanyBaseVo> getWorkProposePushList(CompanyUnresolvedRiskWorkModel model) {
        if (ObjectUtil.isNull((Object)model.getWorkId())) {
            throw new HealthException("\u672a\u6307\u5b9a\u98ce\u9669\u533a");
        }
        PageHelper.startPage((int)model.getPage(), (int)model.getRows());
        List<RiskCompanyBaseVo> dataList = this.workProposePushMapper.getWorkProposePushList(model);
        PageInfo data = new PageInfo(dataList);
        return data;
    }

    public List<RiskCompanyBaseVo> getWorkProposePushList2(CompanyUnresolvedRiskWorkModel model) {
        if (ObjectUtil.isNull((Object)model.getWorkId())) {
            throw new HealthException("\u672a\u6307\u5b9a\u98ce\u9669\u533a");
        }
        List<RiskCompanyBaseVo> dataList = this.workProposePushMapper.getWorkProposePushList(model);
        return dataList;
    }

    public Boolean isUpdateRiskWord(Long workId) {
        if (ObjectUtil.isNull((Object)workId)) {
            return true;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(CompanyUnresolvedRiskWork::getId, (Object)workId);
        lambdaQueryWrapper.and(wapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wapper.eq(CompanyUnresolvedRiskWork::getIsValid, (Object)false)).or()).eq(CompanyUnresolvedRiskWork::getPushStatus, (Object)4));
        Long integer = this.companyUnresolvedRiskWorkMapper.selectCount((Wrapper)lambdaQueryWrapper);
        return integer > 0L;
    }

    public List<Long> getWorkProposePushCidList(Long workId, List<Long> companyIdList) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (ObjectUtil.isNotEmpty(companyIdList)) {
            wrapper.in(WorkProposePush::getCid, companyIdList);
        }
        wrapper.eq(WorkProposePush::getWorkId, (Object)workId);
        wrapper.eq(WorkProposePush::getIsValid, (Object)true);
        wrapper.select(new SFunction[]{WorkProposePush::getCid});
        return this.listObjs((Wrapper)wrapper).stream().filter(Objects::nonNull).map(obj -> Long.parseLong(obj.toString())).collect(Collectors.toList());
    }
}

