/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.chuangde.pushdata.service.impl;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.services.chuangde.pushdata.mapper.RiskCluePushCdMapper;
import cn.smarthse.services.chuangde.pushdata.service.impl.ChuangdeDataLogServiceImpl;
import cn.smarthse.services.chuangde.res.ChuangdeReponseObj;
import cn.smarthse.services.chuangde.res.ChuangdeResponseJson;
import cn.smarthse.services.wanda.api.entity.ChuangdeParam;
import cn.smarthse.services.wanda.api.entity.ChuangdePullBaseEntity;
import cn.smarthse.services.wanda.api.entity.ChuangdePullRiskClue;
import cn.smarthse.services.wanda.api.entity.ChuangdePushRiskData;
import cn.smarthse.services.wanda.api.entity.log.ChuangdePushDataLog;
import cn.smarthse.services.wanda.api.service.ICompanyUnresolvedRiskWorkService;
import cn.smarthse.services.wanda.api.service.IRiskClueCollectCdService;
import cn.smarthse.services.wanda.api.service.IRiskCluePushCdService;
import cn.smarthse.services.wanda.api.service.IWorkProposePushService;
import cn.smarthse.util.common.ListUtils;
import cn.smarthse.util.common.http.HttpsUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService(timeout=600000)
@Transactional(readOnly=true)
public class RiskCluePushCdServiceImpl
extends ServiceImpl<RiskCluePushCdMapper, ChuangdePushRiskData>
implements IRiskCluePushCdService {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String dataKey = "BIZ_037_OHOL_RISK_CLUE";
    @Autowired
    private ChuangdeDataLogServiceImpl pullDataLogService;
    @Autowired
    private IRiskClueCollectCdService collectCdService;
    @Value(value="${chuangde.riskPushUrl}")
    private String riskPushUrl;
    @Value(value="${chuangde.enabled:false}")
    private Boolean pushEnabled;
    @Autowired
    private ICompanyUnresolvedRiskWorkService companyUnresolvedRiskWorkService;
    @Autowired
    private IWorkProposePushService workProposePushService;

    @Transactional
    public void push(List<ChuangdePushRiskData> list) {
        List uniqueIdList;
        ArrayList<ChuangdeReponseObj> failList;
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ChuangdeResponseJson responseJson = new ChuangdeResponseJson();
        JSONArray data = JSONArray.parseArray((String)JSONObject.toJSONString(list));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("list", (Object)data);
        String jsonStr = jsonObject.toString();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String s = HttpsUtil.doPost((String)this.riskPushUrl, (String)jsonStr, (String)"utf-8", headers);
        JSONObject object = JSONObject.parseObject((String)s);
        JSONArray value = object.getJSONArray("value");
        if (value != null) {
            List responseDataList = value.toJavaList(ChuangdeReponseObj.class);
            responseJson.setSuccessList(responseDataList.stream().filter(e -> "success".equalsIgnoreCase(e.getStatus())).collect(Collectors.toList()));
            responseJson.setFailList(responseDataList.stream().filter(e -> !"success".equalsIgnoreCase(e.getStatus())).collect(Collectors.toList()));
        }
        this.logger.error("\u63a8\u9001\u6570\u636e\u7ed3\u679c:{}", (Object)object);
        if (StringUtils.isNotBlank((CharSequence)object.getString("error"))) {
            throw new RuntimeException(responseJson.getMsg());
        }
        responseJson.setCode(object.getString("success"));
        if (!"true".equalsIgnoreCase(responseJson.getCode())) {
            responseJson.setMsg("\u5f02\u5e38\u4fe1\u606f:" + object.getString("exceptionContent") + ",\u5f02\u5e38\u5177\u4f53\u539f\u56e0:" + object.getString("attachments"));
            ChuangdePushDataLog dataLog = new ChuangdePushDataLog();
            dataLog.setDataKey(this.dataKey);
            dataLog.setCreateDate(LocalDateTime.now());
            dataLog.setUpdateDate(LocalDateTime.now());
            dataLog.setIsSuccess(Integer.valueOf(0));
            dataLog.setErrorMessage(responseJson.getMsg());
            this.pullDataLogService.save(dataLog);
            this.logger.error(responseJson.getMsg());
        }
        ArrayList successList = CollectionUtils.isNotEmpty(responseJson.getSuccessList()) ? responseJson.getSuccessList() : new ArrayList();
        ArrayList<ChuangdeReponseObj> arrayList = failList = CollectionUtils.isNotEmpty(responseJson.getFailList()) ? responseJson.getFailList() : new ArrayList<ChuangdeReponseObj>();
        if (list.size() != successList.size() + failList.size()) {
            ChuangdePushDataLog dataLog = new ChuangdePushDataLog();
            dataLog.setDataKey(this.dataKey);
            dataLog.setCreateDate(LocalDateTime.now());
            dataLog.setUpdateDate(LocalDateTime.now());
            dataLog.setIsSuccess(Integer.valueOf(0));
            dataLog.setErrorMessage("\u90e8\u5206\u98ce\u9669\u63a8\u9001\u5931\u8d25,\u603b\u6570:" + list.size() + ",\u6210\u529f\u6570:" + successList.size() + ",\u5931\u8d25\u6570:" + failList.size());
            this.pullDataLogService.save(dataLog);
            this.logger.error("\u90e8\u5206\u98ce\u9669\u63a8\u9001\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty(successList)) {
            uniqueIdList = successList.stream().map(ChuangdeReponseObj::getUniqueId).collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(ChuangdePushRiskData::getUniqueId, uniqueIdList)).eq(ChuangdePullBaseEntity::getIsValid, (Object)true)).set(ChuangdePullBaseEntity::getIsProc, (Object)2)).set(ChuangdePullBaseEntity::getLastPullDate, (Object)new Date())).set(ChuangdePushRiskData::getErrorMessage, null)).set(ChuangdePullBaseEntity::getUpdateDate, (Object)new Date())).setSql("push_num = push_num + 1", new Object[0])).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.collectCdService.lambdaUpdate().in(ChuangdePullRiskClue::getUniqueId, uniqueIdList)).set(ChuangdePullBaseEntity::getIsProc, (Object)2)).set(ChuangdePullBaseEntity::getUpdateDate, (Object)new Date())).update();
        }
        if (CollectionUtils.isNotEmpty(failList)) {
            uniqueIdList = failList.stream().map(ChuangdeReponseObj::getUniqueId).collect(Collectors.toList());
            ((RiskCluePushCdMapper)this.baseMapper).updateFailData(failList, new Date());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.collectCdService.lambdaUpdate().in(ChuangdePullRiskClue::getUniqueId, uniqueIdList)).set(ChuangdePullBaseEntity::getIsProc, (Object)3)).set(ChuangdePullBaseEntity::getUpdateDate, (Object)new Date())).update();
        }
    }

    public void pushTemp(List<ChuangdePushRiskData> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ArrayList<String> uniqueIdList1 = new ArrayList<String>();
        ArrayList<String> uniqueIdList2 = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            ChuangdePushRiskData data = list.get(i);
            if (i == 1) continue;
            if (i == 2) {
                uniqueIdList2.add(data.getUniqueId());
            }
            uniqueIdList1.add(data.getUniqueId());
        }
        if (CollectionUtils.isNotEmpty(uniqueIdList1)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(ChuangdePushRiskData::getUniqueId, uniqueIdList1)).eq(ChuangdePullBaseEntity::getIsValid, (Object)true)).set(ChuangdePullBaseEntity::getIsProc, (Object)2)).set(ChuangdePullBaseEntity::getLastPullDate, (Object)new Date())).set(ChuangdePushRiskData::getErrorMessage, null)).set(ChuangdePullBaseEntity::getUpdateDate, (Object)new Date())).setSql("push_num = push_num + 1", new Object[0])).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.collectCdService.lambdaUpdate().in(ChuangdePullRiskClue::getUniqueId, uniqueIdList1)).set(ChuangdePullBaseEntity::getIsProc, (Object)2)).set(ChuangdePullBaseEntity::getUpdateDate, (Object)new Date())).update();
        }
        if (CollectionUtils.isNotEmpty(uniqueIdList2)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(ChuangdePushRiskData::getUniqueId, uniqueIdList2)).eq(ChuangdePullBaseEntity::getIsValid, (Object)true)).set(ChuangdePullBaseEntity::getIsProc, (Object)3)).set(ChuangdePullBaseEntity::getLastPullDate, (Object)new Date())).set(ChuangdePushRiskData::getErrorMessage, (Object)"\u63a8\u9001\u5931\u8d25\u62c9\u554a\u5b9e\u6253\u5b9e\u7684")).set(ChuangdePullBaseEntity::getUpdateDate, (Object)new Date())).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.collectCdService.lambdaUpdate().in(ChuangdePullRiskClue::getUniqueId, uniqueIdList2)).set(ChuangdePullBaseEntity::getIsProc, (Object)3)).set(ChuangdePullBaseEntity::getUpdateDate, (Object)new Date())).update();
        }
    }

    @Transactional
    public List<ChuangdePushRiskData> pushRiskClue(ChuangdeParam param) {
        if (param.getSystemId() == null || param.getRuleId() == null) {
            return Collections.emptyList();
        }
        if (param.getIsProc() == null) {
            param.setIsProc(Integer.valueOf(1));
        }
        List<ChuangdePushRiskData> list = ((RiskCluePushCdMapper)this.baseMapper).getWaitPushDate(param);
        if (!this.pushEnabled.booleanValue()) {
            ListUtils.split(list, (int)1000).forEach(this::pushTemp);
        } else {
            ListUtils.split(list, (int)1000).forEach(this::push);
        }
        if (Objects.equals(true, param.getIsChangeLawStatus())) {
            param.setIsProc(Integer.valueOf(2));
            this.changePushDataLawStatus(param);
        }
        return Collections.emptyList();
    }

    @Transactional
    public void changePushDataLawStatus(ChuangdeParam param) {
        if (param.getSystemId() == null || param.getRuleId() == null) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ChuangdePushRiskData::getSystemId, (Object)param.getSystemId());
        queryWrapper.eq(ChuangdePushRiskData::getRuleId, (Object)param.getRuleId());
        queryWrapper.eq(ChuangdePullBaseEntity::getIsProc, (Object)(param.getIsProc() == null ? 2 : param.getIsProc()));
        queryWrapper.eq(ChuangdePullBaseEntity::getIsValid, (Object)1);
        if (param.getWorkId() != null) {
            queryWrapper.eq(ChuangdePushRiskData::getWorkId, (Object)param.getWorkId());
        }
        queryWrapper.select(new SFunction[]{ChuangdePullBaseEntity::getSourceId});
        List list = this.list((Wrapper)queryWrapper);
        for (ChuangdePushRiskData data : list) {
            if (data == null) continue;
            ids.addAll(StringUtils.parseToLongList((String)data.getSourceId(), (String)","));
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            this.changeLawStatus(ids);
        }
    }

    @Transactional
    public void changeLawStatus(List<Long> reformIds) {
        if (CollectionUtils.isNotEmpty(reformIds)) {
            ((RiskCluePushCdMapper)this.baseMapper).changeLawStatus(reformIds, true);
            ((RiskCluePushCdMapper)this.baseMapper).changeLawStatus(reformIds, false);
        }
    }

    @Transactional
    public void removePushRiskData(Long workId, List<Long> idList, List<Long> companyIdList) {
        List pushRiskDataList;
        if (CollectionUtils.isEmpty(idList) && CollectionUtils.isEmpty(companyIdList)) {
            throw new ServiceException("\u5220\u9664\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper riskDataLambdaQueryWrapper = Wrappers.lambdaQuery();
        riskDataLambdaQueryWrapper.eq(ChuangdePushRiskData::getWorkId, (Object)workId);
        riskDataLambdaQueryWrapper.eq(ChuangdePullBaseEntity::getIsValid, (Object)true);
        if (CollectionUtils.isNotEmpty(idList)) {
            riskDataLambdaQueryWrapper.in(ChuangdePushRiskData::getId, idList);
        }
        if (CollectionUtils.isNotEmpty(companyIdList)) {
            riskDataLambdaQueryWrapper.in(ChuangdePushRiskData::getCompanyId, companyIdList);
        }
        if (CollectionUtils.isEmpty((Collection)(pushRiskDataList = this.list((Wrapper)riskDataLambdaQueryWrapper)))) {
            this.logger.error("\u5220\u9664\u6570\u636e\u4e0d\u5b58\u5728");
            return;
        }
        Optional<ChuangdePushRiskData> riskDataOptional = pushRiskDataList.stream().filter(riskData -> riskData.getIsProc() == 2).findAny();
        if (riskDataOptional.isPresent()) {
            throw new ServiceException("\u5b58\u5728\u5df2\u5904\u7406\u7684\u4f01\u4e1a\u6570\u636e" + riskDataOptional.get().getUniqueId() + "\u4e0d\u80fd\u5220\u9664");
        }
        List cidList = pushRiskDataList.stream().map(ChuangdePushRiskData::getCompanyId).collect(Collectors.toList());
        List riskClues = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.collectCdService.lambdaQuery().eq(ChuangdePullRiskClue::getWorkId, (Object)workId)).in(ChuangdePullRiskClue::getCompanyId, cidList)).eq(ChuangdePullBaseEntity::getIsValid, (Object)true)).list();
        if (CollectionUtils.isNotEmpty((Collection)riskClues)) {
            Optional<ChuangdePullRiskClue> riskClueOptional = riskClues.stream().filter(riskClue -> riskClue.getIsProc() == 2).findAny();
            if (riskClueOptional.isPresent()) {
                throw new ServiceException("\u5b58\u5728\u5df2\u5904\u7406\u7684\u98ce\u9669\u6570\u636e" + riskClueOptional.get().getUniqueId() + "\u4e0d\u80fd\u5220\u9664");
            }
            this.collectCdService.removeByIds((Collection)riskClues.stream().map(ChuangdePullRiskClue::getId).collect(Collectors.toList()));
        }
        this.removeByIds(pushRiskDataList.stream().map(ChuangdePushRiskData::getId).collect(Collectors.toList()));
    }
}

