/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.chuangde.pushdata.service.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProvideMasService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysRemindProvideService;
import cn.smarthse.modules.health.bx.model.BxLastMonthZybSummaryModel;
import cn.smarthse.modules.health.enums.reform.PushRiskContentEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.sys.utils.HolidayUtils;
import cn.smarthse.services.chuangde.pushdata.mapper.AreaCdMapper;
import cn.smarthse.services.chuangde.pushdata.mapper.OrgCdMapper;
import cn.smarthse.services.chuangde.pushdata.mapper.RiskClueCollectCdMapper;
import cn.smarthse.services.wanda.api.entity.ChuangdeParam;
import cn.smarthse.services.wanda.api.entity.ChuangdePullBaseEntity;
import cn.smarthse.services.wanda.api.entity.ChuangdePullRiskClue;
import cn.smarthse.services.wanda.api.entity.ChuangdePushRiskData;
import cn.smarthse.services.wanda.api.entity.ChuangdeRiskArea;
import cn.smarthse.services.wanda.api.entity.ChuangdeRiskOrg;
import cn.smarthse.services.wanda.api.entity.CompanyUnresolvedRiskWork;
import cn.smarthse.services.wanda.api.enums.RiskInfoConstants;
import cn.smarthse.services.wanda.api.model.ChuangdePushRiskDataVo;
import cn.smarthse.services.wanda.api.service.ICompanyUnresolvedRiskWorkService;
import cn.smarthse.services.wanda.api.service.IRiskClueCollectCdService;
import cn.smarthse.services.wanda.api.service.IRiskCluePushCdService;
import cn.smarthse.services.wanda.api.service.IWorkProposePushService;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.ListUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService(timeout=600000)
@Transactional(readOnly=true)
public class RiskClueCollectCdServiceImpl
extends ServiceImpl<RiskClueCollectCdMapper, ChuangdePullRiskClue>
implements IRiskClueCollectCdService {
    @Autowired
    private IRiskCluePushCdService pushRiskService;
    @Autowired
    private AreaCdMapper areaCdMapper;
    @Autowired
    private OrgCdMapper orgCdMapper;
    @Autowired
    private RedisClient redisClient;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @DubboReference
    private IReformItemBasicNewService reformItemBasicNewService;
    @Autowired
    private ICompanyUnresolvedRiskWorkService companyUnresolvedRiskWorkService;
    @Autowired
    private IWorkProposePushService workProposePushService;
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    protected IdWorker idworker;
    @DubboReference
    private ISMSProvideMasService masService;
    @Value(value="${smarthse.phone:18989489891}")
    private String phonenum;
    @DubboReference
    private ISysRemindProvideService remindProvideService;

    @Transactional
    public void collectData(ChuangdeParam param) {
        this.collectStep2Data(this.collectStep1Data(param));
    }

    @Transactional
    public List<ChuangdePullRiskClue> collectStep1Data(ChuangdeParam param) {
        if (StringUtils.isBlank((CharSequence)param.getRuleId())) {
            throw new ServiceException("\u89c4\u5219id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getWorkId() == null) {
            throw new ServiceException("\u5de5\u4f5c\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Object> riskList = ((RiskClueCollectCdMapper)this.baseMapper).getCollectRiskList2(param);
        if (param.getRuleId().equals(RiskInfoConstants.ruleId)) {
            this.setDataDetail(riskList, RiskInfoConstants.systemId, RiskInfoConstants.ruleId, RiskInfoConstants.title, param);
        } else if (param.getRuleId().equals(RiskInfoConstants.ruleIdYc)) {
            this.setDataDetail(riskList, RiskInfoConstants.systemIdYc, RiskInfoConstants.ruleIdYc, RiskInfoConstants.titleYc, param);
        }
        if (CollectionUtils.isEmpty(riskList)) {
            return Collections.emptyList();
        }
        List exitCidList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ChuangdePullRiskClue::getRuleId, (Object)param.getRuleId())).eq(ChuangdePullRiskClue::getWorkId, (Object)param.getWorkId())).eq(ChuangdePullBaseEntity::getIsValid, (Object)true)).list().stream().filter(Objects::nonNull).map(ChuangdePullRiskClue::getCompanyId).collect(Collectors.toList());
        riskList = riskList.stream().filter(item -> !exitCidList.contains(item.getCompanyId())).collect(Collectors.toList());
        ListUtils.split(riskList, (int)1000).forEach(arg_0 -> ((RiskClueCollectCdServiceImpl)this).saveBatch(arg_0));
        return riskList;
    }

    @Transactional
    public void collectStep2Data(List<ChuangdePullRiskClue> riskList) {
        ArrayList list = new ArrayList();
        if (CollectionUtils.isEmpty(riskList)) {
            return;
        }
        Map<Long, List<ChuangdePullRiskClue>> collect = riskList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ChuangdePullRiskClue::getCompanyId));
        collect.forEach((cid, clues) -> {
            List generationSourceList = clues.stream().filter(Objects::nonNull).map(ChuangdePullRiskClue::getGenerationSource).distinct().sorted().collect(Collectors.toList());
            List sourceId = clues.stream().filter(Objects::nonNull).map(ChuangdePullBaseEntity::getSourceId).collect(Collectors.toList());
            List riskDateList = clues.stream().filter(Objects::nonNull).map(item -> Date.from(item.getRiskDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atStartOfDay(ZoneId.systemDefault()).toInstant())).distinct().sorted().collect(Collectors.toList());
            String riskDateStr = riskDateList.stream().map(item -> DateUtils.format((Date)item, (String)"yyyy-MM-dd")).collect(Collectors.joining("/"));
            ChuangdePushRiskData data = new ChuangdePushRiskData();
            BeanUtils.copyProperties(clues.get(0), (Object)data);
            data.setGenerationSource(String.join((CharSequence)",", generationSourceList));
            data.setSourceId(String.join((CharSequence)",", sourceId));
            data.setRiskDate((Date)riskDateList.get(0));
            StringBuilder content = new StringBuilder("\u9884\u8b66\u65f6\u95f4\uff1a" + riskDateStr + "\uff0c\n\u540d\u79f0\uff1a" + data.getCompanyName() + "\uff0c\n\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\uff1a" + data.getCreditCode() + "\uff0c\n\n\u9884\u8b66\u5185\u5bb9\uff1a\n");
            int a = 0;
            for (String generationSource : generationSourceList) {
                content.append(++a).append(".").append(PushRiskContentEnum.getNameByValue((Byte)Byte.valueOf(generationSource))).append("\n");
            }
            data.setRiskContent(content.toString());
            list.add(data);
        });
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ListUtils.split(list, (int)1000).forEach(arg_0 -> ((IRiskCluePushCdService)this.pushRiskService).saveBatch(arg_0));
    }

    public List<BxLastMonthZybSummaryModel> checkBxPullData() {
        List<BxLastMonthZybSummaryModel> bxZybSumm = ((RiskClueCollectCdMapper)this.baseMapper).getBxZybSumm();
        return bxZybSumm;
    }

    @Transactional
    public void collectDataBxZybSmm() {
        List<BxLastMonthZybSummaryModel> bxZybSumm = ((RiskClueCollectCdMapper)this.baseMapper).getBxZybSumm();
        XxlJobHelper.log((String)"\u672c\u6b21\u9700\u5904\u7406\u6761\u6570\uff1a{}", (Object[])new Object[]{bxZybSumm == null ? 0 : bxZybSumm.size()});
        if (CollectionUtils.isEmpty(bxZybSumm)) {
            return;
        }
        ArrayList<ChuangdePushRiskData> chuangdePushRiskDataStream = new ArrayList<ChuangdePushRiskData>();
        ArrayList<Long> zybSubmmIdList = new ArrayList<Long>();
        try {
            this.remindProvideService.sendRemind("monitorservice:BxLastMonthZybSummaryServiceImpl:saveOrUpdateData", "\u3010\u63d0\u9192\u3011\uff08\u7591\u4f3c\uff09\u804c\u4e1a\u75c5\u75c5\u4eba\u7ebf\u7d22\u6709\u65b0\u63a8\u9001\u8bb0\u5f55\uff0c\u8bf7\u5373\u65f6\u5904\u7406\uff01", "\u3010\u63d0\u9192\u3011\uff08\u7591\u4f3c\uff09\u804c\u4e1a\u75c5\u75c5\u4eba\u7ebf\u7d22\u6709\u65b0\u63a8\u9001\u8bb0\u5f55\uff0c\u8bf7\u5373\u65f6\u5904\u7406\uff01");
            Boolean weekday = HolidayUtils.isWeekday((LocalDate)LocalDate.now());
            if (weekday.booleanValue()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(this.phonenum, "\u3010\u63d0\u9192\u3011\uff08\u7591\u4f3c\uff09\u804c\u4e1a\u75c5\u75c5\u4eba\u7ebf\u7d22\u6709\u65b0\u63a8\u9001\u8bb0\u5f55\uff0c\u8bf7\u5373\u65f6\u5904\u7406\uff01");
                LocalTime start = LocalTime.of(8, 0);
                LocalTime end = LocalTime.of(18, 0);
                this.masService.sendOrDelaySms(map, start, end, Byte.valueOf((byte)0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("\u63d0\u9192\u51fa\u9519\uff1a", (Throwable)e);
        }
        for (BxLastMonthZybSummaryModel b : bxZybSumm) {
            ChuangdePushRiskData data = new ChuangdePushRiskData();
            try {
                this.setAreaAndOrgCode(null, b);
            }
            catch (Exception e) {
                this.logger.error("\u8bbe\u7f6eregionCode,orgCode\u5c5e\u6027\u51fa\u9519BxLastMonthZybSummary.id:{}", (Object)b.getId());
            }
            if (StringUtils.isBlank((CharSequence)b.getRegionCode()) || StringUtils.isBlank((CharSequence)b.getOrgCode())) {
                this.logger.error("\u5b58\u5728\u5f02\u5e38\u6570\u636e\uff0c\u4e0d\u540c\u6b65\u6570\u636eBxLastMonthZybSummary.id:{}", (Object)b.getId());
                continue;
            }
            BeanUtils.copyProperties((Object)b, (Object)data);
            String dataStr = DateUtils.format((Date)new Date(), (String)"yyyyMMdd");
            data.setSystemId(RiskInfoConstants.systemIdBX);
            data.setRuleId(RiskInfoConstants.ruleIdBX);
            data.setUniqueId(dataStr + RiskInfoConstants.systemIdBX + RiskInfoConstants.ruleIdBX + b.getRiskMainpartId());
            data.setRiskMainpartName(b.getCompanyName());
            data.setSourceId(b.getRiskMainpartId());
            data.setRiskResource(b.getRiskSource());
            data.setOrgcode(b.getOrgCode());
            if (Objects.nonNull(data.getRiskDate())) {
                data.setHandleDate(DateUtils.addMonth((Date)data.getRiskDate(), (int)2));
            }
            data.setIsProc(Integer.valueOf(1));
            data.setIsAdd(Boolean.valueOf(true));
            if (StringUtils.isBlank((CharSequence)data.getCreditCode())) {
                data.setObjectType(Integer.valueOf(1));
                data.setCreditCode("");
            } else {
                data.setObjectType(Integer.valueOf(2));
                data.setCreditCode(data.getCreditCode().toUpperCase());
            }
            Date date = new Date();
            data.setCreateDate(date);
            data.setUpdateDate(date);
            data.setIsValid(Global.TRUE);
            data.setId(Long.valueOf(this.idworker.nextId()));
            String riskContent = data.getRiskContent();
            if (StringUtils.isNotBlank((CharSequence)riskContent)) {
                riskContent = StringUtils.replace((String)riskContent, (String)"\u7528\u5de5\u5355\u4f4d\u884c\u4e1a\u7c7b\u522b\uff1a--", (String)("\u7528\u5de5\u5355\u4f4d\u884c\u4e1a\u7c7b\u522b\uff1a" + b.getIndustryName()));
                data.setRiskContent(riskContent);
            }
            chuangdePushRiskDataStream.add(data);
            zybSubmmIdList.add(b.getId());
        }
        if (CollectionUtils.isNotEmpty(chuangdePushRiskDataStream)) {
            XxlJobHelper.log((String)"\u8f6c\u6362\u5165\u5e93chuangdePushRiskDataStream\u6761\u6570\uff1a{}", (Object[])new Object[]{chuangdePushRiskDataStream.size()});
            ListUtils.split(chuangdePushRiskDataStream, (int)1000).forEach(arg_0 -> ((IRiskCluePushCdService)this.pushRiskService).saveBatch(arg_0));
            ((RiskClueCollectCdMapper)this.baseMapper).updateBxZybSummSync(1, zybSubmmIdList);
        }
        XxlJobHelper.handleFail((String)"\u5b58\u5728\u9700\u8981\u6dfb\u52a0\u201c\u7591\u4f3c\u201d\u804c\u4e1a\u75c5\u7684\u4f01\u4e1a\uff0c\u8bf7\u5373\u65f6\u6dfb\u52a0");
    }

    private void setDataDetail(List<ChuangdePullRiskClue> riskList, String systemId, String ruleId, String title, ChuangdeParam param) {
        Date date = new Date();
        for (ChuangdePullRiskClue risk : riskList) {
            if (risk == null) continue;
            risk.setId(Long.valueOf(this.idworker.nextId()));
            risk.setWorkId(param.getWorkId());
            risk.setCreateDate(date);
            risk.setCreateBy(param.getCreateBy());
            risk.setUpdateDate(date);
            risk.setUpdateBy(param.getCreateBy());
            risk.setIsValid(Global.TRUE);
            risk.setSystemId(systemId);
            risk.setRuleId(ruleId);
            risk.setRiskTitle(title);
            risk.setUniqueId(systemId + ruleId + risk.getCompanyId() + param.getWorkId());
            risk.setSourceId(risk.getRiskMainpartId());
            risk.setIsProc(Integer.valueOf(1));
            risk.setIsAdd(Boolean.valueOf(true));
            risk.setHandleDate(DateUtils.addMonth((Date)risk.getRiskDate(), (int)2));
            risk.setRiskResource(ReformSourceLiteEnum.getSourceNameByValue((Byte)Byte.valueOf(risk.getRiskResource())));
            this.setAreaAndOrgCode(risk, null);
            if (StringUtils.isBlank((CharSequence)risk.getCreditCode())) {
                risk.setObjectType(Integer.valueOf(1));
                risk.setCreditCode("");
            } else {
                risk.setObjectType(Integer.valueOf(2));
                risk.setCreditCode(risk.getCreditCode().toUpperCase());
            }
            if (!StringUtils.isNotBlank((CharSequence)risk.getFileUrl())) continue;
            String fileUrl = "";
            String[] split = risk.getFileUrl().split(",");
            StringBuilder builder = new StringBuilder();
            for (String s : split) {
                fileUrl = this.sysFileProvideService.getFileUrl(Long.valueOf(s));
                if (!StringUtils.isNotBlank((CharSequence)fileUrl)) continue;
                builder.append(fileUrl).append(",");
            }
            if (builder.toString().isEmpty()) continue;
            risk.setFileUrl(builder.substring(0, builder.length() - 1));
        }
    }

    private void setAreaAndOrgCode(ChuangdePullRiskClue riskClue, BxLastMonthZybSummaryModel bxRiskClue) {
        ChuangdeRiskOrg org;
        ChuangdeRiskArea area;
        Map<Long, ChuangdeRiskArea> areaMap = this.getCdAreaMap();
        Map<Long, ChuangdeRiskOrg> orgMap = this.getCdorgMap();
        if (riskClue != null && riskClue.getAreaId() != null) {
            area = areaMap.get(riskClue.getAreaId());
            if (area == null) {
                throw new ServiceException("\u98ce\u9669\u7ebf\u7d22\u533a\u57df\u5bf9\u5e94id\u4e0d\u5b58\u5728.");
            }
            riskClue.setRiskLocation(area.getAreaFullName());
            riskClue.setRiskArea(area.getAreaCode());
            riskClue.setRegionCode(area.getAreaCode());
            org = orgMap.get(riskClue.getAreaId());
            if (org == null) {
                throw new ServiceException("\u98ce\u9669\u7ebf\u7d22\u673a\u6784\u5bf9\u5e94id\u4e0d\u5b58\u5728.");
            }
            riskClue.setOrgcode(org.getOrgCode());
        }
        if (bxRiskClue != null && bxRiskClue.getAreaId() != null) {
            area = areaMap.get(bxRiskClue.getAreaId());
            if (area == null) {
                throw new ServiceException("\u98ce\u9669\u7ebf\u7d22\u533a\u57df\u5bf9\u5e94id\u4e0d\u5b58\u5728..");
            }
            bxRiskClue.setRiskLocation(area.getAreaFullName());
            bxRiskClue.setRiskArea(area.getAreaCode());
            bxRiskClue.setRegionCode(area.getAreaCode());
            org = orgMap.get(bxRiskClue.getAreaId());
            if (org == null) {
                throw new ServiceException("\u98ce\u9669\u7ebf\u7d22\u673a\u6784\u5bf9\u5e94id\u4e0d\u5b58\u5728..");
            }
            bxRiskClue.setOrgCode(org.getOrgCode());
        }
    }

    public Map<Long, ChuangdeRiskArea> getCdAreaMap() {
        return (Map)this.redisClient.get("chuangdeRiskAreaCache", "getAll", 3600L, () -> this.areaCdMapper.selectList((Wrapper)new LambdaQueryWrapper()).stream().collect(Collectors.toMap(ChuangdeRiskArea::getAreaId, Function.identity(), (k1, k2) -> k1)), (TypeReference)new TypeReference<Map<Long, ChuangdeRiskArea>>(){});
    }

    public Map<Long, ChuangdeRiskOrg> getCdorgMap() {
        return (Map)this.redisClient.get("chuangdeRiskOrgCache", "getAll", 3600L, () -> this.orgCdMapper.selectList((Wrapper)new LambdaQueryWrapper()).stream().collect(Collectors.toMap(ChuangdeRiskOrg::getAreaId, Function.identity(), (k1, k2) -> k1)), (TypeReference)new TypeReference<Map<Long, ChuangdeRiskOrg>>(){});
    }

    public PageInfo<ChuangdePushRiskDataVo> getPageCollectData(JqGridParam jqGridParam, ChuangdeParam param) {
        if (jqGridParam.getTotal() == -1L) {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows(), (boolean)false);
        } else {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        }
        return new PageInfo(this.getListCollectData(param));
    }

    public List<ChuangdePushRiskDataVo> getListCollectData(ChuangdeParam param) {
        if (param == null) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getWorkId() == null) {
            throw new ServiceException("\u5de5\u4f5c\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ChuangdePushRiskDataVo> list = ((RiskClueCollectCdMapper)this.baseMapper).getListCollectData(param);
        Map<Long, ChuangdeRiskArea> areaMap = this.getCdAreaMap();
        Map<Long, ChuangdeRiskOrg> orgMap = this.getCdorgMap();
        for (ChuangdePushRiskDataVo vo : list) {
            if (vo == null) continue;
            if (vo.getCompanyAreaId() != null && areaMap.get(vo.getCompanyAreaId()) != null) {
                vo.setCdAreaName(areaMap.get(vo.getCompanyAreaId()).getAreaFullName());
            }
            if (vo.getCompanyAreaId() == null || orgMap.get(vo.getCompanyAreaId()) == null) continue;
            vo.setCdOrgCodeName(orgMap.get(vo.getCompanyAreaId()).getOrgName());
        }
        return list;
    }

    @Transactional
    public void removePullRiskClue(Long workId, List<Long> idList, List<Long> companyIdList) {
        List pullRiskClues;
        if (CollectionUtils.isEmpty(idList) && CollectionUtils.isEmpty(companyIdList)) {
            throw new ServiceException("\u5220\u9664\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper riskClueLambdaQueryWrapper = Wrappers.lambdaQuery();
        riskClueLambdaQueryWrapper.eq(ChuangdePullRiskClue::getWorkId, (Object)workId);
        riskClueLambdaQueryWrapper.eq(ChuangdePullBaseEntity::getIsValid, (Object)true);
        if (CollectionUtils.isNotEmpty(idList)) {
            riskClueLambdaQueryWrapper.in(ChuangdePullRiskClue::getId, idList);
        }
        if (CollectionUtils.isNotEmpty(companyIdList)) {
            riskClueLambdaQueryWrapper.in(ChuangdePullRiskClue::getCompanyId, companyIdList);
        }
        if (CollectionUtils.isEmpty((Collection)(pullRiskClues = this.list((Wrapper)riskClueLambdaQueryWrapper)))) {
            this.logger.error("\u5220\u9664\u6570\u636e\u4e0d\u5b58\u5728");
            return;
        }
        Optional<ChuangdePullRiskClue> riskClueOptional = pullRiskClues.stream().filter(riskClue -> riskClue.getIsProc() == 2).findAny();
        if (riskClueOptional.isPresent()) {
            throw new ServiceException("\u5b58\u5728\u5df2\u5904\u7406\u7684\u98ce\u9669\u6570\u636e" + riskClueOptional.get().getUniqueId() + "\u4e0d\u80fd\u5220\u9664");
        }
        List cidList = pullRiskClues.stream().map(ChuangdePullRiskClue::getCompanyId).collect(Collectors.toList());
        List pushRiskDataList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.pushRiskService.lambdaQuery().eq(ChuangdePushRiskData::getWorkId, (Object)workId)).in(ChuangdePushRiskData::getCompanyId, cidList)).eq(ChuangdePullBaseEntity::getIsValid, (Object)true)).list();
        if (CollectionUtils.isNotEmpty((Collection)pushRiskDataList)) {
            Optional<ChuangdePushRiskData> riskDataOptional = pushRiskDataList.stream().filter(item -> item.getIsProc() == 2).findAny();
            if (riskDataOptional.isPresent()) {
                throw new ServiceException("\u5b58\u5728\u5df2\u5904\u7406\u7684\u4f01\u4e1a\u6570\u636e" + riskDataOptional.get().getUniqueId() + "\u4e0d\u80fd\u5220\u9664");
            }
            this.pushRiskService.removeByIds((Collection)pushRiskDataList.stream().map(ChuangdePushRiskData::getId).collect(Collectors.toList()));
        }
        this.removeByIds(pullRiskClues.stream().map(ChuangdePullRiskClue::getId).collect(Collectors.toList()));
    }

    @Transactional
    public void addCollectStep2Data(Long workId) {
        CompanyUnresolvedRiskWork riskWork = this.companyUnresolvedRiskWorkService.selectById(workId);
        if (riskWork == null) {
            throw new ServiceException("\u672a\u627e\u5230\u5de5\u4f5c\u8bb0\u5f55");
        }
        if (Objects.equals(4, riskWork.getPushStatus())) {
            throw new ServiceException("\u8be5\u5de5\u4f5c\u8bb0\u5f55\u5df2\u63a8\u9001\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c");
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ChuangdePullRiskClue::getWorkId, (Object)workId)).eq(ChuangdePullBaseEntity::getIsProc, (Object)1)).eq(ChuangdePullBaseEntity::getIsValid, (Object)true)).list();
        Set uniqueIdList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.pushRiskService.lambdaQuery().eq(ChuangdePushRiskData::getWorkId, (Object)workId)).eq(ChuangdePullBaseEntity::getIsValid, (Object)true)).select(new SFunction[]{ChuangdePushRiskData::getUniqueId}).list().stream().filter(Objects::nonNull).map(ChuangdePushRiskData::getUniqueId).collect(Collectors.toSet());
        List<ChuangdePullRiskClue> collect = list.stream().filter(Objects::nonNull).filter(item -> !uniqueIdList.contains(item.getUniqueId())).collect(Collectors.toList());
        this.collectStep2Data(collect);
    }
}

