/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.chuangde.pushdata.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogStatusEnum;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.chuangde.pushdata.mapper.CompanyUnresolvedRiskWorkMapper;
import cn.smarthse.services.chuangde.pushdata.mapper.WorkProposePushMapper;
import cn.smarthse.services.wanda.api.entity.ChuangdePullRiskClue;
import cn.smarthse.services.wanda.api.entity.CompanyUnresolvedRiskWork;
import cn.smarthse.services.wanda.api.entity.CompanyUnresolvedRiskWorkVo;
import cn.smarthse.services.wanda.api.entity.WorkProposePush;
import cn.smarthse.services.wanda.api.model.CompanyUnresolvedRiskWorkModel;
import cn.smarthse.services.wanda.api.service.ICompanyUnresolvedRiskWorkService;
import cn.smarthse.services.wanda.api.service.IRiskClueCollectCdService;
import cn.smarthse.services.wanda.api.service.IRiskCluePushCdService;
import cn.smarthse.services.wanda.api.vo.RiskCompanyBaseVo;
import cn.smarthse.snowflake.IdWorker;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={RuntimeException.class})
@DubboService(timeout=600000)
public class CompanyUnresolvedRiskWorkServiceImpl
extends ServiceImpl<CompanyUnresolvedRiskWorkMapper, CompanyUnresolvedRiskWork>
implements ICompanyUnresolvedRiskWorkService {
    @Autowired
    private CompanyUnresolvedRiskWorkMapper companyUnresolvedRiskWorkMapper;
    @Autowired
    private WorkProposePushMapper workProposePushMapper;
    @Autowired
    private IRiskClueCollectCdService collectCdService;
    @Autowired
    private IRiskCluePushCdService pushCdService;
    @Autowired
    private ISysFileProvideService sysFileService;
    @Resource
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    private IWorkOperateLogService operateLogService;
    @Autowired
    protected IdWorker idworker;

    public CompanyUnresolvedRiskWork selectById(Long workId) {
        if (workId == null) {
            return null;
        }
        return (CompanyUnresolvedRiskWork)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CompanyUnresolvedRiskWork::getId, (Object)workId)).eq(CompanyUnresolvedRiskWork::getIsValid, (Object)true)).one();
    }

    public PageInfo<CompanyUnresolvedRiskWorkVo> getRiskWorkPage(CompanyUnresolvedRiskWorkModel model) {
        PageMethod.startPage((int)model.getPage(), (int)model.getRows());
        List<CompanyUnresolvedRiskWorkVo> list = this.companyUnresolvedRiskWorkMapper.selectRiskWorkListByCnameAndCuni(model);
        Set<Object> isCanNotExamine = new HashSet();
        List collect = list.stream().filter(Objects::nonNull).map(CompanyUnresolvedRiskWork::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            isCanNotExamine = ((LambdaQueryChainWrapper)this.collectCdService.lambdaQuery().in(ChuangdePullRiskClue::getWorkId, collect)).select(new SFunction[]{ChuangdePullRiskClue::getWorkId}).list().stream().filter(Objects::nonNull).map(ChuangdePullRiskClue::getWorkId).collect(Collectors.toSet());
        }
        for (CompanyUnresolvedRiskWorkVo riskWorkVo : list) {
            if (riskWorkVo == null || riskWorkVo.getPushStatus() != 2 || isCanNotExamine.contains(riskWorkVo.getId())) continue;
            riskWorkVo.setIsCanExamine(Boolean.valueOf(true));
        }
        return new PageInfo(list);
    }

    public List<CompanyUnresolvedRiskWorkVo> getRiskWorkList(Long workId) {
        if (ObjectUtil.isNull((Object)workId)) {
            return null;
        }
        CompanyUnresolvedRiskWorkModel model = new CompanyUnresolvedRiskWorkModel();
        model.setWorkId(workId);
        List<CompanyUnresolvedRiskWorkVo> companyUnresolvedRiskWorkVos = this.companyUnresolvedRiskWorkMapper.selectRiskWorkListByCnameAndCuni(model);
        if (companyUnresolvedRiskWorkVos.size() > 0) {
            for (CompanyUnresolvedRiskWorkVo companyUnresolvedRiskWorkVo : companyUnresolvedRiskWorkVos) {
                Long pushFile = companyUnresolvedRiskWorkVo.getPushFile();
                if (!ObjectUtil.isNotNull((Object)pushFile)) continue;
                SysFileModel file = this.sysFileService.getFileById(pushFile);
                companyUnresolvedRiskWorkVo.setPushFileSys(file);
            }
        }
        return companyUnresolvedRiskWorkVos;
    }

    public Long addRiskWork(Long loginUserId, String ruleId, Long loginUserAreaId) {
        List<Long> orgIds;
        if (ObjectUtil.isNull((Object)loginUserId)) {
            throw new HealthException("\u672a\u767b\u5f55\u6216\u8005\u767b\u5f55\u5931\u6548");
        }
        if (StringUtils.isEmpty((CharSequence)ruleId)) {
            throw new HealthException("\u5fc5\u987b\u9009\u62e9\u98ce\u9669\u7c7b\u578b");
        }
        CompanyUnresolvedRiskWork companyUnresolvedRiskWork = new CompanyUnresolvedRiskWork();
        companyUnresolvedRiskWork.setId(Long.valueOf(this.idworker.nextId()));
        companyUnresolvedRiskWork.setPushStatus(Integer.valueOf(1));
        if (ObjectUtil.isNotEmpty((Object)loginUserAreaId) && (orgIds = this.companyUnresolvedRiskWorkMapper.selectOrgByAreaId(loginUserAreaId)).size() > 0) {
            companyUnresolvedRiskWork.setSupervisionUnit(orgIds.get(0));
        }
        companyUnresolvedRiskWork.setRuleId(ruleId);
        companyUnresolvedRiskWork.setSupervisionAreaId(loginUserAreaId);
        companyUnresolvedRiskWork.setSubmissionTime(new Date());
        companyUnresolvedRiskWork.setCreateBy(loginUserId);
        companyUnresolvedRiskWork.setCreateDate(new Date());
        companyUnresolvedRiskWork.setUpdateBy(loginUserId);
        companyUnresolvedRiskWork.setUpdateDate(new Date());
        companyUnresolvedRiskWork.setIsValid(Boolean.valueOf(true));
        boolean save = this.save(companyUnresolvedRiskWork);
        if (save) {
            return companyUnresolvedRiskWork.getId();
        }
        throw new HealthException("\u65b0\u589e\u672a\u5316\u89e3\u98ce\u9669\u63a8\u9001\u8bb0\u5f55\u5931\u8d25");
    }

    public PageInfo<RiskCompanyBaseVo> getPageRiskCompanyList(CompanyUnresolvedRiskWorkModel model) {
        if (ObjectUtil.isNull((Object)model.getWorkId())) {
            throw new HealthException("\u672a\u6307\u5b9a\u98ce\u9669\u5de5\u4f5c");
        }
        PageHelper.startPage((int)model.getPage(), (int)model.getRows(), (boolean)false);
        List<RiskCompanyBaseVo> dataList = this.getRiskCompanyList(model);
        return new PageInfo(dataList);
    }

    public List<RiskCompanyBaseVo> getRiskCompanyList(CompanyUnresolvedRiskWorkModel model) {
        return this.companyUnresolvedRiskWorkMapper.selectRiskCompanyList(model);
    }

    public List<RiskCompanyBaseVo> getRiskCompanyListByCid(Long workId, List<Long> cidAllList) {
        if (workId == null || CollUtil.isEmpty(cidAllList)) {
            throw new HealthException("\u672a\u6307\u5b9a\u98ce\u9669\u5de5\u4f5c\u548c\u4f01\u4e1a");
        }
        CompanyUnresolvedRiskWork riskWork = (CompanyUnresolvedRiskWork)this.getById(workId);
        AreaModel areaModel = this.sysAreaProvideService.getAreaById(riskWork.getSupervisionAreaId());
        if (ObjectUtil.isNull((Object)areaModel)) {
            throw new HealthException("\u672a\u627e\u5230\u6307\u5b9a\u98ce\u9669\u5de5\u4f5c\u6240\u5c5esupervisedAreaId");
        }
        CompanyUnresolvedRiskWorkModel model = new CompanyUnresolvedRiskWorkModel();
        model.setWorkId(workId);
        model.setCids(cidAllList);
        model.setLoginUserAreaId(areaModel.getId());
        model.setLoginAreaLevle(areaModel.getLevel());
        if (!Objects.equals(model.getLoginAreaLevle(), (byte)1)) {
            model.setIsCurrent(Boolean.valueOf(true));
            model.setCompanyLevel(Integer.valueOf(Objects.equals(model.getLoginAreaLevle(), (byte)2) ? 2 : 0));
        }
        return this.getRiskCompanyList(model);
    }

    public Integer getRiskCompanyListCount(CompanyUnresolvedRiskWorkModel model) {
        if (ObjectUtil.isNull((Object)model.getWorkId())) {
            throw new HealthException("\u672a\u6307\u5b9a\u98ce\u9669\u5de5\u4f5c");
        }
        return this.companyUnresolvedRiskWorkMapper.selectRiskCompanyListCount(model);
    }

    public Integer batchUpdateWorkProposePush(Set<Long> finalDataList, Long workId, Long userId) {
        WorkProposePush workProposePush;
        if (CollectionUtils.isEmpty(finalDataList)) {
            return null;
        }
        if (ObjectUtil.isNull((Object)workId)) {
            throw new HealthException("\u672a\u6307\u5b9a\u4f4e\u98ce\u9669\u533a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WorkProposePush::getWorkId, (Object)workId);
        queryWrapper.in(WorkProposePush::getCid, finalDataList);
        List workProposePushes = this.workProposePushMapper.selectList((Wrapper)queryWrapper);
        Map<Long, WorkProposePush> workProposePushMap = workProposePushes.stream().collect(Collectors.toMap(WorkProposePush::getCid, w -> w, (w1, w2) -> w1));
        HashSet<Long> addList = new HashSet<Long>();
        HashSet<Long> updList = new HashSet<Long>();
        for (Long aLong : finalDataList) {
            if (MapUtils.isNotEmpty(workProposePushMap)) {
                workProposePush = workProposePushMap.get(aLong);
                if (ObjectUtil.isNull((Object)workProposePush)) {
                    addList.add(aLong);
                    continue;
                }
                if (!workProposePush.getIsValid().equals(false)) continue;
                updList.add(aLong);
                continue;
            }
            addList.add(aLong);
        }
        if (updList.size() > 0 && MapUtils.isNotEmpty(workProposePushMap)) {
            for (Long aLong : updList) {
                workProposePush = workProposePushMap.get(aLong);
                if (!ObjectUtil.isNotNull((Object)workProposePush)) continue;
                workProposePush.setIsValid(Boolean.valueOf(true));
                workProposePush.setUpdateBy(userId);
                workProposePush.setUpdateDate(new Date());
                this.workProposePushMapper.updateById(workProposePush);
            }
        }
        if (addList.size() > 0) {
            for (Long aLong : addList) {
                workProposePush = new WorkProposePush();
                workProposePush.setId(Long.valueOf(this.idworker.nextId()));
                workProposePush.setWorkId(workId);
                workProposePush.setCid(aLong);
                workProposePush.setCreateBy(userId);
                workProposePush.setUpdateBy(userId);
                workProposePush.setCreateDate(new Date());
                workProposePush.setUpdateDate(new Date());
                workProposePush.setIsValid(Boolean.valueOf(true));
                this.workProposePushMapper.insert(workProposePush);
            }
        }
        return 0;
    }

    public void removeRiskWork(Long workId, Long loginUserId, Long loginUserAreaId) {
        if (ObjectUtil.isNull((Object)workId)) {
            throw new HealthException("\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanyUnresolvedRiskWork companyUnresolvedRiskWork = this.selectById(workId);
        if (companyUnresolvedRiskWork == null) {
            throw new HealthException("\u672a\u627e\u5230\u6570\u636e");
        }
        if (companyUnresolvedRiskWork.getPushStatus() != 1 && companyUnresolvedRiskWork.getPushStatus() != 3) {
            throw new HealthException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u5220\u9664");
        }
        if (!Objects.equals(loginUserAreaId, companyUnresolvedRiskWork.getSupervisionAreaId())) {
            throw new HealthException("\u8d26\u53f7\u6743\u9650\u5f02\u5e38\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        companyUnresolvedRiskWork.setIsValid(Boolean.valueOf(false));
        companyUnresolvedRiskWork.setUpdateDate(new Date());
        companyUnresolvedRiskWork.setUpdateBy(loginUserId);
        this.companyUnresolvedRiskWorkMapper.updateById(companyUnresolvedRiskWork);
    }

    @Transactional
    public void updatePushStatus(Long workId, Integer status, String resaon, Long operateId, String operateName, String organizationName) {
        WorkOperateLogStatusEnum statusEnum;
        boolean update;
        if (ObjectUtil.isNull((Object)workId) || ObjectUtil.isNull((Object)status)) {
            throw new HealthException("\u8bb0\u5f55id\u6216\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanyUnresolvedRiskWork riskWork = this.selectById(workId);
        if (Objects.equals(riskWork.getPushStatus(), 4)) {
            throw new HealthException("\u8be5\u8bb0\u5f55\u5df2\u63a8\u9001\u786e\u8ba4\u6210\u529f\uff0c\u4e0d\u80fd\u4fee\u6539\u5f53\u524d\u72b6\u6001");
        }
        if (status == 2 && riskWork.getPushFile() == null) {
            throw new HealthException("\u8bf7\u5148\u4e0a\u4f20\u9644\u4ef6");
        }
        if (status == 2) {
            // empty if block
        }
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(CompanyUnresolvedRiskWork::getId, (Object)workId);
        updateWrapper.ne(CompanyUnresolvedRiskWork::getPushStatus, (Object)status);
        updateWrapper.eq(CompanyUnresolvedRiskWork::getIsValid, (Object)true);
        updateWrapper.set(CompanyUnresolvedRiskWork::getPushStatus, (Object)status);
        updateWrapper.set(CompanyUnresolvedRiskWork::getUpdateBy, (Object)operateId);
        updateWrapper.set(CompanyUnresolvedRiskWork::getUpdateDate, (Object)new Date());
        if (status == 2) {
            updateWrapper.set(CompanyUnresolvedRiskWork::getSubmissionTime, (Object)new Date());
        }
        if (!(update = this.update((Wrapper)updateWrapper))) {
            throw new HealthException("\u66f4\u65b0\u5931\u8d25");
        }
        if (status == 2) {
            statusEnum = WorkOperateLogStatusEnum.report;
        } else if (status == 3) {
            statusEnum = WorkOperateLogStatusEnum.back;
        } else if (status == 4) {
            statusEnum = WorkOperateLogStatusEnum.pass;
        } else {
            throw new HealthException("\u72b6\u6001\u5f02\u5e38");
        }
        this.operateLogService.addOperateLog(workId, WorkOperateLogEnum.unresolvedRisk.getTypeVal(), resaon, operateId, operateName, statusEnum, organizationName);
    }

    public void addPushFile(Long fileId, Long workId, Long loginUserId, Byte loginAreaLevle) {
        CompanyUnresolvedRiskWork companyUnresolvedRiskWork;
        if (ObjectUtil.isNotNull((Object)fileId) && ObjectUtil.isNotNull((Object)workId) && ObjectUtil.isNotNull((Object)(companyUnresolvedRiskWork = (CompanyUnresolvedRiskWork)this.companyUnresolvedRiskWorkMapper.selectById(workId)))) {
            if (companyUnresolvedRiskWork.getPushStatus() != 1 && companyUnresolvedRiskWork.getPushStatus() != 3) {
                throw new HealthException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u4e0a\u4f20");
            }
            AreaModel areaModel = this.sysAreaProvideService.getAreaById(companyUnresolvedRiskWork.getSupervisionAreaId());
            if (ObjectUtil.isNotNull((Object)areaModel) && ObjectUtil.isNotNull((Object)areaModel.getLevel()) && companyUnresolvedRiskWork.getPushStatus() == 3 && !areaModel.getLevel().equals(loginAreaLevle)) {
                throw new HealthException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u4e0a\u4f20");
            }
            companyUnresolvedRiskWork.setPushFile(fileId);
            companyUnresolvedRiskWork.setUpdateDate(new Date());
            companyUnresolvedRiskWork.setUpdateBy(loginUserId);
            this.companyUnresolvedRiskWorkMapper.updateById(companyUnresolvedRiskWork);
        }
    }

    @Transactional
    public void deleteTestData(Long workId) {
        if (workId == null) {
            return;
        }
        ((CompanyUnresolvedRiskWorkMapper)this.baseMapper).deleteTestData(workId, "chuangde_company_unresolved_risk_work");
        ((CompanyUnresolvedRiskWorkMapper)this.baseMapper).deleteTestData(workId, "chuangde_work_propose_push");
        ((CompanyUnresolvedRiskWorkMapper)this.baseMapper).deleteTestData(workId, "chuangde_push_risk_data");
        ((CompanyUnresolvedRiskWorkMapper)this.baseMapper).deleteTestData(workId, "chuangde_pull_risk_clue");
    }
}

