/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.chuangde.pushdata.controller;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.services.wanda.api.entity.ChuangdeParam;
import cn.smarthse.services.wanda.api.service.IRiskClueCollectCdService;
import cn.smarthse.services.wanda.api.service.IRiskCluePushCdService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/chuangde"})
public class RiskClueCdController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IRiskCluePushCdService pushClueCdService;
    @Autowired
    IRiskClueCollectCdService collectClueCdService;

    @GetMapping(value={"/collectData"})
    @ResponseBody
    public ResponseData collectData(ChuangdeParam param) {
        this.logger.error("\u521b\u5f97\u6570\u636e\u7edf\u8ba1" + param.getRuleId() + "\u98ce\u9669\u7ebf\u7d22\u6570\u636e\u5f00\u59cb");
        long start = System.currentTimeMillis();
        this.collectClueCdService.collectData(param);
        this.logger.error("\u521b\u5f97\u6570\u636e\u7edf\u8ba1" + param.getRuleId() + "\u98ce\u9669\u7ebf\u7d22\u6570\u636e\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
        return ResponseData.success();
    }

    @GetMapping(value={"/pushData"})
    @ResponseBody
    public ResponseData pushData(ChuangdeParam param) {
        this.logger.error("\u521b\u5f97\u6570\u636e\u63a8\u9001" + param.getRuleId() + "\u9669\u7ebf\u7d22\u6570\u636e\u5f00\u59cb");
        long start = System.currentTimeMillis();
        try {
            this.pushClueCdService.pushRiskClue(param);
            this.logger.error("\u521b\u5f97\u6570\u636e\u63a8\u9001" + param.getRuleId() + "\u98ce\u9669\u7ebf\u7d22\u6570\u636e\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)((System.currentTimeMillis() - start) / 1000L));
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5f97\u6570\u636e\u63a8\u9001" + param.getRuleId() + "\u98ce\u9669\u7ebf\u7d22\u6570\u636e\u6267\u884c\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return ResponseData.success();
    }

    @GetMapping(value={"/changePushDataLawStatus"})
    @ResponseBody
    public ResponseData changePushDataLawStatus(ChuangdeParam param) {
        this.pushClueCdService.changePushDataLawStatus(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/changeLawStatus"})
    @ResponseBody
    public ResponseData changeLawStatus(List<Long> reformIds) {
        this.pushClueCdService.changeLawStatus(reformIds);
        return ResponseData.success();
    }
}

