/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.chuangde.pulldata.service.impl.exelawfeedback;

import cn.smarthse.modules.health.supervise.enums.wanda.WandaFeedbackStatusEnum;
import cn.smarthse.services.chuangde.pulldata.mapper.exelawfeedback.ExelawFeedbackMapper;
import cn.smarthse.services.chuangde.pulldata.service.impl.exelawfeedback.ExelawFeedbackServiceImpl;
import cn.smarthse.services.wanda.api.entity.feedback.ExelawFeedback;
import cn.smarthse.services.wanda.api.entity.feedback.FeedbackHandle;
import cn.smarthse.services.wanda.api.entity.feedback.FeedbackHandleCheck;
import cn.smarthse.services.wanda.api.entity.feedback.FeedbackHandleLower;
import cn.smarthse.services.wanda.api.entity.feedback.FeedbackHandleWarn;
import cn.smarthse.services.wanda.api.entity.feedback.FeedbackResult;
import cn.smarthse.services.wanda.api.entity.feedback.FeedbackUnHandle;
import cn.smarthse.services.wanda.api.model.feedback.FeedbackIdModel;
import cn.smarthse.util.common.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PullFeedbackDataServiceImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PullFeedbackDataServiceImpl.class);
    @Autowired
    ExelawFeedbackMapper feedbackMapper;
    @Value(value="${chuangde.riskFeedbackUrl}")
    private String riskFeedbackUrl;
    @Value(value="${chuangde.riskFeedbackCheckUrl}")
    private String riskFeedbackCheckUrl;
    @Autowired
    ExelawFeedbackServiceImpl feedbackService;
    private static CloseableHttpClient httpClient = HttpClients.custom().setRetryHandler(new HttpRequestRetryHandler(){

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            log.error("\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38\uff1ahttp\u8bf7\u6c42\u91cd\u8bd5\u6b21\u6570\uff1a{}, IOException:", (Object)executionCount, (Object)exception);
            if (executionCount >= 2) {
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                return true;
            }
            if (exception instanceof SSLHandshakeException) {
                return false;
            }
            if (exception instanceof InterruptedIOException) {
                return true;
            }
            if (exception instanceof UnknownHostException) {
                return false;
            }
            if (exception instanceof ConnectTimeoutException) {
                return true;
            }
            if (exception instanceof SSLException) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpRequest request = clientContext.getRequest();
            return !(request instanceof HttpEntityEnclosingRequest);
        }
    }).setMaxConnPerRoute(10).setMaxConnTotal(20).evictIdleConnections(60L, TimeUnit.SECONDS).build();

    private String getDataFromUrl(String url, String uniqueId) throws UnsupportedEncodingException, InterruptedException {
        block12: {
            String string;
            block11: {
                if (StringUtils.isBlank((CharSequence)uniqueId)) {
                    return null;
                }
                HttpPost httpPost = new HttpPost(url);
                httpPost.setHeader("Content-Type", "application/json");
                StringEntity entity = new StringEntity("{\"uniqueId\":\"" + uniqueId + "\"}");
                httpPost.setEntity((HttpEntity)entity);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                try {
                    String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (StringUtils.isBlank((CharSequence)responseText)) {
                        log.error("\u6ca1\u6709\u8fd4\u56de\u8bf7\u6c42\u5185\u5bb9..");
                    }
                    string = responseText;
                    if (response == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NoHttpResponseException ex) {
                        log.error("NoHttpResponseException, \u8bf7\u6c42\u53c2\u6570\uff1auniqueId{} ex\uff1a", (Object)uniqueId, (Object)ex);
                        break block12;
                    }
                    catch (Exception ex) {
                        log.error("\u8bfb\u53d6\u6570\u636e\u63a5\u53e3\u9519\u8bef, \u8bf7\u6c42\u53c2\u6570\uff1auniqueId{} ex\uff1a", (Object)uniqueId, (Object)ex);
                    }
                }
                response.close();
            }
            return string;
        }
        return null;
    }

    private ExelawFeedback handCheckResponse(String uniqueId) {
        ExelawFeedback exelawFeedback = new ExelawFeedback();
        exelawFeedback.setUniqueid(uniqueId);
        try {
            String checkResponseText = this.getDataFromUrl(this.riskFeedbackCheckUrl, uniqueId);
            if (StringUtils.isBlank((CharSequence)checkResponseText)) {
                return exelawFeedback;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)checkResponseText);
            if (jsonObject == null) {
                log.info("checkResponseText:{}", (Object)checkResponseText);
                return null;
            }
            boolean success = jsonObject.getBooleanValue("success");
            JSONObject value = jsonObject.getJSONObject("value");
            if (!success) {
                log.warn("\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c checkResponseText\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)checkResponseText);
                return null;
            }
            if (value == null) {
                return null;
            }
            String status = value.getString("status");
            exelawFeedback.setCdStatus(status);
            return exelawFeedback;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private ExelawFeedback handFeedbackResponse(String uniqueId) throws UnsupportedEncodingException, InterruptedException {
        String responseText = this.getDataFromUrl(this.riskFeedbackUrl, uniqueId);
        if (StringUtils.isBlank((CharSequence)responseText)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)responseText);
        if (jsonObject != null) {
            boolean success = jsonObject.getBooleanValue("success");
            JSONObject value = jsonObject.getJSONObject("value");
            if (!success) {
                log.warn("\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c \u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)responseText);
            }
            if (value == null) {
                return null;
            }
            String data = value.getString("data");
            boolean valid = JSON.isValid((String)data);
            if (!valid) {
                return null;
            }
            if ("\u8be5\u552f\u4e00\u6807\u8bc6\u5bf9\u5e94\u6267\u6cd5\u7ed3\u679c\u8bb0\u5f55\u4e3a\u7a7a!".equalsIgnoreCase(data)) {
                return null;
            }
            ExelawFeedback data1 = (ExelawFeedback)JSON.parseObject((String)data, ExelawFeedback.class);
            return data1;
        }
        return null;
    }

    private ExelawFeedback getData(String uniqueId) {
        try {
            String cdStatus;
            ExelawFeedback check = this.handCheckResponse(uniqueId);
            if (check != null && StringUtils.isNotBlank((CharSequence)(cdStatus = check.getCdStatus()))) {
                if (Objects.equals(cdStatus, "\u5df2\u5904\u7f6e-\u6267\u6cd5\u5b8c\u6210")) {
                    check.setStatus(WandaFeedbackStatusEnum.FINISH.getCode());
                } else if (Objects.equals(cdStatus, "\u5df2\u5904\u7f6e-\u89e3\u9664\u98ce\u9669")) {
                    check.setStatus(WandaFeedbackStatusEnum.DISARM.getCode());
                } else if (Objects.equals(cdStatus, "\u5df2\u5904\u7f6e-\u65e0\u987b\u5904\u7f6e")) {
                    check.setStatus(WandaFeedbackStatusEnum.NO_REQUIRED.getCode());
                } else if (Objects.equals(cdStatus, "\u5f85\u8d28\u63a7") || Objects.equals(cdStatus, "\u5904\u7f6e\u4e2d") || Objects.equals(cdStatus, "\u6267\u6cd5\u4e2d")) {
                    check.setStatus(WandaFeedbackStatusEnum.ING.getCode());
                } else if (Objects.equals(cdStatus, "\u4e0a\u62a5\u5931\u8d25") || Objects.equals(cdStatus, "\u5f85\u4e0a\u62a5") || Objects.equals(cdStatus, "\u5df2\u53d6\u6d88")) {
                    // empty if block
                }
            }
            ExelawFeedback result = this.handFeedbackResponse(uniqueId);
            if (check == null && result == null) {
                return null;
            }
            if (result == null) {
                return check;
            }
            if (check == null) {
                return result;
            }
            result.setCdStatus(check.getCdStatus());
            if (check != null && check.getStatus() != null) {
                result.setStatus(check.getStatus());
            }
            if (StringUtils.isBlank((CharSequence)result.getUniqueid())) {
                result.setUniqueid(uniqueId);
            }
            return result;
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u8bf7\u6c42\u6570\u636e\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void processData(String uniqueId) {
        ExelawFeedback data = this.getData(uniqueId);
        if (data == null) {
            return;
        }
        this.feedbackService.saveData(data, new FeedbackIdModel());
    }

    private String getVirtData(String uniqueId) {
        ExelawFeedback data = new ExelawFeedback();
        data.setStatus(Integer.valueOf(1));
        data.setRiskSystemId("systeimId");
        data.setUniqueid(uniqueId);
        data.setAccTime(new Date());
        data.setReportUrl("www.baidu.com");
        FeedbackResult result = new FeedbackResult();
        result.setPerson("\u563b\u563b\u563b");
        result.setDeptName("\u90e8\u95e8");
        result.setTime(new Date());
        ArrayList<FeedbackHandle> handles = new ArrayList<FeedbackHandle>();
        FeedbackHandle handle = new FeedbackHandle();
        handle.setDeptName("\u90e8\u95e811");
        handle.setType(Integer.valueOf(2));
        handle.setTime(new Date());
        FeedbackUnHandle unhandle = new FeedbackUnHandle();
        unhandle.setFileUrls("www.baidu.com/111");
        unhandle.setReasonText("responseText...");
        unhandle.setReasonType(Integer.valueOf(1));
        FeedbackHandleWarn warn = new FeedbackHandleWarn();
        warn.setWarnContent("content");
        warn.setWarnDeptNames("\u90e8\u95e8");
        warn.setWarnDue(new Date());
        FeedbackHandleCheck check = new FeedbackHandleCheck();
        check.setCheckDue(new Date());
        check.setCheckDeptName("\u90e8\u95e8 check");
        check.setTaskCheckContent("content");
        check.setTaskContactTel("135448888");
        check.setJoinDeptNames("\u90e8\u95e8111");
        check.setLeadDeptName("\u90e8\u95e8000");
        check.setTaskType(Integer.valueOf(1));
        check.setFileUrls("wwww");
        check.setCheckPerson("person");
        FeedbackHandleLower lower = new FeedbackHandleLower();
        lower.setBeSendedDeptName("\u90e8\u95e8");
        lower.setCurDeptName("\u90e8\u95e822");
        lower.setHandleDue(new Date());
        handle.setHandleCheck(check);
        handle.setHandlelower(lower);
        handle.setHandleWarn(warn);
        handle.setUnhandle(unhandle);
        handles.add(handle);
        data.setHandles(handles);
        String jsonString = JSON.toJSONString((Object)data);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", "true");
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("data", jsonString);
        map.put("value", value);
        String resultStr = JSON.toJSONString(map);
        System.out.println(resultStr);
        return resultStr;
    }

    public static void main(String[] args) {
        String json = "{\"checkResults\":[],\"handles\":[{\"deptName\":\"\u6e29\u5dde\u5e02\u6cf0\u987a\u53bf\u536b\u751f\u5065\u5eb7\u5c40\",\"handleCheck\":{\"checkDeptName\":\"\u6e29\u5dde\u5e02\u6cf0\u987a\u53bf\u536b\u751f\u5065\u5eb7\u5c40\",\"checkDue\":1702742400000,\"checkPerson\":\"\u9648\u7984\u6807,\u859b\u7ec6\u7389\",\"fileUrls\":\"\",\"joinDeptNames\":\"\",\"leadDeptName\":\"\",\"taskCheckContent\":\"\",\"taskContactPerson\":\"\u9648\u7984\u6807,\u859b\u7ec6\u7389\",\"taskContactTel\":\"\",\"taskType\":\"1\"},\"person\":\"\u9648\u7984\u6807,\u859b\u7ec6\u7389\",\"time\":1700184256000,\"type\":3}],\"reportUrl\":\"\",\"riskType\":\"70-A\",\"status\":1,\"uniqueId\":\"000030030u013988082923898003\"}";
        System.out.println(json);
        Map map = (Map)JSON.parseObject((String)json, Map.class);
        System.out.println(map);
        ExelawFeedback data1 = (ExelawFeedback)com.alibaba.fastjson2.JSON.parseObject((String)json, ExelawFeedback.class);
        System.out.println(data1);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
    }
}

