/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.chuangde.pulldata.service.impl.exelawfeedback;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.services.chuangde.pulldata.mapper.exelawfeedback.ExelawFeedbackMapper;
import cn.smarthse.services.chuangde.pulldata.service.impl.exelawfeedback.FeedbackHandleCheckServiceImpl;
import cn.smarthse.services.chuangde.pulldata.service.impl.exelawfeedback.FeedbackHandleLowerServiceImpl;
import cn.smarthse.services.chuangde.pulldata.service.impl.exelawfeedback.FeedbackHandleServiceImpl;
import cn.smarthse.services.chuangde.pulldata.service.impl.exelawfeedback.FeedbackHandleWarnServiceImpl;
import cn.smarthse.services.chuangde.pulldata.service.impl.exelawfeedback.FeedbackResultServiceImpl;
import cn.smarthse.services.chuangde.pulldata.service.impl.exelawfeedback.FeedbackUnHandleServiceImpl;
import cn.smarthse.services.wanda.api.entity.ChuangdePushRiskData;
import cn.smarthse.services.wanda.api.entity.feedback.ExelawFeedback;
import cn.smarthse.services.wanda.api.entity.feedback.FeedbackHandle;
import cn.smarthse.services.wanda.api.entity.feedback.FeedbackHandleCheck;
import cn.smarthse.services.wanda.api.entity.feedback.FeedbackHandleLower;
import cn.smarthse.services.wanda.api.entity.feedback.FeedbackHandleWarn;
import cn.smarthse.services.wanda.api.entity.feedback.FeedbackResult;
import cn.smarthse.services.wanda.api.entity.feedback.FeedbackUnHandle;
import cn.smarthse.services.wanda.api.model.feedback.FeedbackIdModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExelawFeedbackServiceImpl
extends ServiceImpl<ExelawFeedbackMapper, ExelawFeedback> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExelawFeedbackServiceImpl.class);
    @Autowired
    ExelawFeedbackServiceImpl feedbackService;
    @Autowired
    FeedbackHandleCheckServiceImpl checkService;
    @Autowired
    FeedbackHandleLowerServiceImpl lowerService;
    @Autowired
    FeedbackHandleServiceImpl handleService;
    @Autowired
    FeedbackHandleWarnServiceImpl warnService;
    @Autowired
    FeedbackResultServiceImpl resultService;
    @Autowired
    FeedbackUnHandleServiceImpl unHandleService;

    @Transactional(readOnly=false)
    public void delData(String uniqueId) {
        LambdaQueryWrapper exelawFeedbackLambdaQueryWrapper = Wrappers.lambdaQuery();
        if (StringUtils.isNotBlank((CharSequence)uniqueId)) {
            exelawFeedbackLambdaQueryWrapper.eq(ExelawFeedback::getUniqueid, (Object)uniqueId);
        }
        this.feedbackService.remove((Wrapper)exelawFeedbackLambdaQueryWrapper);
        if (uniqueId == null) {
            LambdaQueryWrapper feedbackHandleCheck = Wrappers.lambdaQuery();
            this.checkService.remove((Wrapper)feedbackHandleCheck);
            LambdaQueryWrapper feedbackHandleLower = Wrappers.lambdaQuery();
            this.lowerService.remove((Wrapper)feedbackHandleLower);
            LambdaQueryWrapper feedbackResult = Wrappers.lambdaQuery();
            this.resultService.remove((Wrapper)feedbackResult);
            LambdaQueryWrapper feedbackHandle = Wrappers.lambdaQuery();
            this.handleService.remove((Wrapper)feedbackHandle);
            LambdaQueryWrapper feedbackHandleWarn = Wrappers.lambdaQuery();
            this.warnService.remove((Wrapper)feedbackHandleWarn);
            LambdaQueryWrapper feedbackUnHandle = Wrappers.lambdaQuery();
            this.unHandleService.remove((Wrapper)feedbackUnHandle);
        }
    }

    @Transactional(readOnly=false)
    public void saveData(ExelawFeedback data, FeedbackIdModel idModel) {
        List checkResults;
        if (data == null) {
            return;
        }
        data.setId(idModel.getFeedbackId());
        if (data.getId() == null) {
            data.setCreateDate(new Date());
        } else {
            data.setUpdateDate(new Date());
        }
        this.feedbackService.saveOrUpdate(data);
        List handles = data.getHandles();
        if (CollUtil.isNotEmpty((Collection)handles)) {
            for (FeedbackHandle handle : handles) {
                FeedbackHandleLower handlelower;
                FeedbackUnHandle unhandle;
                FeedbackHandleWarn handleWarn;
                if (handle == null) continue;
                handle.setId(idModel.getHandleId());
                if (handle.getId() == null) {
                    handle.setFeedbackId(data.getId());
                    handle.setCreateDate(new Date());
                } else {
                    handle.setUpdateDate(new Date());
                }
                this.handleService.saveOrUpdate(handle);
                FeedbackHandleCheck handleCheck = handle.getHandleCheck();
                if (handleCheck != null) {
                    handleCheck.setId(idModel.getCheckId());
                    if (handleCheck.getId() == null) {
                        handleCheck.setFeedbackHandId(handle.getId());
                        handleCheck.setCreateDate(new Date());
                    } else {
                        handleCheck.setUpdateDate(new Date());
                    }
                    this.checkService.saveOrUpdate(handleCheck);
                }
                if ((handleWarn = handle.getHandleWarn()) != null) {
                    handleWarn.setId(idModel.getWarnId());
                    if (handleWarn.getId() == null) {
                        handleWarn.setFeedbackHandId(handle.getId());
                        handleWarn.setCreateDate(new Date());
                    } else {
                        handleWarn.setUpdateDate(new Date());
                    }
                    this.warnService.saveOrUpdate(handleWarn);
                }
                if ((unhandle = handle.getUnhandle()) != null) {
                    unhandle.setId(idModel.getUnhandleId());
                    if (unhandle.getId() == null) {
                        unhandle.setFeedbackHandId(handle.getId());
                        unhandle.setCreateDate(new Date());
                    } else {
                        unhandle.setUpdateDate(new Date());
                    }
                    this.unHandleService.saveOrUpdate(unhandle);
                }
                if ((handlelower = handle.getHandlelower()) == null) continue;
                handlelower.setId(idModel.getLowerId());
                if (handlelower.getId() == null) {
                    handlelower.setFeedbackHandId(handle.getId());
                    handlelower.setCreateDate(new Date());
                } else {
                    handlelower.setUpdateDate(new Date());
                }
                this.lowerService.saveOrUpdate(handlelower);
            }
        }
        if (CollUtil.isNotEmpty((Collection)(checkResults = data.getCheckResults()))) {
            for (FeedbackResult checkResult : checkResults) {
                if (checkResult == null) continue;
                if (checkResult.getId() == null) {
                    checkResult.setFeedbackId(data.getId());
                    checkResult.setCreateDate(new Date());
                } else {
                    checkResult.setUpdateDate(new Date());
                }
                this.resultService.saveOrUpdate(checkResult);
            }
        }
    }

    public List<ChuangdePushRiskData> getTodoUniqueId(String uniqueid) {
        return ((ExelawFeedbackMapper)this.baseMapper).getTodoUniqueId(uniqueid);
    }
}

