/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.advice;

import cn.smarthse.services.config.property.ProjectProperties;
import cn.smarthse.services.support.RequestBodyUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@ControllerAdvice(basePackages={"cn.smarthse.services.onlinemonitoring.controller"})
public class ControllerRequestBodyAdvice
implements RequestBodyAdvice {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ProjectProperties projectProperties;

    @Autowired
    public void setProjectProperties(ProjectProperties projectProperties) {
        this.projectProperties = projectProperties;
    }

    public boolean supports(MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        switch (this.projectProperties.getEnvEnum()) {
            case DEV: 
            case TEST: {
                return true;
            }
        }
        return false;
    }

    public HttpInputMessage beforeBodyRead(final HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) throws IOException {
        int len;
        RequestMapping requestMapping = methodParameter.getDeclaringClass().getAnnotation(RequestMapping.class);
        Object uri = "";
        if (requestMapping != null) {
            uri = (String)uri + requestMapping.value()[0];
        }
        if ((requestMapping = (RequestMapping)methodParameter.getMethodAnnotation(RequestMapping.class)) != null) {
            uri = (String)uri + requestMapping.value()[0];
        }
        InputStream body = httpInputMessage.getBody();
        InputStreamReader isr = new InputStreamReader(body, StandardCharsets.UTF_8);
        char[] buf = new char[1024];
        StringBuilder sb = new StringBuilder();
        while ((len = isr.read(buf, 0, buf.length)) != -1) {
            sb.append(buf, 0, len);
        }
        isr.close();
        final String s = sb.toString();
        this.logger.info("\u8bf7\u6c42uri:" + (String)uri + ",\u8bf7\u6c42\u6570\u636e:" + s);
        RequestBodyUtils.setRequestBody(s);
        return new HttpInputMessage(){

            public InputStream getBody() throws IOException {
                return new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
            }

            public HttpHeaders getHeaders() {
                return httpInputMessage.getHeaders();
            }
        };
    }

    public Object afterBodyRead(Object o, HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        return o;
    }

    public Object handleEmptyBody(Object o, HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        return o;
    }
}

