package cn.smarthse.services.wanda.api.service.threeTime;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.supervise.model.threeTimes.ThreeTimesSearchParam;
import cn.smarthse.services.wanda.api.entity.threeTime.ThreeTimeData;
import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Set;

/**
 * 三同时数据对接表(ThreeTimeData)表服务接口
 *
 * @author Supw
 * @since 2022-12-30 16:58:39
 */
public interface IThreeTimeDataService extends IService<ThreeTimeData> {
     int batchInsert(List<ThreeTimeData> list);


     List<ThreeTimeData> getList(ThreeTimesSearchParam searchParam);
     List<ThreeTimeData> getList(int start,int size,Long cid);
     List<ThreeTimeData> getList(List<Long> cidList);

    /**
     * 分页查询
     * @param searchParam
     * @return
     */
    PageInfo<ThreeTimeData> PageList(JqGridParam param, ThreeTimesSearchParam searchParam);

    /**
     * 根据id获取详细信息
     * @param id
     * @return
     */
    ThreeTimeData getInfoById(Long id);

    int removeData(List<Long> cids);

    List<ThreeTimeData> listPage(Integer start, Integer size,String unifiedSocialCc);

    ThreeTimeData getByprojectCode(String projectCode);

    List<ThreeTimeData> getNotSyncData(Long cid);

    int countNotSyncData(Long cid);

    void updateBatch(List<ThreeTimeData> threeTimeDataArrayList);

    ThreeTimeData getByCidAndProjectName(Long cid, String projectName);


    List<ThreeTimeData> listByCIdSet(Set<Long> cidSet);

    List<Long> getCidList(Integer pageSize,Long cid);

    void delBatch(List<ThreeTimeData> threeTimeDataArrayList);

}

