package cn.smarthse.services.wanda.api.service.irs;

import com.baomidou.mybatisplus.extension.service.IService;
import cn.smarthse.services.wanda.api.entity.irs.IrsMarketEntities;

import java.util.Date;
import java.util.List;

/**
 * (IrsMarketEntities)表服务接口
 *
 * @author Supw
 * @since 2024-10-28 09:32:02
 */
public interface IIrsMarketEntitiesService extends IService<IrsMarketEntities> {

    /**
     * 根据统一社会信用代码查询irs市场主体信息
     * @param unifiedSocialCc
     * @return
     */
    List<IrsMarketEntities> queryIrsMarketEntitiesByUnifiedSocialCc4irs(String unifiedSocialCc);

    /**
     * 查询市场主体信息，先查MySQL，再查irs
     * @param unifiedSocialCc
     * @return
     */
    List<IrsMarketEntities> queryIrsMarketEntitiesByUnifiedSocialCc(String unifiedSocialCc);

    void insertList(List<IrsMarketEntities> dataList);

    void removeByUnifiedSocialCcList(List<String> unifiedSocialCcList);

    /**
     * 更新企业营业状态
     * @param unifiedSocialCc
     */
    void updateCompanyBusinessState(String unifiedSocialCc);

    List<IrsMarketEntities> getIrsCompanyInfoByUccList(List<String> uccList);

    /**
     * 通过 company(源表) 补齐 company_lng_lat(目标表) 数据，仅当这条记录在目标表中不存在时才会插入。
     * @param cid 企业id
     */
    void initCompanyLngLat(Long cid);

    /**
     * 查询单位最新的经纬度更新时间
     * @param cid 企业id
     * @return null/单位最新的经纬度更新时间
     */
    Date getLastCompanyLngLatChangeInfo(Long cid);

    /**
     * 更新单位的经纬度 company 表
     * @param cid 企业id
     * @param lng 经度
     * @param lat 纬度
     */
    void updateLngLat(Long cid, String lng, String lat);

    /**
     * 更新单位的经纬度 company_lng_lat 表
     * @param cid 企业id
     * @param lng 经度
     * @param lat 纬度
     */
    void updateCompanyLngLat(Long cid, String lng, String lat);

    /**
     * 查询IRS注销的企业信用代码
     *
     * @param uccList 信用代码列表
     * @return IRS注销的企业信用代码
     */
    List<String> getIrsCloseCompanyUccList(List<String> uccList);
}

