package cn.smarthse.services.wanda.api.service;


import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.services.wanda.api.entity.WandaZywsReportInfo;
import cn.smarthse.services.wanda.api.entity.WandaZywsReportPoint;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.Date;
import java.util.List;

/**
 * @author Hello
 * @description 针对表【report_info(职业卫生-职业病危害因素检测)】的数据库操作Service
 * @createDate 2022-10-31 14:30:53
 */
public interface IWandaZywsReportInfoService extends IService<WandaZywsReportInfo> {

    Date getMaxBizDate();

    List<WandaZywsReportInfo> deleteAndSave(List<WandaZywsReportInfo> list);

    List<WandaZywsReportInfo> save(List<WandaZywsReportInfo> list);

    /**
     * 获取需要转换为风险数据数据
     *
     * @return {@link List}<{@link WandaZywsReportInfo}>
     * @param sourceId
     */
    List<WandaZywsReportInfo> getNeedConvertToRiskData(String sourceId);

    /**
     * 获取检测子表项
     *
     * @param reportIdList 报告id列表
     * @return {@link List}<{@link WandaZywsReportInfo}>
     */
    List<WandaZywsReportPoint> getWandaReportPointAndResult(List<String> reportIdList);

    /**
     * 新增机构信息(可能需要转过来的时候就去创建)
     * @param list
     */
    void addNewOrgForWandaReport(List<WandaZywsReportInfo> list);
}