package cn.smarthse.services.wanda.api.service;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.services.wanda.api.entity.WandaZywsCheck;
import cn.smarthse.services.wanda.api.entity.WandaZywsCheckSource;
import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author 吴嘉诚
 * @date 2023/3/3 9:40
 * @desc
 */
public interface IWandaZywsCheckService extends IService<WandaZywsCheck> {

    Date getMaxBizDate();

    int batchInsert(List<WandaZywsCheck> list);

    /**
     * 获取库中所有数据
     * String ：sourceId
     * WandaZywsCheck ： Max(loadTime)
     */
    Map<String, WandaZywsCheck> getDataMap(List<String> sourceIdList);

    /**
     * 批量更新（wanda_zyws_check, wanda_pull_detect）
     */
    void batchUpdate(List<WandaZywsCheck> updateList);

    /**
     * 校验并获取有效数据
     * <p>
     * （万达仓错误数据退回（先处理完所有数据，然后再推送错误数据））
     * 1.直接找到错误数据，然后剔除。
     * 2.添加记录时，如果有检测推送记录已经添加了，就判断loadTime是否最新，只保存最新的
     * <p>
     * 3.最后推送的时候，先删除中间产生的数据（删除未推送，同类型，但是loadTime不是最大的那个）
     * 4.推送未推送的数据
     * 数据没问题，就直接转换了。（可以加一步，把这一批的正常数据去逻辑删除一哈，这样库里有效数据就是未处理的）
     * <p>
     * 数据源json转换，应该只能获取到sourceId，loadTime
     *
     * @param map 地图
     * @return {@code Map<String, WandaZywsCheck> }
     * @author zhangxu
     * @date 2023-05-31
     */
    Map<String, WandaZywsCheck> verifyData(Map<String, WandaZywsCheck> map);

    Integer removeByColumn(List<String> list,String column,Boolean isLogic);

    /**
     * 批量添加CheckSource，并且逻辑删除以前的
     * @param list
     * @author zhangxu
     * @date 2024-10-14
     */
    void insertCheckSourceList(List<WandaZywsCheck> list);

    /**
     * 查询万达仓检测数据转换情况
     *
     * @param searchVo
     * @return {@link PageInfo}<{@link WandaZywsCheckSource}>
     */
    List<WandaZywsCheckSource> getListWandaCheckSource(WandaZywsCheckSource searchVo);

    PageInfo<WandaZywsCheckSource> pageWandaCheckSource(JqGridParam jParam, WandaZywsCheckSource searchVo);

    public Map<String,Object> getWandaCheckConvertMap() throws UnsupportedEncodingException;
}
