package cn.smarthse.services.wanda.api.service;

import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.modules.health.param.SearchParam;
import com.baomidou.mybatisplus.extension.service.IService;
import cn.smarthse.services.wanda.api.entity.WandaTrainData;

import java.util.Date;
import java.util.List;

/**
 * 万达仓培训数据-此表数据是 从万达仓拉取的培训数据(WandaTrainData)表服务接口
 *
 * @author Supw
 * @since 2023-06-12 14:33:57
 */
public interface IWandaTrainDataService extends IService<WandaTrainData> {

    List<WandaTrainData> listData(SearchParam searchParam);

    LayUiResponseResult<WandaTrainData> listPage(SearchParam searchParam);

    Date getMaxLoadTime();

    void saveList(List<WandaTrainData> reslutList);

    /**
     * 同步万达仓杭州培训数据到企业端，并化解风险
     * @param staffComCode 统一信用代码
     */
    void  mitigatingRisks(String staffComCode);

    /**
     * 获取暂时未使用的培训数据
     * @param staffComCode 统一信用代码
     * @return
     */
    List<WandaTrainData> mitigatingRisksList(String staffComCode);

    List<WandaTrainData> listByCertNum(List<String> certNumList);

}

