package cn.smarthse.services.wanda.api.service;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.param.WandaSearchParam;
import cn.smarthse.services.wanda.api.entity.WandaHealthCard;
import cn.smarthse.services.wanda.api.model.HealthCardSearchModel;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * <p>
 * 职业卫生-职业健康档案 服务类
 * </p>
 *
 * @author zhoulj@smarthse.cn
 * @since 2022-10-31
 */
public interface IWandaHealthCardService extends IBaseService<WandaHealthCard> {

    public Date getMaxLoadTime();


    public int batchInsert(List<WandaHealthCard> list);

    public WandaHealthCard getUserInfo(String username, String idNum);


    /**
     * 通过数据源获取个人健康档案列表
     * @param searchModel
     * @return
     */
    PageInfo<WandaHealthCard> getWandaHealthCardPage(HealthCardSearchModel searchModel);

    /**
     * 通过数据源id获取
     * @param sourceId
     * @return
     */
    WandaHealthCard getWandaHealthCard(String  sourceId);

    List<WandaHealthCard> getBySourceIds(Set<String> cardIds);

    int batchUpdate(List<WandaHealthCard> healthCardList);

    List<WandaHealthCard> getByCreditCode(String creditCode);

    PageInfo<WandaHealthCard> listPage(WandaSearchParam searchParam);
    Integer listCount(WandaSearchParam searchParam);

    List<WandaHealthCard> getByCreditCodeIdCard(Set<String> creditCodeSet, Set<String> idCardSet);

    List<WandaHealthCard> getWorkName(List<String> unifiedSocialCc, List<String> names);


    List<String> resetRepeatedData(List<String> unifiedSocialCcs);
}
