package cn.smarthse.services.wanda.api.service;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.services.wanda.api.entity.WandaDictValue;

import java.util.List;
import java.util.Map;

/**
 * 字典服务--wanda
 *
 * @author zhangxu
 * @date 2023-04-21
 */
public interface IWandaDictionaryService extends IBaseService<WandaDictValue> {

    /*
name	type_code
性别编码	7
检查类型编码	12
体检类型编码	13
体检结论编码	19
职业禁忌症编码	20
职业病分类和目录编码	21
申报类型编码	60
经济类型编码	2
行业类别编码	3
企业规模编码	4
     */

    /**
     * 通过缓存获得字典值----字典名称
     *
     * @param typeName 字典名称
     * @return {@link Map }<{@link String },{@link String }>
     * @author zhangxu
     * @date 2023-04-21
     */
    public Map<String,String> getDictValueByNameCache(String typeName);

    /**
     * 通过缓存获得字典值----字典编码
     *
     * @param code 字典编码
     * @return {@link Map }<{@link String },{@link String }>
     * @author zhangxu
     * @date 2023-04-21
     */
    public Map<String,String> getDictValueByCodeCache(Long code);

    /**
     * 通过缓存获得字典值----字典编码集合
     *
     * @param codeList 字典编码集合
     * @return {@link Map }<{@link Long },{@link Map }<{@link String },{@link String }>>
     * @author zhangxu
     * @date 2023-04-21
     */
    public Map<Long,Map<String,String>> getDictValueByCodesCache(List<Long> codeList);

    /**
     * 通过缓存获得字典值----字典名称集合
     *
     * @param typeNameList 字典名称集合
     * @return {@link Map }<{@link String },{@link Map }<{@link String },{@link String }>>
     * @author zhangxu
     * @date 2023-04-21
     */
    public Map<String,Map<String,String>> getDictValueByNamesCache(List<String> typeNameList);


    /**
     * 获取接触危害因素名称字符串
     *
     * @param codeList 代码列表
     * @return {@link String }
     * @author zhangxu
     * @date 2023-04-21
     */
    public String getContactHazardCodes(List<String> codeList);

    /**
     * 从缓存中获取所有危险因素（wanda_risk_factors）
     *
     * @return {@link Map }<{@link String },{@link String }>
     * @author zhangxu
     * @date 2023-04-21
     */
    public Map<String, WandaDictValue> getAllWandRiskFactorByCache();

    /**
     * 从缓存中获取所有危险因素（wanda_zyws_report_risk_factors）
     *
     * @return {@link Map }<{@link String },{@link String }>
     * @author zhangxu
     * @date 2023-04-21
     */
    public Map<String, WandaDictValue> getAllWandZywsReportRiskFactorByCache();

    /**
     * 得到所有风险因素（occupational_risk_factors）
     *
     * @param cid cid
     * @return {@link List}<{@link HarmFactor}>
     */
    List<HarmFactor> getOwnHarmFactorList(Long cid);

}
