package cn.smarthse.services.wanda.api.service;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyDeclareModel;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.supervise.entity.company.Company;
import cn.smarthse.modules.health.supervise.entity.statistics.DeclareAreaModel;
import cn.smarthse.modules.health.vo.base.company.gradev3.GradeSearchV314;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.services.wanda.api.model.WandaDeclareVo;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author xiaoyi
 * @Title: IWandaDeclareService
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2022-10-31
 */


public interface IWandaDeclareService extends IBaseService<WandaDeclare> {
    public Date getMaxBizDate();


    public int batchInsert(List<WandaDeclare> list);

    /**
     * 分页获取职业病危害项目申报的列表
     * @param jparam
     * @param wandaDeclareSearch
     * @return
     */
    public PageInfo<WandaDeclare> getWandaDeclareList(JqGridParam jparam, SearchParam searchParam);

    /**
     * 获取最早的申报时间
     *
     * @param cidList
     * @param map
     * @return {@code Map<Long,Date> }
     * @author zhangxu
     * @date 2024-06-18
     */
    public Map<Long,Date> getEarliestList(List<Long> cidList,Map<String,Object> map);

    /**
     * @Comments:  <申报数据统计>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2023/5/18-13:55
     * @param cid
     * @return int
     */
    public int countWandaDeclare(Long cid);


    public Set<Long> getLastUpdateCid(Date updateDate);

    /**
     * 获取详情
     * @param declareId
     * @return
     */
    public WandaDeclare getWandaDeclareDetails(Long declareId);

    /**
     * 根据cid获取最新企业申报数据
     * @param cid
     * @return
     */
    WandaDeclare getLastOneWandaDeclareByCid(Long cid);

    /**
     * 根据统一社会信用代码获取cid（复制cn.smarthse.services.wanda.pushdata.hse.dao.WandaCompanyMapper 修改时注意也修改那边）
     * @param code
     * @return
     */
    List<CompanySuperviseModel> getCidByCode(String code);

    /**
     * 风险化解管理自动验收查询申报接口
     * @param cidList
     * @return
     */
    Map<Long, WandaDeclare> getDeclareMapByCid(List<Long> cidList);

    /**
     * V3.2.2.1 有申报数据的企业全部转为分类企业，修改老数据
     */
    void refreshOldWandaDeclareData(String creditCode);

    /**
     * 2024年2月23日申报数据入库
     */
    void warehousingDeclare20240223(String creditCode);
    void importCompanyDeclare20240730(String creditCode);

    /**
     * 带入库原因的导入
     * @param creditCode
     */
    void importCompanyWithReason(String creditCode);


    Map<Long, Integer> countByCids(List<Long> cids);

    List<ComplianceCompanyDeclareModel> getComplianceCompanyDeclareModel(List<Long> cids);

    List<WandaDeclare> getListByCidList(List<Long> cidList);
    List<WandaDeclare> getListByCreditCodeList(List<String> creditCodeList);

    int updateCidBatch(List<WandaDeclare> list);

    DeclareAreaModel statisticsDeclareAreaHeadData(SearchParam searchParam);

    /**
     * 处理【辖区新增申报企业统计】页头部中，其他需要返回的字段。
     * @param declareHead 头部信息
     * @param searchAll   查询：【“接害人数≥3人或接害人数未明确的”新增申报企业数】的入参
     * @param searchPass  查询：【“接害人数≥3人或接害人数未明确的”新增申报企业（审核通过）数】的入参
     */
    DeclareAreaModel processHeadOtherFieldsNeedReturn(DeclareAreaModel declareHead, GradeSearchV314 searchAll, GradeSearchV314 searchPass);

    List<DeclareAreaModel> statisticsDeclareAreaListData(SearchParam searchParam);
    PageInfo<DeclareAreaModel> statisticsDeclareAreaListPage(SearchParam searchParam);

    /**
     * 处理【辖区新增申报企业统计】页列表中，其他需要返回的字段。
     * @param declarePage 列表分页信息
     * @param searchAll   查询：【“接害人数≥3人或接害人数未明确的”新增申报企业数】的入参
     * @param searchPass  查询：【“接害人数≥3人或接害人数未明确的”新增申报企业（审核通过）数】的入参
     */
    PageInfo<DeclareAreaModel> processListOtherFieldsNeedReturn(PageInfo<DeclareAreaModel> declarePage, GradeSearchV314 searchAll, GradeSearchV314 searchPass);

    PageInfo<DeclareAreaModel> statisticsDeclareAreaListHistoryPage(SearchParam searchParam);

    List<DeclareAreaModel> statisticsDeclareAreaListHistoryData(SearchParam searchParam);

    List<AreaModel> listHistoryAreaName(SearchParam searchParam);

    DeclareAreaModel statisticsDeclareAreaHeadDataHistory(SearchParam searchParam);

    /**
     * 获取未入库的万达申报企业数据
     * @param jparam
     * @param searchParam
     * @param isCount
     * @return
     */
    PageInfo<WandaDeclare> getNoMatchedConvertList(JqGridParam jparam, SearchParam searchParam,Boolean isCount);

    WandaDeclareVo getWandaDeclareDetailsInfo(Long declareId);

    PageInfo<Company> getComopanyByUnitCode(JqGridParam jparam, SearchParam searchParam);

    PageInfo<CompanySuperviseModel> getComopanyManualDeclare(JqGridParam jparam, SearchParam searchParam,Boolean isCount);

    /**
     * 万达申报企业信息入库（浙里卫企）
     * @param company
     * @param loginUserId
     */
    void wandaDeclareInfoGenerate(CompanySuperviseModel company, Long loginUserId,String loginUserName,String ip);

    void wandaDeclareInfoDraft(CompanySuperviseModel company, Long loginUserId);
}
