package cn.smarthse.services.wanda.api.service;

import cn.smarthse.services.wanda.api.entity.WandaCheckReturn;

import java.util.List;
import java.util.Set;

public interface IWandaCheckReturnService {

    /**
     * 检测消息退回万达仓接口
     * 单个退回
     *
     * @param data
     * @Return 1-成功 0-失败
     */
    int backToWanda(WandaCheckReturn data);

    /**
     * 检测消息退回万达仓接口,并修改建安库
     * 建安数据传到汝城，然后再到职业健康在线，然后又回到建安
     *
     * @return 失败的id, 如果返回返回0L的话表示发生异常
     */
    int backToGiian(WandaCheckReturn data);

    /**
     * 检测消息退回建安接口BIZ_037_ZYWS_RI_RETRUN
     * 建安数据传到汝城，然后再到职业健康在线，然后又回到建安
     *
     * @return 失败的id, 如果返回返回0L的话表示发生异常
     */
    int backToGiian4181(WandaCheckReturn data);

    /**
     * 检测消息退回万达仓接口
     * 每次调用接口的WandaCheckReturn中类型type要一样
     * 批量退回
     *
     * @param list
     * @return 失败的id, 如果返回返回0L的话表示发生异常
     */
    Set<Long> backToWanda(List<WandaCheckReturn> list);

}
