package cn.smarthse.services.wanda.api.service;


import cn.smarthse.services.wanda.api.entity.WandaCheckBackPushLog;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;


/**
 * @author zhangxu
 * @date 2024-04-06
 */
public interface IWandaCheckBackPushLogService extends IService<WandaCheckBackPushLog> {

    /**
     * 退回添加接口（去重）
     *
     * @param list
     * @author zhangxu
     * @date 2024-04-06
     */
    void distinctAddPushLog(List<WandaCheckBackPushLog> list, Integer type);

    /**
     * 万达转检测时掉的状态返回接口
     * @param collect
     * @param reasonSupply
     * @author zhangxu
     * @date 2024-04-07
     */
    void addPushLogByConvert(List<String> collect, String reasonSupply);

    /**
     * 添加已经审核通过的检测数据消息
     *
     * @param wandaZywsCheckIdList
     * @author zhangxu
     * @date 2024-04-07
     */
    void addPushLogByAlreadyPass(List<Long> wandaZywsCheckIdList);

    /**
     * 推送数据到万达仓
     *
     * @author zhangxu
     * @date 2024-04-06
     */
    void pushNotBackCheckData();

    /**
     * 生成副本表，退回记录只存最新的一份
     */
    void generateLastCheckBackPushLog(List<String> list);


}
