package cn.smarthse.services.wanda.api.service;

import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: IWandaBaseService
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 57
 * @since 2023/2/21-13:57
 */
public interface IWandaBaseService<T> {
    /**
     * 分页查询主表数据
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2023/2/21-13:59
     * @param startValue     根据业务id排序 asc, start时间取>=,可为null第一次取数据的情况;
     * @param page      页数
     * @param pageSize  每页行数
     * @return
    */
    public PageInfo<T> pageMainTableById(String startValue, Integer page, Integer pageSize);
    /**
     * 分页查询主表数据
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2023/2/21-13:59
     * @param startValue     根据业务时间排序 asc, start时间取>=,可为null第一次取数据的情况;
     * @param page      页数
     * @param pageSize  每页行数
     * @return
     */
    public PageInfo<T> pageMainTableByDate(Date startValue, Integer page, Integer pageSize);

    /**
     * @Comments:  <数据字典映射>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2023/2/21-14:20
     * @param source
     * @return T
    */
    public T mappingDict(T source);
    /**
     * @Comments:  <子表数据>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2023/2/21-13:59
     * @param mainTableIdSet    主表id集合
     * @return
    */
    public List<T> listSbuTable(Set<Long> mainTableIdSet);

}
