package cn.smarthse.services.wanda.api.service;

import cn.smarthse.services.wanda.api.entity.ChuangdeParam;
import cn.smarthse.services.wanda.api.entity.ChuangdePushRiskData;
import com.baomidou.mybatisplus.extension.service.IService;
import com.fasterxml.jackson.core.JsonProcessingException;

import javax.xml.bind.JAXBException;
import java.util.List;

/**
 * 推送--》风险线索数据
 * @author zhangxu
 * @date 2024-09-13
 */
public interface IRiskCluePushCdService extends IService<ChuangdePushRiskData> {
    /**
     * 批量推送接口
     *
     * @param riskClueList
     * @author zhangxu
     * @date 2024-09-14
     */
    void push(List<ChuangdePushRiskData> riskClueList);

    /**
     * 推送风险线索
     *
     * @param param
     * @return 返回这些更新之后的数据
     * @throws JAXBException
     * @throws JsonProcessingException
     */
    List<ChuangdePushRiskData> pushRiskClue(ChuangdeParam param);


    /**
     * 将推送成功的数据设置为启动执法
     *
     * @author zhangxu
     * @date 2024-09-14
     */
    void changePushDataLawStatus(ChuangdeParam param);

    /**
     * 批量转换风险状态为启动执法(注意新建企业风险没有启动执法，批量执行的时候注意哈)
     * @param reformIds
     */
    void changeLawStatus(List<Long> reformIds);

    void removePushRiskData(Long workId, List<Long> idList, List<Long> companyIdList);
}
