package cn.smarthse.services.wanda.api.service;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.services.wanda.api.entity.ChuangdeParam;
import cn.smarthse.services.wanda.api.entity.ChuangdePullRiskClue;
import cn.smarthse.services.wanda.api.entity.ChuangdeRiskArea;
import cn.smarthse.services.wanda.api.entity.ChuangdeRiskOrg;
import cn.smarthse.services.wanda.api.model.ChuangdePushRiskDataVo;
import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

/**
 * 风险线索采集-单个风险的采集数据
 * @author zhangxu
 * @date 2024-09-13
 */
public interface IRiskClueCollectCdService extends IService<ChuangdePullRiskClue> {


    /**
     * 统计待推送的风险并且合并
     *
     * @param param 参数ruleId必填
     * @see cn.smarthse.services.chuangde.constants.RiskInfoConstants
     * @author zhangxu
     * @date 2024-10-24
     */
    void collectData(ChuangdeParam param);

    /**
     * 统计需要推送的风险
     *
     * @param param
     * @return
     * @author zhangxu
     * @date 2024-10-24
     */
    List<ChuangdePullRiskClue> collectStep1Data(ChuangdeParam param);

    /**
     * 合并需要推送的风险，以企业为单位
     * @param riskList
     * @author zhangxu
     * @date 2024-10-24
     */
    void collectStep2Data(List<ChuangdePullRiskClue> riskList);

    /**
     * 标玺疑似职业病合成推送数据
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @date 2024-10-24
     */
    void collectDataBxZybSmm();


   /**
     * 获取创得的地区和机构信息
     * @return {@code Map<Long, ChuangdeRiskArea> }
     * @author zhangxu
     * @date 2024-10-24
     */
    Map<Long, ChuangdeRiskArea> getCdAreaMap();
    Map<Long, ChuangdeRiskOrg> getCdorgMap();

    /**
     * 查询待推送风险 isPush区分查那个表
     * @param jqGridParam
     * @param param
     * @return {@code PageInfo<ChuangdePushRiskDataVo> }
     * @author zhangxu
     * @date 2024-11-04
     */
    PageInfo<ChuangdePushRiskDataVo> getPageCollectData(JqGridParam jqGridParam, ChuangdeParam param);
    List<ChuangdePushRiskDataVo> getListCollectData(ChuangdeParam param);

    /**
     * 删除合并前的个别风险
     *
     * @param workId
     * @param idList
     * @param companyIdList
     * @author zhangxu
     * @date 2024-11-04
     */
    void removePullRiskClue(Long workId, List<Long> idList, List<Long> companyIdList);

    /**
     * 根据条件查询，合并需要推送的风险
     *
     * @param workId
     * @author zhangxu
     * @date 2024-11-04
     */
    void addCollectStep2Data(Long workId);

    /**
     * 更新24年中止风险报表
     * @param cidList
     * @author zhangxu
     * @date 2025-02-11
     */
    void updateCompanyStopRisk2024Data(List<Long> cidList);
}
