package cn.smarthse.services.wanda.api.service;

import cn.smarthse.services.wanda.api.entity.CompanyUnresolvedRiskWork;
import cn.smarthse.services.wanda.api.entity.CompanyUnresolvedRiskWorkVo;
import cn.smarthse.services.wanda.api.model.CompanyUnresolvedRiskWorkModel;
import cn.smarthse.services.wanda.api.vo.RiskCompanyBaseVo;
import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Set;

/**
 * @ClassName ICompanyUnresolvedRiskWorkService
 * @Description 未及时化解风险推送记录清单service
 * @Author hxw
 * @Date 2024年10月29日 13:49
 **/
public interface ICompanyUnresolvedRiskWorkService extends IService<CompanyUnresolvedRiskWork> {

    CompanyUnresolvedRiskWork selectById(Long workId);
    /*
     * 根据企业名称和统一信用代码查询
     * @return null
     * @author hxw
     * @date 2024/10/29 14:49
     **/
    PageInfo<CompanyUnresolvedRiskWorkVo> getRiskWorkPage(CompanyUnresolvedRiskWorkModel model);
    List<CompanyUnresolvedRiskWorkVo> getRiskWorkList(Long workId);

    Long addRiskWork(Long loginUserId,String ruleId,Long loginUserAreaId);

    PageInfo<RiskCompanyBaseVo> getRiskCompanyList(CompanyUnresolvedRiskWorkModel model);

    Integer getRiskCompanyListCount(CompanyUnresolvedRiskWorkModel model);

    Integer getListByWorkAndCid(Long id, Long workId);

    Integer isRiskCompany(Integer pushDate,Long id,String ruleId);

    Integer batchUpdateWorkProposePush(Set<Long> finalDataList, Long workId, Long userId);

    void removeRiskWork(Long workId, Long loginUserId,Byte loginAreaLevle);

    CompanyUnresolvedRiskWork getRiskWorkById(Long workId);

    void updatePushStatus(Long workId, Integer status, String reason, Long operateId, String operateName, String organizationName);

    int isVictimizationCompany(Long id);

    int getCountByWorkAndUnifiedSocialCcOrName(String keyWord, Long workId);

    void addPushFile(Long fileId, Long workId,Long loginUserId,Byte loginAreaLevle);

    Integer isVictimizationCompany2024(Long id, Long workId);
}
