package cn.smarthse.services.wanda.api.model;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ClassName WandaDeclareVo
 * @Description 万达申报企业信息详细返回
 * @Author hxw
 * @Date 2025/1/13 9:02
 */
@Data
public class WandaDeclareVo implements Serializable {
    
    private static final long serialVersionUID = 1L;

    @Id
    private Long id;
    /**
     * 企业id
     */
    private Long cid;
    /**
     * 申报记录唯一标识sourceId
     */
    private String sourceId;

    /**
     * 申报时间
     */
    private Date declareTime;

    /**
     * 申报年份
     */
    private String declareYear;
    /**
     * 申报类型 0:初次申报,1:变更申报, 2:年度变更
     */
    private String declareType;
    /**
     * 变更原因
     */
    private String changeReason;

    /**
     * 单位名称
     */
    private String empName;
    /**
     * 统一社会信用代码
     */
    private String creditCode;
    /**
     * 用人单位注册地
     */
    private String areaCode;
    /**
     * 单位注册地址
     */
    private String regAddr;
    /**
     * 工作场所地址
     */
    private String workAddr;
    /**
     * 工作场所详细地址
     */
    private String workAddrDetail;
    /**
     * 企业规模
     */
    private String enterpriseSize;
    /**
     * 企业规模
     */
    private String scale;
    /**
     * 行业分类
     */
    private String industryCode;
    /**
     * 经济类型
     */
    private String economic;
    /**
     * 法定代表人
     */
    private String legalPerson;
    /**
     * 法定代表人联系电话
     */
    private String legalPhone;
    /**
     * 职业卫生管理联系人
     */
    private String healthManager;
    /**
     * 职业卫生管理联系人电话
     */
    private String healthManagerPhone;

    private Long manageMajorStaffCount;

    /**
     * 职业卫生管理人数-兼职
     */
    private Long managePluralityStaffCount;

    /**
     * 企业主要负责人
     */
    private String mainLeaderName;

    /**
     * 负责人手机号码
     */
    private String mainLeaderTel;

    private String manageOrg;
    
    private String manageOrgFiles;

    private List<SysFileModel> manageOrgFileList;

    /**
     * 本单位在册职工总数
     */
    private String staffNum;


    @ApiModelProperty(value = "省编号")
    protected Long provinceId;
    @ApiModelProperty(value = "省名称")
    protected String provinceName;
    @ApiModelProperty(value = "市编号")
    protected Long cityId;
    @ApiModelProperty(value = "市名称")
    protected String cityName;
    @ApiModelProperty(value = "区域ID")
    protected Long areaId;
    @ApiModelProperty(value = "区域名称")
    protected String areaName;
    @ApiModelProperty(value = "乡镇街道编号")
    protected Long streetId;
    @ApiModelProperty(value = "乡镇街道名称")
    protected String streetName;
    @ApiModelProperty(value = "行政区域详情：原始存放的编号")
    protected Long areaDetailId;
    @ApiModelProperty(value = "行政区域 层级")
    protected Byte areaLevel;

    @ApiModelProperty(value = "注册地址省编号")
    protected Long registerProvinceId;
    @ApiModelProperty(value = "注册地址省名称")
    protected String registerProvinceName;
    @ApiModelProperty(value = "注册地址市编号")
    protected Long registerCityId;
    @ApiModelProperty(value = "注册地址市名称")
    protected String registerCityName;
    @ApiModelProperty(value = "注册地址区域ID")
    protected Long registerAreaId;
    @ApiModelProperty(value = "注册地址区域名称")
    protected String registerAreaName;
    @ApiModelProperty(value = "注册地址乡镇街道编号")
    protected Long registerStreetId;
    @ApiModelProperty(value = "注册地址乡镇街道名称")
    protected String registerStreetName;
    @ApiModelProperty(value = "注册地址行政区域详情：原始存放的编号")
    protected Long registerAreaDetailId;
    @ApiModelProperty(value = "注册地址行政区域 层级")
    protected Byte registerAreaLevel;

    @ApiModelProperty(value = "企业规模(名称）")
    protected String scaleName;

    @ApiModelProperty(value = "corp_type 行业分类名称（sys_param.param_code）")
    protected String industryCategoryName;

    @ApiModelProperty(value = "注册类型名称")
    protected String registerTypeName;
    
    private Integer legalCardType;
    
    private String legalCardId;

    private String legalCardIdFull;
}