package cn.smarthse.services.wanda.api.enums;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * @ClassName WandaTJTypeEnum
 * @Description 万达体检数据的类型
 * @Author 曾华川
 * @Date 2024年06月25日 17:06
 **/
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum WandaTJTypeEnum {

    SG_BEFORE_TJ("1", "上岗前职业健康检查"),
    ZG_TJ("2", "在岗期间职业健康检查"),
    LG_TJ("3", "离岗时职业健康检查"),
    LG_AFTER_TJ("4", "离岗后健康检查"),
    YJ_TJ("5", "应急健康检查"),
    ;

    private String type;
    private String name;

    public static String getNameByType(String type){
        if (type != null){
            for (WandaTJTypeEnum typeEnum : values()) {
                if (typeEnum.type.equals(type)){
                    return typeEnum.name;
                }
            }
        }
        return "";
    }

    WandaTJTypeEnum(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
