package cn.smarthse.services.wanda.api.enums;

import cn.smarthse.common.util.DateUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * WandaZywsReportInfo种的checkType （检测类别）
 *
 * @author DELL
 * @date 2023/08/14
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum WandaReportCheckTypeEnm {
    DQ("定期检测",2L,"10"),
    JD("监督检测",null,"20"),
    PJ("评价检测",null,"30"),
    XZ("现状评价",3L,"31"),
    KZ("控制效果评价",4L,"32"),
    YP("预评价",null,"33")
    ;

    // 成员变量
    private String name;
    private Long ownCode;
    private String wandaCode;

    WandaReportCheckTypeEnm(String name, Long ownCode, String wandaCode) {
        this.name = name;
        this.ownCode = ownCode;
        this.wandaCode = wandaCode;
    }

    // 普通方法
    public static String getNameByOwnCode(Long ownCode) {
        if (ownCode == null) {
            return null;
        }
        for (WandaReportCheckTypeEnm c : WandaReportCheckTypeEnm.values()) {
            if (c.getOwnCode().equals(ownCode)) {
                return c.name;
            }
        }
        return null;
    }

    // 普通方法
    public static String getNameByWandaCode(String wandaCode) {
        if (StringUtils.isBlank(wandaCode)) {
            return null;
        }
        for (WandaReportCheckTypeEnm c : WandaReportCheckTypeEnm.values()) {
            if (c.getWandaCode().equals(wandaCode)) {
                return c.name;
            }
        }
        return null;
    }

    // 普通方法
    public static Long getOwnCodeByWandaCode(String wandaCode) {
        if (StringUtils.isBlank(wandaCode)) {
            return null;
        }
        for (WandaReportCheckTypeEnm c : WandaReportCheckTypeEnm.values()) {
            if (c.getWandaCode().equals(wandaCode)) {
                return c.ownCode;
            }
        }
        return null;
    }



    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getOwnCode() {
        return ownCode;
    }

    public void setOwnCode(Long ownCode) {
        this.ownCode = ownCode;
    }

    public String getWandaCode() {
        return wandaCode;
    }

    public void setWandaCode(String wandaCode) {
        this.wandaCode = wandaCode;
    }
}
