package cn.smarthse.services.wanda.api.enums;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * WandaZywsReportResult种的resultItemCode（结果项编码结果项编码）
 *
 * @author DELL
 * @date 2023/08/14
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum WandaReportCheckItemEnm {
    wandaItem101("MAC","101"),
    wandaItem102("C-TWA","102"),
    wandaItem103("C-STEL","103"),
    wandaItem104("C-TWA总尘","104"),
    wandaItem105("C-TWA呼尘","105"),
    wandaItem106("电场强度","106"),
    wandaItem107("磁场强度","107"),
    wandaItem108("照射量","108"),
    wandaItem109("辐照度","109"),
    wandaItem110("日剂量","110"),
    wandaItem111("8h平均功率密度","111"),
    wandaItem112("非8h平均功率密度","112"),
    wandaItem113("短时间接触功率密度","113"),
    wandaItem114("WBGT","114"),
    wandaItem115("8h等效声级","115"),
    wandaItem116("40h等效声级","116"),
    wandaItem117("声压级峰值","117"),
    wandaItem118("等能量频率计权振动加速度","118"),
    wandaItem119("干球温度","119"),
    wandaItem120("相对湿度","120"),
    wandaItem121("风速","121"),
    wandaItem122("体力劳动强度指数","122"),
    wandaItem123("最大心率","123"),
    wandaItem124("平均心率","124"),
    wandaItem125("能量消耗","125"),
    wandaItem126("C-PE","126"),
    wandaItem127("C-PE总尘","127"),
    wandaItem128("C-PE呼尘","128"),
    wandaItem129("峰接触浓度","129")
    ;

    // 成员变量
    private String name;
    private String wandaCode;

    WandaReportCheckItemEnm(String name, String wandaCode) {
        this.name = name;
        this.wandaCode = wandaCode;
    }

    // 普通方法
    public static String getNameByWandaCode(String wandaCode) {
        if (StringUtils.isNotBlank(wandaCode)) {
            return null;
        }
        for (WandaReportCheckItemEnm c : WandaReportCheckItemEnm.values()) {
            if (c.getWandaCode().equals(wandaCode)) {
                return c.name;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWandaCode() {
        return wandaCode;
    }

    public void setWandaCode(String wandaCode) {
        this.wandaCode = wandaCode;
    }

}
