package cn.smarthse.services.wanda.api.enums;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum WandDealStateEnm {

    one("未同步到企业",1),
    two("已同步到企业检测暴露但还未使用分类（未审核）",2),
    three("同步到企业检测暴露并已使用分类（已审核）",3),
    four("系统退回（未同步至企业）",4),
    five    ("监管退回 （已同步至企业）",5);

    // 成员变量
    private String name;
    private Integer code;
    // 构造方法

    private WandDealStateEnm(String name, Integer code) {
        this.name = name;
        this.code = code;
    }
    // 普通方法
    public static String getName(Integer code) {
        if (code == null) {
            return null;
        }
        for (WandDealStateEnm c : WandDealStateEnm.values()) {
            if (c.getCode().equals(code)) {
                return c.name;
            }
        }
        return null;
    }


    // get set 方法
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public Integer getCode() {
        return code;
    }
    public void setCode(Integer code) {
        this.code = code;
    }
}
