package cn.smarthse.services.wanda.api.enums;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum WandCheckBackTypeEnm {

    normal("监管端审核退回",1),
    verifyMain("检测主表数据校验错误",2),//数据没同步过来
    verifySecondary("检测子表数据校验错误,请核对所有子表类似错误",3),//子表数据不会同步，而且会删除主表数据
    workError("检测子表填写错误",4),//因为主表子表数据已经同步到库里了，这是填写问题，比如车间岗位等，不能删除，不然找不到原因
    noData("检测主表数据已同步，无有效子表数据",5),//主表数据还在
    empty("数据流转状态信息反馈",6)
    ;

    // 成员变量
    private String name;
    private Integer code;
    // 构造方法

    private WandCheckBackTypeEnm(String name, Integer code) {
        this.name = name;
        this.code = code;
    }
    // 普通方法
    public static String getName(Integer code) {
        if (code == null) {
            return null;
        }
        for (WandCheckBackTypeEnm c : WandCheckBackTypeEnm.values()) {
            if (c.getCode().equals(code)) {
                return c.name;
            }
        }
        return null;
    }


    // get set 方法
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public Integer getCode() {
        return code;
    }
    public void setCode(Integer code) {
        this.code = code;
    }
}
